/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.Weigher;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.BaseCache;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.ClockProPlusEviction;
import org.cache2k.core.Eviction;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntHeapCache;
import org.cache2k.core.IntWiredCache;
import org.cache2k.core.LongHeapCache;
import org.cache2k.core.LongWiredCache;
import org.cache2k.core.SegmentedEviction;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.WiredCache;
import org.cache2k.core.event.AsyncDispatcher;
import org.cache2k.core.event.AsyncEvent;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.util.ClockDefaultImpl;
import org.cache2k.core.util.InternalClock;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.AsyncCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.FunctionalCacheLoader;

public class InternalCache2kBuilder<K, V> {
    private static final AtomicLong DERIVED_NAME_COUNTER = new AtomicLong(System.currentTimeMillis() % 1234L);
    private static final ThreadPoolExecutor DEFAULT_ASYNC_LISTENER_EXECUTOR = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 21L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), HeapCache.TUNABLE.threadFactoryProvider.newThreadFactory("cache2k-listener"), new ThreadPoolExecutor.AbortPolicy());
    private CacheManagerImpl manager;
    private Cache2kConfiguration<K, V> config;

    public InternalCache2kBuilder(Cache2kConfiguration<K, V> _config, CacheManager _manager) {
        this.config = _config;
        this.manager = (CacheManagerImpl)(_manager == null ? CacheManager.getInstance() : _manager);
    }

    private static boolean isBuilderClass(String _className) {
        return Cache2kBuilder.class.getName().equals(_className);
    }

    private static String deriveNameFromStackTrace() {
        boolean _builderSeen = false;
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (_builderSeen && !InternalCache2kBuilder.isBuilderClass(e.getClassName())) {
                String _methodName = e.getMethodName();
                if (_methodName.equals("<init>")) {
                    _methodName = "INIT";
                }
                if (_methodName.equals("<clinit>")) {
                    _methodName = "CLINIT";
                }
                return "_" + e.getClassName() + "." + _methodName + "-" + e.getLineNumber() + "-" + Long.toString(DERIVED_NAME_COUNTER.incrementAndGet(), 36);
            }
            _builderSeen = InternalCache2kBuilder.isBuilderClass(e.getClassName());
        }
        throw new IllegalArgumentException("name missing and automatic generation failed");
    }

    private void configureViaSettersDirect(HeapCache<K, V> c) {
        if (this.config.getLoader() != null) {
            CacheLoader _loader;
            Object obj = c.createCustomization(this.config.getLoader());
            if (obj instanceof CacheLoader) {
                _loader = (CacheLoader)obj;
                c.setAdvancedLoader(new AdvancedCacheLoader<K, V>(){

                    public V load(K key, long currentTime, CacheEntry<K, V> currentEntry) throws Exception {
                        return _loader.load(key);
                    }
                });
            } else {
                _loader = (FunctionalCacheLoader)obj;
                c.setAdvancedLoader(new AdvancedCacheLoader<K, V>((FunctionalCacheLoader)_loader){
                    final /* synthetic */ FunctionalCacheLoader val$_loader;
                    {
                        this.val$_loader = functionalCacheLoader;
                    }

                    public V load(K key, long currentTime, CacheEntry<K, V> currentEntry) throws Exception {
                        return this.val$_loader.load(key);
                    }
                });
            }
        }
        if (this.config.getAdvancedLoader() != null) {
            AdvancedCacheLoader _loader = (AdvancedCacheLoader)c.createCustomization(this.config.getAdvancedLoader());
            WrappedAdvancedCacheLoader<K, V> _wrappedLoader = new WrappedAdvancedCacheLoader<K, V>(c, _loader);
            c.setAdvancedLoader(_wrappedLoader);
        }
        if (this.config.getExceptionPropagator() != null) {
            c.setExceptionPropagator((ExceptionPropagator)c.createCustomization(this.config.getExceptionPropagator()));
        }
        c.setCacheConfig(this.config);
    }

    private HeapCache<K, V> constructImplementationAndFillParameters(Class<?> cls) {
        if (!HeapCache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Specified impl not a cache" + cls.getName());
        }
        try {
            return (HeapCache)cls.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not able to instantiate cache implementation", e);
        }
    }

    public Cache<K, V> build() {
        Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.augmentConfiguration(this.manager, this.config);
        return this.buildAsIs();
    }

    public Cache<K, V> buildAsIs() {
        if (this.config.getValueType() == null) {
            this.config.setValueType(Object.class);
        }
        if (this.config.getKeyType() == null) {
            this.config.setKeyType(Object.class);
        }
        if (this.config.getName() == null) {
            this.config.setName(InternalCache2kBuilder.deriveNameFromStackTrace());
        }
        this.checkConfiguration();
        Class<HeapCache> _implClass = HeapCache.class;
        Class _keyType = this.config.getKeyType().getType();
        if (_keyType == Integer.class) {
            _implClass = IntHeapCache.class;
        } else if (_keyType == Long.class) {
            _implClass = LongHeapCache.class;
        }
        BaseCache _cache = this.constructImplementationAndFillParameters(_implClass);
        InternalClock _timeReference = (InternalClock)_cache.createCustomization(this.config.getTimeReference());
        if (_timeReference == null) {
            _timeReference = ClockDefaultImpl.INSTANCE;
        }
        HeapCache<K, V> bc = _cache;
        bc.setCacheManager(this.manager);
        if (this.config.hasCacheClosedListeners()) {
            bc.setCacheClosedListeners((Collection<CustomizationSupplier<CacheClosedListener>>)this.config.getCacheClosedListeners());
        }
        this.configureViaSettersDirect(bc);
        bc.setClock(_timeReference);
        if (this.config.isRefreshAhead() && this.config.getAsyncLoader() == null && this.config.getLoader() == null && this.config.getAdvancedLoader() == null) {
            throw new IllegalArgumentException("refresh ahead enabled, but no loader defined");
        }
        boolean _wrap = this.config.getWeigher() != null || this.config.hasListeners() || this.config.hasAsyncListeners() || this.config.getWriter() != null || this.config.getAsyncLoader() != null;
        WiredCache wc = null;
        if (_wrap) {
            wc = _keyType == Integer.class ? new IntWiredCache() : (_keyType == Long.class ? new LongWiredCache() : new WiredCache());
            wc.heapCache = bc;
            _cache = wc;
        }
        String _name = this.manager.newCache(_cache, bc.getName());
        bc.setName(_name);
        if (_wrap) {
            wc.loader = bc.loader;
            wc.writer = (CacheWriter)bc.createCustomization(this.config.getWriter());
            wc.asyncLoader = (AsyncCacheLoader)bc.createCustomization(this.config.getAsyncLoader());
            ArrayList<CacheEntryCreatedListener> _syncCreatedListeners = new ArrayList<CacheEntryCreatedListener>();
            ArrayList<CacheEntryUpdatedListener> _syncUpdatedListeners = new ArrayList<CacheEntryUpdatedListener>();
            ArrayList<CacheEntryRemovedListener> _syncRemovedListeners = new ArrayList<CacheEntryRemovedListener>();
            ArrayList _syncExpiredListeners = new ArrayList();
            ArrayList<CacheEntryEvictedListener> _syncEvictedListeners = new ArrayList<CacheEntryEvictedListener>();
            ArrayList<CacheEntryExpiredListener> _expiredListeners = new ArrayList<CacheEntryExpiredListener>();
            if (this.config.hasListeners()) {
                for (CustomizationSupplier f : this.config.getListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)bc.createCustomization(f);
                    if (el instanceof CacheEntryCreatedListener) {
                        _syncCreatedListeners.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        _syncUpdatedListeners.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        _syncRemovedListeners.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        _expiredListeners.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    _syncEvictedListeners.add((CacheEntryEvictedListener)el);
                }
            }
            if (this.config.hasAsyncListeners() || !_expiredListeners.isEmpty()) {
                Executor _executor = DEFAULT_ASYNC_LISTENER_EXECUTOR;
                if (this.config.getAsyncListenerExecutor() != null) {
                    _executor = (Executor)_cache.createCustomization(this.config.getAsyncListenerExecutor());
                }
                AsyncDispatcher _asyncDispatcher = new AsyncDispatcher(wc, _executor);
                ArrayList<CacheEntryCreatedListener> cll = new ArrayList<CacheEntryCreatedListener>();
                ArrayList<CacheEntryUpdatedListener> ull = new ArrayList<CacheEntryUpdatedListener>();
                ArrayList<CacheEntryRemovedListener> rll = new ArrayList<CacheEntryRemovedListener>();
                ArrayList<CacheEntryExpiredListener> ell = new ArrayList<CacheEntryExpiredListener>();
                ArrayList<CacheEntryEvictedListener> evl = new ArrayList<CacheEntryEvictedListener>();
                for (CustomizationSupplier customizationSupplier : this.config.getAsyncListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)bc.createCustomization(customizationSupplier);
                    if (el instanceof CacheEntryCreatedListener) {
                        cll.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        ull.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        rll.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        ell.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    evl.add((CacheEntryEvictedListener)el);
                }
                for (CacheEntryCreatedListener cacheEntryCreatedListener : cll) {
                    _syncCreatedListeners.add(new AsyncCreatedListener(_asyncDispatcher, cacheEntryCreatedListener));
                }
                for (CacheEntryUpdatedListener cacheEntryUpdatedListener : ull) {
                    _syncUpdatedListeners.add(new AsyncUpdatedListener(_asyncDispatcher, cacheEntryUpdatedListener));
                }
                for (CacheEntryRemovedListener cacheEntryRemovedListener : rll) {
                    _syncRemovedListeners.add(new AsyncRemovedListener(_asyncDispatcher, cacheEntryRemovedListener));
                }
                for (CacheEntryExpiredListener cacheEntryExpiredListener : ell) {
                    _syncExpiredListeners.add(new AsyncExpiredListener(_asyncDispatcher, cacheEntryExpiredListener));
                }
                for (CacheEntryExpiredListener cacheEntryExpiredListener : _expiredListeners) {
                    _syncExpiredListeners.add(new AsyncExpiredListener(_asyncDispatcher, cacheEntryExpiredListener));
                }
                for (CacheEntryEvictedListener cacheEntryEvictedListener : evl) {
                    _syncEvictedListeners.add(new AsyncEvictedListener(_asyncDispatcher, cacheEntryEvictedListener));
                }
            }
            if (!_syncCreatedListeners.isEmpty()) {
                wc.syncEntryCreatedListeners = _syncCreatedListeners.toArray(new CacheEntryCreatedListener[0]);
            }
            if (!_syncUpdatedListeners.isEmpty()) {
                wc.syncEntryUpdatedListeners = _syncUpdatedListeners.toArray(new CacheEntryUpdatedListener[0]);
            }
            if (!_syncRemovedListeners.isEmpty()) {
                wc.syncEntryRemovedListeners = _syncRemovedListeners.toArray(new CacheEntryRemovedListener[0]);
            }
            if (!_syncExpiredListeners.isEmpty()) {
                wc.syncEntryExpiredListeners = _syncExpiredListeners.toArray(new CacheEntryExpiredListener[0]);
            }
            if (!_syncEvictedListeners.isEmpty()) {
                wc.syncEntryEvictedListeners = _syncEvictedListeners.toArray(new CacheEntryEvictedListener[0]);
            }
            bc.eviction = this.constructEviction(bc, wc, this.config);
            TimingHandler<K, V> rh = TimingHandler.of(_timeReference, this.config);
            bc.setTiming(rh);
            wc.init();
        } else {
            TimingHandler<K, V> rh = TimingHandler.of(_timeReference, this.config);
            bc.setTiming(rh);
            bc.eviction = this.constructEviction(bc, HeapCacheListener.NO_OPERATION, this.config);
            bc.init();
        }
        this.manager.sendCreatedEvent(_cache, this.config);
        return _cache;
    }

    private Eviction constructEviction(HeapCache hc, HeapCacheListener l, Cache2kConfiguration config) {
        boolean _strictEviction = config.isStrictEviction();
        int _availableProcessors = Runtime.getRuntime().availableProcessors();
        boolean _boostConcurrency = config.isBoostConcurrency();
        long _maximumWeight = config.getMaximumWeight();
        long _entryCapacity = config.getEntryCapacity();
        if (_entryCapacity < 0L && _maximumWeight < 0L) {
            _entryCapacity = 2000L;
        }
        int _segmentCountOverride = HeapCache.TUNABLE.segmentCountOverride;
        int _segmentCount = InternalCache2kBuilder.determineSegmentCount(_strictEviction, _availableProcessors, _boostConcurrency, _entryCapacity, _segmentCountOverride);
        Eviction[] _segments = new Eviction[_segmentCount];
        long _maxSize = InternalCache2kBuilder.determineMaxSize(_entryCapacity, _segmentCount);
        long _maxWeight = InternalCache2kBuilder.determineMaxWeight(_maximumWeight, _segmentCount);
        Weigher _weigher = (Weigher)hc.createCustomization(config.getWeigher());
        for (int i = 0; i < _segments.length; ++i) {
            ClockProPlusEviction ev = new ClockProPlusEviction(hc, l, _maxSize, _weigher, _maxWeight, _strictEviction);
            _segments[i] = ev;
        }
        if (_segmentCount == 1) {
            return _segments[0];
        }
        return new SegmentedEviction(_segments);
    }

    static long determineMaxSize(long _entryCapacity, int _segmentCount) {
        if (_entryCapacity < 0L) {
            return -1L;
        }
        long _maxSize = _entryCapacity / (long)_segmentCount;
        if (_entryCapacity == Long.MAX_VALUE) {
            _maxSize = Long.MAX_VALUE;
        } else if (_entryCapacity % (long)_segmentCount > 0L) {
            ++_maxSize;
        }
        return _maxSize;
    }

    static long determineMaxWeight(long _maximumWeight, int _segmentCount) {
        if (_maximumWeight < 0L) {
            return -1L;
        }
        long _maxWeight = _maximumWeight / (long)_segmentCount;
        if (_maximumWeight == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (_maximumWeight % (long)_segmentCount > 0L) {
            ++_maxWeight;
        }
        return _maxWeight;
    }

    static int determineSegmentCount(boolean _strictEviction, int _availableProcessors, boolean _boostConcurrency, long _entryCapacity, int _segmentCountOverride) {
        int _segmentCount = 1;
        if (_availableProcessors > 1) {
            _segmentCount = 2;
            if (_boostConcurrency) {
                _segmentCount = 2 << 31 - Integer.numberOfLeadingZeros(_availableProcessors);
            }
        }
        if (_segmentCountOverride > 0) {
            _segmentCount = 1 << 32 - Integer.numberOfLeadingZeros(_segmentCountOverride - 1);
        } else {
            int _maxSegments = _availableProcessors * 2;
            _segmentCount = Math.min(_segmentCount, _maxSegments);
        }
        if (_entryCapacity >= 0L && _entryCapacity < 1000L) {
            _segmentCount = 1;
        }
        if (_strictEviction) {
            _segmentCount = 1;
        }
        return _segmentCount;
    }

    private void checkConfiguration() {
        if (this.config.getExpireAfterWrite() == 0x7FFFFFFFFFFFFFFEL && this.config.getExpiryPolicy() == null) {
            throw new IllegalArgumentException("not eternal is set, but expire value is missing");
        }
    }

    private static class AsyncEvictedListener<K, V>
    implements CacheEntryEvictedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryEvictedListener<K, V> listener;

        public AsyncEvictedListener(AsyncDispatcher<K> _dispatcher, CacheEntryEvictedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        public void onEntryEvicted(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncEvictedListener.this.listener.onEntryEvicted(c, e);
                }
            });
        }
    }

    private static class AsyncExpiredListener<K, V>
    implements CacheEntryExpiredListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryExpiredListener<K, V> listener;

        public AsyncExpiredListener(AsyncDispatcher<K> _dispatcher, CacheEntryExpiredListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        public void onEntryExpired(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncExpiredListener.this.listener.onEntryExpired(c, e);
                }
            });
        }
    }

    private static class AsyncRemovedListener<K, V>
    implements CacheEntryRemovedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryRemovedListener<K, V> listener;

        public AsyncRemovedListener(AsyncDispatcher<K> _dispatcher, CacheEntryRemovedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        public void onEntryRemoved(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncRemovedListener.this.listener.onEntryRemoved(c, e);
                }
            });
        }
    }

    private static class AsyncUpdatedListener<K, V>
    implements CacheEntryUpdatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryUpdatedListener<K, V> listener;

        public AsyncUpdatedListener(AsyncDispatcher<K> _dispatcher, CacheEntryUpdatedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        public void onEntryUpdated(final Cache<K, V> cache, final CacheEntry<K, V> currentEntry, final CacheEntry<K, V> entryWithNewData) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return currentEntry.getKey();
                }

                @Override
                public void execute() {
                    AsyncUpdatedListener.this.listener.onEntryUpdated(cache, currentEntry, entryWithNewData);
                }
            });
        }
    }

    static class AsyncCreatedListener<K, V>
    implements CacheEntryCreatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryCreatedListener<K, V> listener;

        public AsyncCreatedListener(AsyncDispatcher<K> _dispatcher, CacheEntryCreatedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        public void onEntryCreated(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncCreatedListener.this.listener.onEntryCreated(c, e);
                }
            });
        }
    }

    private static class WrappedAdvancedCacheLoader<K, V>
    extends AdvancedCacheLoader<K, V>
    implements Closeable {
        HeapCache<K, V> heapCache;
        private final AdvancedCacheLoader<K, V> forward;

        public WrappedAdvancedCacheLoader(HeapCache<K, V> _heapCache, AdvancedCacheLoader<K, V> _forward) {
            this.heapCache = _heapCache;
            this.forward = _forward;
        }

        @Override
        public void close() throws IOException {
            if (this.forward instanceof Closeable) {
                ((Closeable)this.forward).close();
            }
        }

        public V load(K key, long currentTime, CacheEntry<K, V> currentEntry) throws Exception {
            if (currentEntry == null) {
                return (V)this.forward.load(key, currentTime, null);
            }
            return (V)this.forward.load(key, currentTime, this.heapCache.returnCacheEntry((ExaminationEntry)currentEntry));
        }
    }
}

