/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.Weigher;
import org.cache2k.core.AbstractEviction;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntegrityState;

public class RandomEviction
extends AbstractEviction {
    private int evictionIndex = 0;
    private long size = 0L;
    private Entry head = new Entry().shortCircuit();

    public RandomEviction(HeapCache _heapCache, HeapCacheListener _listener, long _maxSize, Weigher _weigher, long _maxWeight) {
        super(_heapCache, _listener, _maxSize, _weigher, _maxWeight, false);
    }

    @Override
    public void updateWeight(Entry e) {
    }

    @Override
    protected void removeFromReplacementList(Entry e) {
        Entry.removeFromList(e);
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        Entry.insertInList(this.head, e);
    }

    @Override
    protected Entry findEvictionCandidate(Entry _previous) {
        Entry e;
        Entry<K, V>[] h0 = this.heapCache.hash.getEntries();
        int idx = this.evictionIndex % h0.length;
        while ((e = h0[idx]) == null) {
            if (++idx < h0.length) continue;
            idx = 0;
        }
        this.evictionIndex += e.hashCode;
        if (this.evictionIndex < 0) {
            this.evictionIndex = -this.evictionIndex;
        }
        return e;
    }

    @Override
    public void checkIntegrity(IntegrityState _integrityState) {
    }

    @Override
    public long removeAll() {
        long _count = 0L;
        Entry _head = this.head;
        Entry e = this.head.prev;
        while (e != _head) {
            Entry _next = e.prev;
            e.removedFromList();
            ++_count;
            e = _next;
        }
        return _count;
    }

    @Override
    public String getExtraStatistics() {
        return "";
    }

    @Override
    public long getHitCount() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

