/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CustomizationReferenceSupplier;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.DefaultResiliencePolicy;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.InternalCache;
import org.cache2k.core.util.InternalClock;
import org.cache2k.core.util.SimpleTimer;
import org.cache2k.core.util.SimpleTimerTask;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.core.util.Util;
import org.cache2k.expiry.Expiry;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.expiry.ValueWithExpiryTime;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ResiliencePolicy;

public abstract class TimingHandler<K, V> {
    static final TimingHandler ETERNAL = new Eternal();
    static final TimingHandler ETERNAL_IMMEDIATE = new EternalImmediate();
    private static final TimingHandler IMMEDIATE = new Immediate();
    private static final int PURGE_INTERVAL = TunableFactory.get(Tunable.class).purgeInterval;
    private static final long SAFETY_GAP_MILLIS = HeapCache.TUNABLE.sharpExpirySafetyGapMillis;
    static final ExpiryPolicy<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new ExpiryPolicy<Object, ValueWithExpiryTime>(){

        public long calculateExpiryTime(Object _key, ValueWithExpiryTime _value, long _loadTime, CacheEntry<Object, ValueWithExpiryTime> _oldEntry) {
            return _value.getCacheExpiryTime();
        }
    };

    static boolean realDuration(long t) {
        return t > 0L && t < Long.MAX_VALUE;
    }

    static boolean zeroOrUnspecified(long t) {
        return t == 0L || t == -1L;
    }

    public static <K, V> TimingHandler<K, V> of(InternalClock _clock, Cache2kConfiguration<K, V> cfg) {
        if (cfg.getExpireAfterWrite() == 0L && TimingHandler.zeroOrUnspecified(cfg.getRetryInterval())) {
            return IMMEDIATE;
        }
        if (cfg.getExpiryPolicy() != null || cfg.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) || cfg.getResiliencePolicy() != null) {
            Dynamic<K, V> h = new Dynamic<K, V>(_clock, cfg);
            return h;
        }
        if (cfg.getResilienceDuration() > 0L && !cfg.isSuppressExceptions()) {
            throw new IllegalArgumentException("Ambiguous: exceptions suppression is switched off, but resilience duration is specified");
        }
        if (TimingHandler.realDuration(cfg.getExpireAfterWrite()) || TimingHandler.realDuration(cfg.getRetryInterval()) || TimingHandler.realDuration(cfg.getResilienceDuration())) {
            Static<K, V> h = new Static<K, V>(_clock, cfg);
            return h;
        }
        if (cfg.getExpireAfterWrite() == Long.MAX_VALUE || cfg.getExpireAfterWrite() == -1L) {
            if (TimingHandler.zeroOrUnspecified(cfg.getRetryInterval())) {
                return ETERNAL_IMMEDIATE;
            }
            if (cfg.getRetryInterval() == Long.MAX_VALUE) {
                return ETERNAL;
            }
        }
        throw new IllegalArgumentException("expiry time ambiguous");
    }

    public void init(InternalCache<K, V> c) {
    }

    public void reset() {
    }

    public void shutdown() {
    }

    public void close() {
        this.shutdown();
    }

    public abstract long calculateNextRefreshTime(Entry<K, V> var1, V var2, long var3);

    public abstract long suppressExceptionUntil(Entry<K, V> var1, ExceptionInformation var2);

    public abstract long cacheExceptionUntil(Entry<K, V> var1, ExceptionInformation var2);

    public long stopStartTimer(long _expiryTime, Entry<K, V> e) {
        if (_expiryTime > 0L && _expiryTime < Long.MAX_VALUE || _expiryTime < 0L) {
            throw new IllegalArgumentException("invalid expiry time, cache is not initialized with expiry: " + Util.formatMillis(_expiryTime));
        }
        return _expiryTime == 0L ? 4L : _expiryTime;
    }

    public boolean startRefreshProbationTimer(Entry<K, V> e, long _nextRefreshTime) {
        return true;
    }

    public void cancelExpiryTimer(Entry<K, V> e) {
    }

    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
    }

    static <K, T> long calcNextRefreshTime(K _key, T _newObject, long now, Entry _entry, ExpiryPolicy<K, T> ec, long _maxLinger, boolean _sharpExpiryEnabled) {
        long t;
        if (_maxLinger == 0L) {
            return 0L;
        }
        if (ec != null) {
            long t2 = ec.calculateExpiryTime(_key, _newObject, now, (CacheEntry)_entry);
            return TimingHandler.limitExpiryToMaxLinger(now, _maxLinger, t2, _sharpExpiryEnabled);
        }
        if (_maxLinger < Long.MAX_VALUE && (t = _maxLinger + now) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    static long limitExpiryToMaxLinger(long now, long _maxLinger, long _requestedExpiryTime, boolean _sharpExpiryEnabled) {
        if (_sharpExpiryEnabled && _requestedExpiryTime > 1L && _requestedExpiryTime < Long.MAX_VALUE) {
            _requestedExpiryTime = -_requestedExpiryTime;
        }
        return Expiry.mixTimeSpanAndPointInTime((long)now, (long)_maxLinger, (long)_requestedExpiryTime);
    }

    public static class Tunable
    extends TunableConstants {
        public int purgeInterval = 10000;
    }

    static class Dynamic<K, V>
    extends Static<K, V> {
        private ExpiryPolicy<K, V> expiryPolicy;
        private CustomizationSupplier<ExpiryPolicy<K, V>> policyFactory;

        public Dynamic(InternalClock c, Cache2kConfiguration<K, V> cc) {
            super(c, cc);
        }

        @Override
        void configure(Cache2kConfiguration<K, V> c) {
            super.configure(c);
            this.policyFactory = c.getExpiryPolicy();
            if (this.policyFactory instanceof CustomizationReferenceSupplier) {
                try {
                    this.expiryPolicy = (ExpiryPolicy)this.policyFactory.supply(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (c.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(c.getValueType().getType()) && c.getExpiryPolicy() == null) {
                this.expiryPolicy = ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
            }
        }

        @Override
        public synchronized void init(InternalCache<K, V> c) {
            super.init(c);
            if (this.expiryPolicy == null) {
                this.expiryPolicy = c.createCustomization(this.policyFactory);
            }
            this.policyFactory = null;
        }

        long calcNextRefreshTime(K _key, V _newObject, long now, Entry _entry) {
            return Dynamic.calcNextRefreshTime(_key, _newObject, now, _entry, this.expiryPolicy, this.maxLinger, this.sharpExpiry);
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> _entry, V _newValue, long _loadTime) {
            long t = _entry.isDataValid() || _entry.isExpired() || _entry.nextRefreshTime == 5L ? this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, _entry) : this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, null);
            return t;
        }

        @Override
        public synchronized void close() {
            super.shutdown();
            this.cache.closeCustomization(this.expiryPolicy, "expiryPolicy");
        }
    }

    static class RefreshExpireTimerTask<K, V>
    extends CommonTimerTask<K, V> {
        RefreshExpireTimerTask() {
        }

        @Override
        public void fire() {
            this.cache.timerEventProbationTerminated(this.entry);
        }
    }

    static class ExpireTimerTask<K, V>
    extends CommonTimerTask<K, V> {
        ExpireTimerTask() {
        }

        @Override
        public void fire() {
            this.cache.timerEventExpireEntry(this.entry);
        }
    }

    static class RefreshTimerTask<K, V>
    extends CommonTimerTask<K, V> {
        RefreshTimerTask() {
        }

        @Override
        public void fire() {
            this.cache.timerEventRefresh(this.entry);
        }
    }

    static abstract class CommonTimerTask<K, V>
    extends SimpleTimerTask {
        Entry<K, V> entry;
        InternalCache<K, V> cache;

        CommonTimerTask() {
        }

        CommonTimerTask<K, V> to(InternalCache<K, V> c, Entry<K, V> e) {
            this.cache = c;
            this.entry = e;
            return this;
        }

        public abstract void fire() throws Exception;

        @Override
        public final void run() {
            try {
                this.fire();
            }
            catch (CacheClosedException cacheClosedException) {
            }
            catch (Throwable ex) {
                this.cache.logAndCountInternalException("Timer execution exception", ex);
            }
        }
    }

    static class Static<K, V>
    extends TimingHandler<K, V> {
        final InternalClock clock;
        boolean sharpExpiry;
        boolean refreshAhead;
        SimpleTimer[] timer;
        int timerMask;
        long maxLinger;
        InternalCache cache;
        int timerCancelCount = 0;
        int purgeIndex = 0;
        ResiliencePolicy<K, V> resiliencePolicy;
        CustomizationSupplier<ResiliencePolicy<K, V>> resiliencePolicyFactory;

        public Static(InternalClock c, Cache2kConfiguration<K, V> cc) {
            this.clock = c;
            this.configure(cc);
        }

        void configure(final Cache2kConfiguration<K, V> c) {
            long _expiryMillis = c.getExpireAfterWrite();
            this.maxLinger = _expiryMillis == Long.MAX_VALUE || _expiryMillis < 0L ? Long.MAX_VALUE : _expiryMillis;
            ResiliencePolicy.Context ctx = new ResiliencePolicy.Context(){

                public long getExpireAfterWriteMillis() {
                    return c.getExpireAfterWrite();
                }

                public long getResilienceDurationMillis() {
                    return c.isSuppressExceptions() ? c.getResilienceDuration() : 0L;
                }

                public long getRetryIntervalMillis() {
                    return c.getRetryInterval();
                }

                public long getMaxRetryIntervalMillis() {
                    return c.getMaxRetryInterval();
                }
            };
            this.resiliencePolicyFactory = c.getResiliencePolicy();
            if (this.resiliencePolicyFactory == null) {
                this.resiliencePolicy = new DefaultResiliencePolicy();
            } else if (this.resiliencePolicyFactory instanceof CustomizationReferenceSupplier) {
                try {
                    this.resiliencePolicy = (ResiliencePolicy)this.resiliencePolicyFactory.supply(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.resiliencePolicy.init(ctx);
            this.refreshAhead = c.isRefreshAhead();
            this.sharpExpiry = c.isSharpExpiry();
            int _timerCount = 1;
            if (c.isBoostConcurrency()) {
                int _ncpu = Runtime.getRuntime().availableProcessors();
                _timerCount = 2 << 31 - Integer.numberOfLeadingZeros(_ncpu);
            }
            this.timer = new SimpleTimer[_timerCount];
            this.timerMask = _timerCount - 1;
        }

        @Override
        public synchronized void init(InternalCache<K, V> c) {
            this.cache = c;
            if (this.resiliencePolicy == null) {
                this.resiliencePolicy = c.createCustomization(this.resiliencePolicyFactory);
            }
            this.resiliencePolicyFactory = null;
        }

        @Override
        public synchronized void reset() {
            this.shutdown();
            for (int i = 0; i <= this.timerMask; ++i) {
                if (this.timer[i] != null) continue;
                this.timer[i] = new SimpleTimer(this.clock, this.cache.getName(), true);
            }
        }

        @Override
        public synchronized void shutdown() {
            for (int i = 0; i <= this.timerMask; ++i) {
                SimpleTimer _timer = this.timer[i];
                if (_timer == null) continue;
                _timer.cancel();
                this.timer[i] = null;
            }
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Static.calcNextRefreshTime(e.getKey(), v, _loadTime, e, null, this.maxLinger, this.sharpExpiry);
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return this.resiliencePolicy.suppressExceptionUntil(e.getKey(), inf, this.cache.returnCacheEntry(e));
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return this.resiliencePolicy.retryLoadAfter(e.getKey(), inf);
        }

        long expiredEventuallyStartBackgroundRefresh(Entry e, boolean _sharpExpiry) {
            if (this.refreshAhead) {
                e.setTask(new RefreshTimerTask().to(this.cache, e));
                this.scheduleTask(0L, e);
                return _sharpExpiry ? 5L : 16L;
            }
            return 4L;
        }

        @Override
        public long stopStartTimer(long _expiryTime, Entry e) {
            this.cancelExpiryTimer(e);
            if (_expiryTime == 0L) {
                return 4L;
            }
            if (_expiryTime == -1L) {
                long nrt = e.getNextRefreshTime();
                if (nrt == 0L) {
                    throw new IllegalArgumentException("neutral expiry not allowed for creation");
                }
                return e.getNextRefreshTime();
            }
            if (_expiryTime == Long.MAX_VALUE) {
                return _expiryTime;
            }
            if (_expiryTime == 1L) {
                return this.expiredEventuallyStartBackgroundRefresh(e, false);
            }
            long now = this.clock.millis();
            if (Math.abs(_expiryTime) <= now) {
                return this.expiredEventuallyStartBackgroundRefresh(e, _expiryTime < 0L);
            }
            if (_expiryTime < 0L) {
                long _timerTime = -_expiryTime - SAFETY_GAP_MILLIS;
                if (_timerTime >= now) {
                    e.setTask(new ExpireTimerTask().to(this.cache, e));
                    this.scheduleTask(_timerTime, e);
                    _expiryTime = -_expiryTime;
                } else {
                    this.scheduleFinalExpireWithOptionalRefresh(e, -_expiryTime);
                }
            } else {
                this.scheduleFinalExpireWithOptionalRefresh(e, _expiryTime);
            }
            return _expiryTime;
        }

        @Override
        public boolean startRefreshProbationTimer(Entry<K, V> e, long _nextRefreshTime) {
            this.cancelExpiryTimer(e);
            if (_nextRefreshTime == Long.MAX_VALUE) {
                e.setNextRefreshTime(_nextRefreshTime);
                return false;
            }
            if (_nextRefreshTime > 0L && _nextRefreshTime < 32L) {
                e.setNextRefreshTime(4L);
                return true;
            }
            long _absTime = Math.abs(_nextRefreshTime);
            e.setRefreshProbationNextRefreshTime(_absTime);
            e.setNextRefreshTime(6L);
            e.setTask(new RefreshExpireTimerTask<K, V>().to(this.cache, e));
            this.scheduleTask(_absTime, e);
            return false;
        }

        @Override
        public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
            this.cancelExpiryTimer(e);
            this.scheduleFinalExpireWithOptionalRefresh(e, e.getNextRefreshTime());
        }

        void scheduleFinalExpireWithOptionalRefresh(Entry<K, V> e, long t) {
            if (this.refreshAhead) {
                e.setTask(new RefreshTimerTask<K, V>().to(this.cache, e));
            } else {
                e.setTask(new ExpireTimerTask<K, V>().to(this.cache, e));
            }
            this.scheduleTask(t, e);
        }

        void scheduleTask(long _nextRefreshTime, Entry e) {
            SimpleTimer _timer = this.timer[e.hashCode & this.timerMask];
            if (_timer != null) {
                try {
                    _timer.schedule(e.getTask(), _nextRefreshTime);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void cancelExpiryTimer(Entry<K, V> e) {
            CommonTimerTask tsk = (CommonTimerTask)e.getTask();
            if (tsk == null || !tsk.cancel()) return;
            tsk.cache = null;
            tsk.entry = null;
            ++this.timerCancelCount;
            if (this.timerCancelCount < PURGE_INTERVAL) return;
            SimpleTimer[] simpleTimerArray = this.timer;
            synchronized (this.timer) {
                this.timer[this.purgeIndex].purge();
                this.purgeIndex = this.purgeIndex + 1 & this.timerMask;
                this.timerCancelCount = 0;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    static class Immediate<K, V>
    extends TimeAgnostic<K, V> {
        Immediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return 0L;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return 0L;
        }
    }

    static class EternalImmediate<K, V>
    extends TimeAgnostic<K, V> {
        EternalImmediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return 0L;
        }
    }

    private static class Eternal<K, V>
    extends TimeAgnostic<K, V> {
        private Eternal() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return Long.MAX_VALUE;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
            return Long.MAX_VALUE;
        }
    }

    static abstract class TimeAgnostic<K, V>
    extends TimingHandler<K, V> {
        TimeAgnostic() {
        }
    }
}

