/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.concurrency;

import org.cache2k.core.concurrency.NonOptimisticLock;
import org.cache2k.core.concurrency.OptimisticLock;
import org.cache2k.core.concurrency.OptimisticLockStamped;

public class Locks {
    private static Class<? extends OptimisticLock> optimisticLockImplementation;

    public static OptimisticLock newOptimistic() {
        if (optimisticLockImplementation == null) {
            Locks.initializeOptimisticLock();
        }
        try {
            return optimisticLockImplementation.newInstance();
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static void initializeOptimisticLock() {
        try {
            if (System.getProperty(NonOptimisticLock.class.getName()) == null) {
                new OptimisticLockStamped();
                optimisticLockImplementation = OptimisticLockStamped.class;
                return;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        optimisticLockImplementation = NonOptimisticLock.class;
    }
}

