/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class WorldHelper {
    public static final EnumFacing[] NWSE = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST};

    public static <T extends Entity> T getEntityByUUID(World world, UUID uuid, Class<T> clazz) {
        for (Entity entity : world.field_72996_f) {
            if (!Objects.equals(entity.func_110124_au(), uuid) || !clazz.isInstance(entity)) continue;
            return (T)entity;
        }
        return null;
    }

    public static boolean isHorizontal(EnumFacing dir) {
        return dir.func_82601_c() != 0;
    }

    public static Biome demandBiome(String name) {
        Biome result = WorldHelper.parseBiome(name);
        if (result == null) {
            throw new IllegalArgumentException("No such Biome named \"" + name + "\"");
        }
        return result;
    }

    public static Biome parseBiome(String name) {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || biome.getRegistryName() == null || !biome.getRegistryName().func_110623_a().equalsIgnoreCase(name)) continue;
            return biome;
        }
        return null;
    }

    public static ArrayList<EnumFacing> getDirectionsTowards(int distX, int distZ) {
        EnumFacing leftRight;
        EnumFacing enumFacing = distX == 0 ? null : (leftRight = distX < 0 ? EnumFacing.WEST : EnumFacing.EAST);
        EnumFacing upDown = distZ == 0 ? null : (distZ < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH);
        ArrayList<EnumFacing> result = new ArrayList<EnumFacing>(2);
        if (leftRight != null) {
            result.add(leftRight);
        }
        if (upDown != null) {
            result.add(upDown);
        }
        return result;
    }

    public static int firstBlockDownwardsFromY(World world, BlockPos pos, boolean countNonSolid) {
        Block block = null;
        while (!(block = world.func_180495_p(pos).func_177230_c()).equals(Blocks.field_150350_a) || !countNonSolid && !block.func_176205_b((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
        }
        return pos.func_177956_o();
    }

    public static int getWaterDepth(BlockPos pos, World worldObj) {
        int count = 0;
        while (worldObj.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || worldObj.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            pos = pos.func_177984_a();
            ++count;
        }
        return count;
    }

    public static boolean isWaterOrIce(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150355_j || block == Blocks.field_150432_aD;
    }

    public static void fixLighting(World world, StructureBoundingBox bb) {
        for (int i = bb.field_78897_a >> 4; i <= bb.field_78893_d >> 4; ++i) {
            for (int j = bb.field_78896_c >> 4; j <= bb.field_78892_f >> 4; ++j) {
                Chunk chunk = world.func_72964_e(i, j);
                chunk.func_76603_b();
                chunk.func_76613_n();
            }
        }
    }
}

