/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.drops;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.EnumPositionTriState;
import com.pixelmonmod.pixelmon.comm.packetHandlers.custom.drops.CustomDropsOpenPacket;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CustomDropScreen {
    public static void openDropScreen(EntityPlayerMP player, ITextComponent title, List<ItemStack> items, String ... buttons) {
        Builder builder = CustomDropScreen.builder().setTitle(title).setItems(items);
        for (int i = 0; i < 3; ++i) {
            EnumPositionTriState position = EnumPositionTriState.naturalOrder()[i];
            if (buttons.length <= i) continue;
            builder.setButtonText(position, buttons[i]);
        }
        builder.sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ITextComponent title) {
        return new Builder().setTitle(title);
    }

    public static class Builder {
        private ITextComponent title = null;
        private List<ItemStack> items = Lists.newArrayList();
        private String[] buttons = new String[]{"", "", ""};

        public Builder setTitle(ITextComponent title) {
            this.title = (ITextComponent)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder setItems(List<ItemStack> items) {
            Preconditions.checkNotNull(items, (Object)"items");
            this.items = items;
            return this;
        }

        public Builder addItem(ItemStack stack) {
            Preconditions.checkNotNull((Object)stack, (Object)"stack");
            Preconditions.checkArgument((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"Item stack cannot be empty");
            this.items.add(stack);
            return this;
        }

        public Builder setButtonText(EnumPositionTriState position, String text) {
            Preconditions.checkNotNull((Object)((Object)position), (Object)"position");
            Preconditions.checkNotNull((Object)text, (Object)"text");
            this.buttons[position.ordinal()] = text;
            return this;
        }

        public void sendTo(EntityPlayerMP player) {
            Pixelmon.network.sendTo((IMessage)new CustomDropsOpenPacket(this.title, this.items, this.buttons), player);
        }
    }
}

