/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.base.Optional;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.EggHatchEvent;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.storage.ChangeStorageEvent;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.EnumInitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.pokemon.SpecFlag;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BonusStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MiniorStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokerusType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumMagikarp;
import com.pixelmonmod.pixelmon.enums.forms.EnumSolgaleo;
import com.pixelmonmod.pixelmon.enums.forms.EnumSpecial;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.util.DataSync;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class Pokemon
extends PokemonBase {
    protected UUID uuid;
    protected Moveset moveset = new Moveset(new Attack[]{null, null, null, null}).withPokemon(this);
    protected boolean isShiny = RandomHelper.getRandomChance(1.0f / PixelmonConfig.getShinyRate(0));
    protected EnumNature nature = null;
    protected EnumNature mintNature = null;
    protected EnumGrowth growth = null;
    protected int friendship;
    protected Level levelContainer = new Level(new DelegateLink(this));
    protected int level = -1;
    protected int experience = 0;
    protected int dynamaxLevel = 0;
    protected Stats stats = new Stats().withPokemon(this);
    protected BonusStats bonusStats = new BonusStats(0, 0, 0, 0, 0, 0, 0);
    protected Integer eggCycles = null;
    protected Integer eggSteps = null;
    protected ItemStack heldItem = ItemStack.field_190927_a;
    protected StatusPersist status = NoStatus.noStatus;
    protected ExtraStats extraStats;
    protected AbilityBase ability = null;
    protected int abilitySlot = -1;
    protected String nickname = "";
    protected String customTexture = "";
    protected EnumPokeballs caughtBall = EnumPokeballs.PokeBall;
    protected String originalTrainerName = null;
    protected UUID originalTrainerUUID = null;
    protected Pokerus pokerus = null;
    protected boolean inRanch = false;
    protected int health = -1;
    protected boolean doesLevel = true;
    protected ArrayList<Integer> relearnableMoves = new ArrayList();
    protected volatile HashMap<String, Tuple<Long, Long>> moveSkillCooldownData = new HashMap();
    protected ArrayList<String> specFlags = new ArrayList();
    protected NBTTagCompound persistentData = new NBTTagCompound();
    public int lastBattleCrits = 0;
    protected transient int dimension = -1;
    protected transient int entityID = -1;
    protected transient PokemonStorage storage = null;
    protected transient StoragePosition position = null;
    protected final transient DataSync<Optional<UUID>> dsUUID = new DataSync<Optional>(v -> {
        this.uuid = (UUID)v.get();
    });
    protected final transient DataSync<Byte> dsGrowth = new DataSync<Byte>(v -> {
        this.growth = EnumGrowth.getGrowthFromIndex(v.byteValue());
    });
    protected final transient DataSync<Integer> dsLevel = new DataSync<Integer>(v -> {
        this.level = v;
    });
    protected final transient DataSync<Integer> dsExp = new DataSync<Integer>(v -> {
        this.experience = v;
    });
    protected final transient DataSync<Boolean> dsShiny = new DataSync<Boolean>(v -> {
        this.isShiny = v;
    });
    protected final transient DataSync<String> dsCustomTexture = new DataSync<String>(v -> {
        this.customTexture = v;
    });
    protected final transient DataSync<String> dsNickname = new DataSync<String>(v -> {
        this.nickname = v.isEmpty() ? null : v;
    });
    protected final transient DataSync<Float> dsHealth = new DataSync<Float>(v -> {
        this.health = Math.round(v.floatValue());
    });
    protected final transient DataSync<Optional<UUID>> dsOwner;

    protected Pokemon() {
        this.dsOwner = new DataSync<Optional>(v -> {});
        this.uuid = UUID.randomUUID();
    }

    protected Pokemon(UUID uuid) {
        this.dsOwner = new DataSync<Optional>(v -> {});
        this.uuid = uuid;
    }

    protected Pokemon(UUID uuid, EnumSpecies species) {
        super(species, -2, null);
        this.dsOwner = new DataSync<Optional>(v -> {});
        this.uuid = uuid;
    }

    protected Pokemon(EnumSpecies species) {
        this(UUID.randomUUID(), species);
        this.setSpecies(species, false);
    }

    @Nullable
    public EntityPixelmon getPixelmonIfExists() {
        Entity entity;
        WorldServer world;
        if (this.entityID != -1 && (world = DimensionManager.getWorld((int)this.dimension)) != null && (entity = world.func_73045_a(this.entityID)) instanceof EntityPixelmon) {
            return (EntityPixelmon)entity;
        }
        return null;
    }

    @Nullable
    public PixelmonWrapper getPixelmonWrapperIfExists() {
        EntityPixelmon pixelmon = this.getPixelmonIfExists();
        if (pixelmon != null) {
            return pixelmon.getPixelmonWrapper();
        }
        return null;
    }

    public EntityPixelmon getOrSpawnPixelmon(World world, double x, double y, double z, float rotationYaw, float rotationPitch) {
        EntityPixelmon pixelmon = this.getPixelmonIfExists();
        if (pixelmon != null && world != null && pixelmon.field_71093_bK != world.field_73011_w.getDimension()) {
            pixelmon.func_70106_y();
            pixelmon = null;
            this.entityID = -1;
        }
        if (pixelmon == null) {
            if (world == null) {
                world = DimensionManager.getWorld((int)0);
            }
            pixelmon = new EntityPixelmon(world);
            pixelmon.setPokemon(this);
            pixelmon.func_70080_a(x, y, z, rotationPitch, rotationYaw);
            world.func_72838_d((Entity)pixelmon);
            this.dimension = world.field_73011_w.getDimension();
            this.entityID = pixelmon.func_145782_y();
        }
        return pixelmon;
    }

    public EntityPixelmon getOrSpawnPixelmon(World world, double x, double y, double z) {
        return this.getOrSpawnPixelmon(world, x, y, z, world.field_73012_v.nextInt(360), 0.0f);
    }

    public EntityPixelmon getOrSpawnPixelmon(Entity parent) {
        if (parent == null) {
            return this.getOrSpawnPixelmon(null, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        return this.getOrSpawnPixelmon(parent.field_70170_p, parent.field_70165_t, parent.field_70163_u, parent.field_70161_v, parent.field_70177_z, parent.field_70125_A);
    }

    public void updateDimensionAndEntityID(int dimension, int entityID) {
        this.dimension = dimension;
        this.entityID = entityID;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public World getWorld() {
        WorldServer world;
        if (this.dimension != -1 && (world = DimensionManager.getWorld((int)this.dimension)) != null) {
            return world;
        }
        return null;
    }

    public boolean ifEntityExists(Consumer<EntityPixelmon> action) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return false;
        }
        EntityPixelmon pixelmon = this.getPixelmonIfExists();
        if (pixelmon == null) {
            return false;
        }
        action.accept(pixelmon);
        return true;
    }

    public Pokemon initialize(EnumInitializeCategory ... initializeCategories) {
        boolean initializeIntrinsic = false;
        boolean initializeSpecies = false;
        boolean forceful = false;
        if (initializeCategories == null || initializeCategories.length == 0) {
            initializeSpecies = true;
            initializeIntrinsic = true;
        } else {
            for (EnumInitializeCategory initializeCategory : initializeCategories) {
                if (initializeCategory == EnumInitializeCategory.INTRINSIC) {
                    initializeIntrinsic = true;
                    continue;
                }
                if (initializeCategory == EnumInitializeCategory.SPECIES) {
                    initializeSpecies = true;
                    continue;
                }
                if (initializeCategory != EnumInitializeCategory.INTRINSIC_FORCEFUL) continue;
                forceful = true;
                initializeIntrinsic = true;
            }
        }
        if (initializeIntrinsic) {
            if (this.nature == null || forceful) {
                this.setNature(EnumNature.getRandomNature());
            }
            if (this.growth == null || forceful) {
                this.setGrowth(EnumGrowth.getRandomGrowth());
            }
            if (EnumSpecies.legendaries.contains(this.species.name) || EnumSpecies.ultrabeasts.contains(this.species.name)) {
                this.getIVs().CopyIVs(IVStore.CreateNewIVs3Perfect());
            } else {
                this.getIVs().CopyIVs(IVStore.CreateNewIVs());
            }
            if (forceful) {
                this.getEVs().fillFromArray(new int[]{0, 0, 0, 0, 0, 0});
            }
            if (this.form == -2 || forceful) {
                super.setForm(CollectionHelper.getRandomElement(this.species.getDefaultForms()));
            }
            BaseStats bs = this.getBaseStats();
            if (this.level == -1 || forceful) {
                this.getLevelContainer().setLevel(Math.min(RandomHelper.getRandomNumberBetween(bs.spawnLevel, Math.max(bs.spawnLevel, Math.min(PixelmonConfig.maxLevel, bs.spawnLevel + bs.spawnLevelRange))), PixelmonConfig.maxLevel));
            }
            if (this.ability == null || forceful) {
                this.abilitySlot = RandomHelper.getRandomChance(1.0f / PixelmonConfig.getHiddenAbilityRate(this.dimension)) ? 2 : RandomHelper.getRandomNumberBetween(0, bs.abilities[1] == null ? 0 : 1);
            }
            if (this.moveset != null && forceful) {
                this.moveset.clear();
            }
            this.stats.setLevelStats(this.nature, bs, this.level);
            this.moveset = this.moveset != null && !forceful && this.moveset.size() > 0 ? this.moveset : bs.loadMoveset(this.level).withPokemon(this);
            this.friendship = bs.baseFriendship;
            this.health = this.getMaxHealth();
            if (this.storage == null && PixelmonConfig.pokerusEnabled && PixelmonConfig.pokerusRate > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfig.pokerusRate)) {
                this.setPokerus(new Pokerus(EnumPokerusType.getRandomType()));
            }
        }
        if (initializeSpecies) {
            float healthPercentage = 100.0f;
            if (this.health != -1 && this.stats != null) {
                healthPercentage = this.getHealthPercentage();
            }
            BaseStats bs = this.getBaseStats();
            ExtraStats newExtraStats = ExtraStats.getExtraStats(this.species);
            if (this.extraStats == null && newExtraStats != null || newExtraStats == null && this.extraStats != null || this.extraStats != null && newExtraStats != null && this.extraStats.getClass() != newExtraStats.getClass()) {
                this.extraStats = newExtraStats;
            }
            if (forceful) {
                this.gender = Gender.None;
            }
            if (this.getGender() == Gender.Male && bs.malePercent <= 0 || this.getGender() == Gender.Female && bs.malePercent == 100 || this.getGender() == Gender.None && bs.malePercent >= 0) {
                if (this.getFormEnum() instanceof Gender) {
                    this.setGender(Gender.getGender(CollectionHelper.getRandomElement(this.species.getDefaultForms()).getForm()));
                } else if (bs.malePercent < 0) {
                    this.setGender(Gender.None);
                } else if (RandomHelper.rand.nextInt(100) < bs.malePercent) {
                    this.setGender(Gender.Male);
                } else {
                    this.setGender(Gender.Female);
                }
                if (Gender.mfModels.contains(this.species)) {
                    super.setForm(this.getGender());
                }
            }
            if (this.form == -1 && Gender.mfModels.contains(this.species)) {
                super.setForm(this.getGender());
            }
            if (this.form > 0 && !this.species.getPossibleForms(true).contains(this.getFormEnum()) || this.form == -2) {
                super.setForm(CollectionHelper.getRandomElement(this.species.getDefaultForms()));
            }
            bs = this.getBaseStats();
            if (this.abilitySlot == -1) {
                this.abilitySlot = 0;
            }
            if (this.abilitySlot == 2) {
                this.ability = bs.abilities[2] == null ? AbilityBase.getAbility(bs.abilities[0]).orElse(new ComingSoon(bs.abilities[0])) : AbilityBase.getAbility(bs.abilities[2]).orElse(new ComingSoon(bs.abilities[2]));
            } else if (bs.abilities[this.abilitySlot] == null) {
                int newSlot = RandomHelper.getRandomNumberBetween(0, bs.abilities[1] == null ? 0 : 1);
                if (!this.getFormEnum().isTemporary()) {
                    this.abilitySlot = newSlot;
                }
                this.ability = AbilityBase.getAbility(bs.abilities[newSlot]).orElse(new ComingSoon(bs.abilities[newSlot]));
            } else {
                this.ability = AbilityBase.getAbility(bs.abilities[this.abilitySlot]).orElse(new ComingSoon(bs.abilities[this.abilitySlot]));
            }
            this.stats.setLevelStats(this.getNature(), this.getBaseStats(), this.level);
            this.setHealth(Math.round(healthPercentage / 100.0f * (float)this.getMaxHealth()));
            if (this.extraStats != null && this.extraStats.hasSpecialSetup()) {
                this.extraStats.specialPrep(this);
            }
        }
        this.markDirty(EnumUpdateType.CLIENT);
        this.ifEntityExists(pixelmon -> pixelmon.resetDataWatchers());
        return this;
    }

    public Pokemon makeEgg() {
        this.setLevel(1);
        BaseStats bs = this.getBaseStats();
        this.eggCycles = bs.eggCycles == null || bs.eggCycles == 0 ? 21 : bs.eggCycles;
        this.markDirty(EnumUpdateType.Egg);
        return this;
    }

    public void evolve(PokemonSpec to) {
        UUID playerUUID;
        EntityPixelmon pixelmon = this.getPixelmonIfExists();
        float oldHP = this.getMaxHealth();
        float oldHealth = pixelmon == null ? oldHP : pixelmon.func_110143_aJ();
        BaseStats previousBS = this.getBaseStats();
        to.apply(this);
        if (pixelmon != null) {
            pixelmon.func_70606_j(oldHealth / oldHP * (float)this.getMaxHealth());
        }
        this.initialize(EnumInitializeCategory.SPECIES);
        BaseStats newBS = this.getBaseStats();
        if (previousBS.abilities[1] == null && newBS.abilities[1] != null) {
            this.setAbilitySlot(RandomHelper.getRandomNumberBetween(0, 1));
        }
        if ((playerUUID = this.getOwnerPlayerUUID()) != null) {
            PlayerPartyStorage storage = Pixelmon.storageManager.getParty(playerUUID);
            if (!Pixelmon.EVENT_BUS.post((Event)new PokedexEvent(playerUUID, this, EnumPokedexRegisterStatus.caught, "evolution"))) {
                storage.pokedex.set(this, EnumPokedexRegisterStatus.caught);
                storage.pokedex.update();
                EntityPlayerMP player = this.getOwnerPlayer();
                if (player != null) {
                    storage.pokedex.update();
                }
            }
        }
        if (this.getNickname() != null && Objects.equals(this.getNickname(), this.getSpecies().getLocalizedName())) {
            this.setNickname(null);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Pokemon setUUID(UUID uuid) {
        this.dsUUID.set(this, (Optional<UUID>)Optional.of((Object)uuid));
        this.markDirty(new EnumUpdateType[0]);
        return this;
    }

    public UUID getOwnerTrainerUUID() {
        if (this.storage == null || !(this.storage instanceof TrainerPartyStorage)) {
            return null;
        }
        return this.storage.uuid;
    }

    public NPCTrainer getOwnerTrainer() {
        NPCTrainer trainer;
        if (this.storage instanceof TrainerPartyStorage && trainer.field_70170_p.func_73045_a((trainer = ((TrainerPartyStorage)this.storage).getTrainer()).func_145782_y()) != null) {
            return trainer;
        }
        return null;
    }

    public UUID getOwnerPlayerUUID() {
        PCStorage pc;
        if (this.storage == null) {
            return null;
        }
        if (this.storage instanceof PlayerPartyStorage) {
            return this.storage.uuid;
        }
        if (this.storage instanceof TrainerPartyStorage) {
            return null;
        }
        PCStorage pCStorage = this.storage instanceof PCBox ? ((PCBox)this.storage).pc : (pc = this.storage instanceof PCStorage ? (PCStorage)this.storage : null);
        if (pc != null) {
            return pc.playerUUID;
        }
        return null;
    }

    public EntityPlayerMP getOwnerPlayer() {
        UUID playerUUID = this.getOwnerPlayerUUID();
        if (playerUUID == null) {
            return null;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerUUID);
    }

    public String getDisplayName() {
        if (this.isEgg()) {
            return I18n.func_74838_a((String)"pixelmon.egg.name");
        }
        return this.nickname == null || this.nickname.isEmpty() || !PixelmonConfig.allowNicknames ? this.getLocalizedName() : this.nickname + TextFormatting.RESET;
    }

    @Nullable
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname != null && nickname.isEmpty() ? null : nickname;
        this.dsNickname.set(this, nickname == null ? "" : nickname);
        this.markDirty(EnumUpdateType.Nickname);
    }

    @Override
    public void setSpecies(EnumSpecies species, boolean doSpeciesInitialization) {
        super.setSpecies(species, doSpeciesInitialization);
        if (doSpeciesInitialization) {
            this.initialize(EnumInitializeCategory.SPECIES);
        }
    }

    @Override
    public void setForm(int form) {
        super.setForm(form);
        this.initialize(EnumInitializeCategory.SPECIES);
    }

    @Override
    public void setForm(IEnumForm form) {
        super.setForm(form);
        this.initialize(EnumInitializeCategory.SPECIES);
    }

    @Override
    public void setGender(Gender gender) {
        super.setGender(gender);
        this.markDirty(EnumUpdateType.Form);
    }

    public boolean isEgg() {
        return this.eggCycles != null;
    }

    public int getEggCycles() {
        return this.eggCycles == null ? 0 : this.eggCycles;
    }

    public void setEggCycles(Integer eggCycles) {
        boolean wasEgg = this.isEgg();
        this.eggCycles = eggCycles;
        if (this.getEggCycles() < 0) {
            this.eggCycles = null;
        }
        if (wasEgg && !this.isEgg()) {
            this.hatchEgg();
        } else {
            if (!wasEgg && this.isEgg()) {
                this.setLevel(1);
            }
            this.markDirty(EnumUpdateType.Egg);
        }
    }

    public int getEggSteps() {
        return this.eggSteps == null ? 0 : this.eggSteps;
    }

    public void setEggSteps(Integer eggSteps) {
        this.eggSteps = eggSteps;
        this.markDirty(new EnumUpdateType[0]);
    }

    public void addEggSteps(int steps, int cycleMultiplier) {
        this.setEggSteps(this.getEggSteps() + steps);
        if (this.getEggSteps() > PixelmonConfig.stepsPerEggCycle) {
            this.setEggSteps(0);
            this.setEggCycles(this.getEggCycles() - Math.max(1, cycleMultiplier));
        } else {
            this.markDirty(new EnumUpdateType[0]);
        }
    }

    public void hatchEgg() {
        EntityPlayerMP player = this.getOwnerPlayer();
        if (player != null) {
            this.setOriginalTrainer((EntityPlayer)player);
        } else {
            this.setOriginalTrainer(this.getOwnerPlayerUUID(), null);
        }
        this.eggCycles = null;
        if (this.storage instanceof PlayerPartyStorage) {
            PlayerPartyStorage party = (PlayerPartyStorage)this.storage;
            if (party.pokedex.get(this.species.getNationalPokedexInteger()) != EnumPokedexRegisterStatus.caught && !Pixelmon.EVENT_BUS.post((Event)new PokedexEvent(party.getOwnerUUID(), this, EnumPokedexRegisterStatus.caught, "egg"))) {
                party.pokedex.set(this, EnumPokedexRegisterStatus.caught);
                party.pokedex.update();
            }
        }
        if (player != null) {
            ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, "pixelmon.egg.hatching", new TextComponentTranslation("pixelmon." + this.species.name.toLowerCase() + ".name", new Object[0]));
        }
        this.markDirty(EnumUpdateType.Egg, EnumUpdateType.OriginalTrainer);
        Pixelmon.EVENT_BUS.post((Event)new EggHatchEvent(this));
    }

    public String getEggDescription() {
        int cycles = this.getEggCycles();
        if (cycles < 5) {
            return "pixelmon.egg.stage1";
        }
        if (cycles < 10) {
            return "pixelmon.egg.stage2";
        }
        if (cycles < 40) {
            return "pixelmon.egg.stage3";
        }
        return "pixelmon.egg.stage4";
    }

    @Nonnull
    public ItemStack getHeldItem() {
        return this.heldItem == null ? ItemStack.field_190927_a : this.heldItem;
    }

    @Nonnull
    public ItemHeld getHeldItemAsItemHeld() {
        return ItemHeld.getItemHeld(this.heldItem);
    }

    public void setHeldItem(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || stack.func_77973_b() == NoItem.noItem) {
            stack = ItemStack.field_190927_a;
        }
        if (Pixelmon.isServer() && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            HeldItemChangedEvent event = new HeldItemChangedEvent(this.getOwnerPlayer(), this, stack);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return;
            }
            stack = event.newHeldItem;
        }
        this.heldItem = stack;
        this.markDirty(EnumUpdateType.HeldItem);
    }

    public EnumGrowth getGrowth() {
        return this.growth;
    }

    public void setGrowth(EnumGrowth growth) {
        this.dsGrowth.set(this, (byte)growth.index);
        this.markDirty(EnumUpdateType.Form);
    }

    public EnumNature getNature() {
        return this.mintNature != null ? this.mintNature : this.nature;
    }

    @Deprecated
    public EnumNature getNature(boolean mintOverride) {
        return this.mintNature != null ? this.mintNature : this.nature;
    }

    public EnumNature getBaseNature() {
        return this.nature;
    }

    public EnumNature getMintNature() {
        return this.mintNature;
    }

    public void setNature(EnumNature nature) {
        this.nature = nature;
        this.stats.setLevelStats(this.mintNature != null ? this.mintNature : nature, this.getBaseStats(), this.getLevel());
        this.markDirty(EnumUpdateType.Stats);
    }

    public void setMintNature(EnumNature nature) {
        this.mintNature = nature;
        this.setNature(this.nature);
    }

    public Pokerus getPokerus() {
        return this.pokerus;
    }

    public void setPokerus(Pokerus pokerus) {
        this.pokerus = pokerus;
        this.markDirty(EnumUpdateType.Pokerus);
    }

    public AbilityBase getAbility() {
        return this.ability;
    }

    public String getAbilityName() {
        return this.ability instanceof ComingSoon ? ((ComingSoon)this.ability).getTrueAbility() : this.ability.getName();
    }

    public void setAbility(AbilityBase ability) {
        BaseStats bs = this.getBaseStats();
        for (int i = 0; i < bs.abilities.length; ++i) {
            if (bs.abilities[i] == null || !bs.abilities[i].equals(ability.getName())) continue;
            this.ability = ability;
            this.abilitySlot = i;
            this.markDirty(EnumUpdateType.Ability);
            return;
        }
    }

    public void setAbility(String abilityName) {
        for (int i = 0; i < this.getBaseStats().abilities.length; ++i) {
            if (!abilityName.equalsIgnoreCase(this.getBaseStats().abilities[i])) continue;
            this.setAbilitySlot(i);
            return;
        }
        try {
            this.setAbility(AbilityBase.getAbility(abilityName).orElse(new ComingSoon(abilityName)));
        }
        catch (Exception e) {
            Pixelmon.LOGGER.info("Pokemon.setAbility(String) is erroring and it is weird.");
            e.printStackTrace();
        }
    }

    public int getAbilitySlot() {
        return this.abilitySlot;
    }

    public void setAbilitySlot(int abilitySlot) {
        if (abilitySlot < 0 || abilitySlot > 2) {
            return;
        }
        BaseStats bs = this.getBaseStats();
        for (int i = abilitySlot; i >= 0; --i) {
            if (bs.abilities[i] == null) continue;
            this.ability = AbilityBase.getAbility(bs.abilities[i]).orElse(new ComingSoon(bs.abilities[i]));
            this.abilitySlot = i;
            this.markDirty(EnumUpdateType.Ability);
            return;
        }
    }

    public IVStore getIVs() {
        return this.stats.ivs;
    }

    public EVStore getEVs() {
        return this.stats.evs;
    }

    public BonusStats getBonusStats() {
        return this.bonusStats;
    }

    public void setBonusStats(BonusStats bonusStats) {
        this.bonusStats = bonusStats;
    }

    public int getHighestOffensiveStat() {
        return this.getStat(StatsType.Attack) > this.getStat(StatsType.SpecialAttack) ? this.getStat(StatsType.Attack) : this.getStat(StatsType.SpecialAttack);
    }

    public int getStat(StatsType stat) {
        return this.stats.get(stat);
    }

    public Stats getStats() {
        return this.stats;
    }

    public ExtraStats getExtraStats() {
        if (this.extraStats == null && this.species != null && ExtraStats.getExtraStats(this.species) != null) {
            this.extraStats = ExtraStats.getExtraStats(this.species);
        }
        return this.extraStats;
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.getLevelContainer().updateExpToNextLevel();
        this.markDirty(EnumUpdateType.Experience);
    }

    public int getExperience() {
        return this.experience;
    }

    public int getExperienceToLevelUp() {
        if (this.getLevel() == PixelmonServerConfig.maxLevel) {
            return 1;
        }
        this.getLevelContainer().updateExpToNextLevel();
        return this.getLevelContainer().expToNextLevel;
    }

    public float getExperienceFraction() {
        return (float)this.getExperience() / (float)this.getExperienceToLevelUp();
    }

    @Nonnull
    public StatusPersist getStatus() {
        return this.status == null ? (this.status = NoStatus.noStatus) : this.status;
    }

    public void setStatus(StatusPersist status) {
        if (status == null) {
            this.status = NoStatus.noStatus;
        }
        this.status = status;
        this.markDirty(EnumUpdateType.Status);
    }

    public int getLevel() {
        return this.level;
    }

    public Level getLevelContainer() {
        return this.levelContainer;
    }

    public void setLevelNum(int level) {
        this.dsLevel.set(this, level);
        this.markDirty(EnumUpdateType.Stats);
    }

    public void setLevel(int level) {
        if (level > PixelmonServerConfig.maxLevel) {
            level = PixelmonServerConfig.maxLevel;
        }
        if (level < 1) {
            level = 1;
        }
        this.getLevelContainer().setLevel(level);
        this.setExperience(0);
    }

    public int getDynamaxLevel() {
        return this.dynamaxLevel;
    }

    public void setDynamaxLevel(int dynamaxLevel) {
        this.dynamaxLevel = dynamaxLevel;
        this.markDirty(EnumUpdateType.Stats);
    }

    public void changeDynamaxLevel(int dynamaxLevel) {
        this.dynamaxLevel += dynamaxLevel;
        this.markDirty(EnumUpdateType.Stats);
    }

    public boolean canBattle() {
        return !this.isEgg() && this.getHealth() > 0;
    }

    public boolean isLegendary() {
        return EnumSpecies.legendaries.contains(this.getSpecies().getPokemonName());
    }

    public boolean isShiny() {
        return this.isShiny;
    }

    public void setShiny(boolean isShiny) {
        this.dsShiny.set(this, isShiny);
        this.markDirty(new EnumUpdateType[0]);
    }

    public Moveset getMoveset() {
        return this.moveset;
    }

    public String getCustomTexture() {
        return this.customTexture;
    }

    public void setCustomTexture(String specialTexture) {
        this.dsCustomTexture.set(this, specialTexture);
        this.markDirty(EnumUpdateType.Texture);
    }

    public int getFriendship() {
        return this.friendship;
    }

    public void setFriendship(int friendship) {
        this.friendship = friendship > 255 ? 255 : (friendship < 0 ? 0 : friendship);
        this.markDirty(EnumUpdateType.Friendship);
    }

    public void increaseFriendship(int amount) {
        if (this.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.sootheBell) {
            amount = (int)((double)amount * 1.5);
        }
        this.setFriendship(this.getFriendship() + Math.abs(amount));
    }

    public void decreaseFriendship(int amount) {
        this.setFriendship(this.getFriendship() - Math.abs(amount));
    }

    public boolean isFriendshipHighEnoughToEvolve() {
        return this.getFriendship() >= 220;
    }

    @Nullable
    public String getOriginalTrainer() {
        return this.originalTrainerName;
    }

    @Nullable
    public UUID getOriginalTrainerUUID() {
        return this.originalTrainerUUID;
    }

    public void setOriginalTrainer(UUID originalTrainerUUID, String originalTrainerName) {
        this.originalTrainerUUID = originalTrainerUUID;
        this.originalTrainerName = originalTrainerName;
        this.markDirty(EnumUpdateType.OriginalTrainer);
    }

    public void setOriginalTrainer(EntityPlayer player) {
        if (player != null) {
            this.setOriginalTrainer(player.func_110124_au(), player.func_70005_c_());
        }
    }

    public boolean isOriginalTrainer(EntityPlayer player) {
        if (this.originalTrainerUUID == null && this.originalTrainerName != null && (this.originalTrainerName.equals(player.func_70005_c_()) || TextFormatting.func_110646_a((String)this.originalTrainerName).equals(player.func_70005_c_()))) {
            this.setOriginalTrainer(player);
        }
        return player.func_110124_au().equals(this.originalTrainerUUID);
    }

    public EnumPokeballs getCaughtBall() {
        return this.caughtBall;
    }

    public void setCaughtBall(EnumPokeballs caughtBall) {
        this.caughtBall = caughtBall;
        this.markDirty(EnumUpdateType.Ball);
    }

    public int getHealth() {
        return this.health;
    }

    public float getHealthPercentage() {
        return 1.0f * (float)this.health / (float)this.getMaxHealth() * 100.0f;
    }

    public void heal() {
        this.setHealthPercentage(100.0f);
        this.getMoveset().healAllPP();
        this.setStatus(NoStatus.noStatus);
    }

    public void setHealth(int health) {
        this.dsHealth.set(this, Float.valueOf(MathHelper.func_76125_a((int)health, (int)0, (int)this.getMaxHealth())));
        this.markDirty(EnumUpdateType.HP);
    }

    public void setHealthPercentage(float healthPercentage) {
        this.setHealth(Math.round((float)this.getMaxHealth() * healthPercentage / 100.0f));
    }

    public int getMaxHealth() {
        PixelmonWrapper pw = this.getPixelmonWrapperIfExists();
        if (pw != null) {
            return pw.getMaxHealth();
        }
        return this.getStat(StatsType.HP);
    }

    public boolean doesLevel() {
        return this.doesLevel;
    }

    public void setDoesLevel(boolean doesLevel) {
        this.doesLevel = doesLevel;
        this.markDirty(EnumUpdateType.CanLevel);
    }

    public boolean isInRanch() {
        return this.inRanch;
    }

    public void setInRanch(boolean inRanch) {
        this.inRanch = inRanch;
        this.markDirty(EnumUpdateType.InRanch);
    }

    public ArrayList<Integer> getRelearnableMoves() {
        return this.relearnableMoves;
    }

    public <T extends Evolution> ArrayList<T> getEvolutions(Class<T> type) {
        ArrayList<T> evolutions = new ArrayList<T>();
        for (Evolution evo : this.getBaseStats().evolutions) {
            if (evo == null || !type.isInstance(evo)) continue;
            evolutions.add(type.cast(evo));
        }
        return evolutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForExistingEvolutionQuery() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                if (!EvolutionQueryList.queryList.get((int)i).pokemonUUID.equals(this.getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    public void tryEvolution() {
        boolean hasEvolved = this.checkForExistingEvolutionQuery();
        if (this.getHealth() > 0 && !hasEvolved) {
            boolean spawned = false;
            EntityPixelmon pixelmon = this.getPixelmonIfExists();
            if (pixelmon == null) {
                pixelmon = this.getOrSpawnPixelmon((Entity)this.getOwnerPlayer());
                spawned = true;
            } else if (pixelmon.func_110143_aJ() < 1.0f) {
                return;
            }
            if (pixelmon != null && !pixelmon.testLevelEvolution(this.getLevel()) && spawned) {
                pixelmon.retrieve();
            }
        }
    }

    public NBTTagCompound getPersistentData() {
        return this.persistentData;
    }

    public void retrieve() {
        this.ifEntityExists(EntityPixelmon::retrieve);
    }

    public void setStorage(PokemonStorage storage, StoragePosition position) {
        if (this.storage != null && this.position != null) {
            Pixelmon.EVENT_BUS.post((Event)new ChangeStorageEvent(this.storage, this.position, storage, position, this));
        }
        this.storage = storage;
        this.position = position;
        this.dsOwner.set(this, (Optional<UUID>)Optional.fromNullable((Object)this.getOwnerPlayerUUID()));
    }

    @Nullable
    public PokemonStorage getStorage() {
        return this.position == null ? null : this.storage;
    }

    @Nullable
    public StoragePosition getPosition() {
        return this.storage == null ? null : this.position;
    }

    @Nullable
    public Tuple<PokemonStorage, StoragePosition> getStorageAndPosition() {
        if (this.storage == null || this.position == null) {
            return null;
        }
        return new Tuple((Object)this.storage, (Object)this.position);
    }

    public boolean isMoveSkillCoolingDown(MoveSkill moveSkill) {
        return this.getMoveSkillCooldownTicks(moveSkill) > 0;
    }

    public int getMoveSkillCooldownTicks(MoveSkill moveSkill) {
        Tuple<Long, Long> tup = this.moveSkillCooldownData.get(moveSkill.id);
        if (tup == null) {
            return -1;
        }
        long remaining = (Long)tup.func_76340_b() - System.currentTimeMillis();
        if (remaining <= 0L) {
            this.moveSkillCooldownData.remove(moveSkill.id);
            this.markDirty(EnumUpdateType.MoveSkills);
            return -1;
        }
        return (int)Math.ceil((float)remaining / 50.0f);
    }

    public double getMoveSkillCooldownRatio(MoveSkill moveSkill) {
        Tuple<Long, Long> tup = this.moveSkillCooldownData.get(moveSkill.id);
        long cur = System.currentTimeMillis();
        if (tup == null || cur > (Long)tup.func_76340_b()) {
            return 1.0;
        }
        return (double)(System.currentTimeMillis() - (Long)tup.func_76341_a()) * 1.0 / (double)((Long)tup.func_76340_b() - (Long)tup.func_76341_a());
    }

    public void setMoveSkillCooldown(MoveSkill moveSkill, int cooldownTicks) {
        long cur = System.currentTimeMillis();
        long des = cur + (long)(cooldownTicks * 50);
        this.moveSkillCooldownData.put(moveSkill.id, (Tuple<Long, Long>)new Tuple((Object)cur, (Object)des));
        this.markDirty(EnumUpdateType.MoveSkills);
    }

    public void addSpecFlag(String key) {
        if (!this.specFlags.contains(key)) {
            this.specFlags.add(key);
            this.markDirty(EnumUpdateType.SpecFlags);
        }
    }

    public void removeSpecFlag(String key) {
        if (this.specFlags.remove(key)) {
            this.markDirty(EnumUpdateType.SpecFlags);
        }
    }

    public boolean hasSpecFlag(String key) {
        return this.specFlags.contains(key);
    }

    public void markDirty(EnumUpdateType ... dataTypes) {
        if (this.storage == null || this.position == null || this.storage.get(this.position) != this) {
            return;
        }
        this.storage.setNeedsSaving();
        this.storage.notifyListeners(this.position, this, dataTypes);
    }

    public void writeToByteBuffer(ByteBuf buf, EnumUpdateType ... data) {
        if (data == null || data.length == 0) {
            data = EnumUpdateType.ALL;
        }
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        block30: for (EnumUpdateType type : data) {
            switch (type) {
                case Name: {
                    buf.writeShort(this.species.getNationalPokedexInteger());
                    continue block30;
                }
                case Nickname: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.nickname == null ? "" : this.nickname));
                    continue block30;
                }
                case Form: {
                    buf.writeByte(this.getForm());
                    buf.writeByte(this.getGender().ordinal());
                    buf.writeByte(this.getGrowth().ordinal());
                    buf.writeBoolean(this.isShiny());
                }
                case Experience: {
                    buf.writeInt(this.experience);
                }
                case Stats: {
                    buf.writeByte(this.nature.index);
                    buf.writeBoolean(this.mintNature != null);
                    if (this.mintNature != null) {
                        buf.writeByte(this.mintNature.index);
                    }
                    buf.writeShort(this.level);
                    buf.writeShort(this.dynamaxLevel);
                    buf.writeShort(this.getStat(StatsType.HP));
                    buf.writeShort(this.getStat(StatsType.Attack));
                    buf.writeShort(this.getStat(StatsType.Defence));
                    buf.writeShort(this.getStat(StatsType.SpecialAttack));
                    buf.writeShort(this.getStat(StatsType.SpecialDefence));
                    buf.writeShort(this.getStat(StatsType.Speed));
                    this.bonusStats.writeToByteBuffer(buf);
                    continue block30;
                }
                case IVs: {
                    this.getIVs().writeToByteBuffer(buf);
                    continue block30;
                }
                case EVs: {
                    this.getEVs().writeToByteBuffer(buf);
                    continue block30;
                }
                case HP: {
                    buf.writeInt(this.health);
                    continue block30;
                }
                case Ball: {
                    buf.writeByte(this.caughtBall.ordinal());
                    continue block30;
                }
                case Moveset: {
                    Moveset moveset = this.getMoveset();
                    moveset.toBytes(buf);
                    continue block30;
                }
                case Status: {
                    if (this.status == NoStatus.noStatus) {
                        buf.writeShort(-1);
                        continue block30;
                    }
                    buf.writeShort(this.status.type.ordinal());
                    continue block30;
                }
                case CanLevel: {
                    buf.writeBoolean(this.doesLevel);
                    continue block30;
                }
                case Egg: {
                    buf.writeBoolean(this.isEgg());
                    if (!this.isEgg()) continue block30;
                    buf.writeInt(this.eggCycles.intValue());
                    continue block30;
                }
                case HeldItem: {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.heldItem == null ? ItemStack.field_190927_a : this.heldItem));
                    continue block30;
                }
                case Friendship: {
                    buf.writeShort(this.friendship);
                    continue block30;
                }
                case Ability: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getAbilityName());
                    continue block30;
                }
                case Texture: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.customTexture);
                    continue block30;
                }
                case Pokerus: {
                    if (this.pokerus == null) {
                        buf.writeBoolean(false);
                        continue block30;
                    }
                    buf.writeBoolean(true);
                    Pokerus.SERIALIZER.func_187160_a(new PacketBuffer(buf), (Object)this.pokerus);
                    continue block30;
                }
                case InRanch: {
                    buf.writeBoolean(this.inRanch);
                    continue block30;
                }
                case OriginalTrainer: {
                    buf.writeBoolean(this.originalTrainerName != null);
                    if (this.originalTrainerName == null) continue block30;
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.originalTrainerName);
                    continue block30;
                }
                case Clones: {
                    boolean hasClones = this.getExtraStats() instanceof MewStats;
                    buf.writeBoolean(hasClones);
                    if (!hasClones) continue block30;
                    buf.writeInt(((MewStats)this.extraStats).numCloned);
                    continue block30;
                }
                case Wool_Growth: {
                    boolean hasGrowth = this.getExtraStats() instanceof ShearableStats;
                    buf.writeBoolean(hasGrowth);
                    if (!hasGrowth) continue block30;
                    buf.writeByte((int)((ShearableStats)this.extraStats).growthStage);
                    continue block30;
                }
                case Minior_Core: {
                    boolean hasCore = this.getExtraStats() instanceof MiniorStats;
                    buf.writeBoolean(hasCore);
                    if (!hasCore) continue block30;
                    buf.writeByte((int)((MiniorStats)this.extraStats).color);
                    continue block30;
                }
                case Enchants: {
                    boolean hasEnchants = this.getExtraStats() instanceof LakeTrioStats;
                    buf.writeBoolean(hasEnchants);
                    if (!hasEnchants) continue block30;
                    buf.writeInt(((LakeTrioStats)this.extraStats).numEnchanted);
                    continue block30;
                }
                case Smelts: {
                    boolean hasSmelts = this.getExtraStats() instanceof MeltanStats;
                    buf.writeBoolean(hasSmelts);
                    if (!hasSmelts) continue block30;
                    buf.writeInt(((MeltanStats)this.extraStats).oresSmelted);
                    continue block30;
                }
                case Appearance: {
                    boolean isEgg = this.isEgg();
                    buf.writeShort(this.species.getNationalPokedexInteger());
                    buf.writeBoolean(isEgg);
                    buf.writeByte(isEgg ? 0 : this.getForm());
                    buf.writeByte(isEgg ? Gender.None.ordinal() : this.getGender().ordinal());
                    buf.writeBoolean(!isEgg && this.isShiny());
                    buf.writeByte(this.caughtBall.ordinal());
                    continue block30;
                }
                case MoveSkills: {
                    buf.writeByte(this.moveSkillCooldownData.size());
                    for (Map.Entry<String, Tuple<Long, Long>> entry : this.moveSkillCooldownData.entrySet()) {
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey().toString());
                        long difference = (Long)entry.getValue().func_76340_b() - System.currentTimeMillis();
                        buf.writeLong(difference);
                    }
                    continue block30;
                }
                case SpecFlags: {
                    ArrayList<String> specFlags = new ArrayList<String>();
                    for (String specFlag : this.specFlags) {
                        ISpecType specType = PokemonSpec.getSpecForKey(specFlag);
                        if (specType == null || !(specType instanceof SpecFlag) || !((SpecFlag)specType).sentToClient()) continue;
                        specFlags.add(((SpecFlag)specType).key);
                    }
                    buf.writeShort(specFlags.size());
                    for (String specFlag : specFlags) {
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)specFlag);
                    }
                    continue block30;
                }
            }
        }
    }

    public Pokemon readFromByteBuffer(ByteBuf buf, EnumUpdateType ... data) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        block32: for (EnumUpdateType type : data) {
            switch (type) {
                case Name: {
                    this.species = EnumSpecies.getFromDex(buf.readShort());
                    continue block32;
                }
                case Nickname: {
                    this.nickname = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    if (!this.nickname.equals("")) continue block32;
                    this.nickname = null;
                    continue block32;
                }
                case Form: {
                    this.form = buf.readByte();
                    this.gender = Gender.getGender(buf.readByte());
                    this.growth = EnumGrowth.getGrowthFromIndex(buf.readByte());
                    this.isShiny = buf.readBoolean();
                }
                case Experience: {
                    this.experience = buf.readInt();
                }
                case Stats: {
                    this.nature = EnumNature.getNatureFromIndex(buf.readByte());
                    this.mintNature = buf.readBoolean() ? EnumNature.getNatureFromIndex(buf.readByte()) : null;
                    this.level = buf.readShort();
                    this.dynamaxLevel = buf.readShort();
                    this.stats.hp = buf.readShort();
                    this.stats.attack = buf.readShort();
                    this.stats.defence = buf.readShort();
                    this.stats.specialAttack = buf.readShort();
                    this.stats.specialDefence = buf.readShort();
                    this.stats.speed = buf.readShort();
                    this.bonusStats = new BonusStats(buf);
                    continue block32;
                }
                case IVs: {
                    this.getIVs().readFromByteBuffer(buf);
                    continue block32;
                }
                case EVs: {
                    this.getEVs().readFromByteBuffer(buf);
                    continue block32;
                }
                case HP: {
                    this.health = buf.readInt();
                    continue block32;
                }
                case Ball: {
                    this.caughtBall = EnumPokeballs.getFromIndex(buf.readByte());
                    continue block32;
                }
                case Moveset: {
                    this.moveset = new Moveset().withPokemon(this);
                    this.moveset.fromBytes(buf);
                    continue block32;
                }
                case Status: {
                    short statusTypeOrdinal = buf.readShort();
                    if (statusTypeOrdinal == -1) {
                        this.status = NoStatus.noStatus;
                        continue block32;
                    }
                    this.status = StatusType.getEffectInstance(statusTypeOrdinal);
                    continue block32;
                }
                case CanLevel: {
                    this.doesLevel = buf.readBoolean();
                    continue block32;
                }
                case Egg: {
                    boolean isEgg = buf.readBoolean();
                    if (isEgg) {
                        this.eggCycles = buf.readInt();
                        continue block32;
                    }
                    this.eggCycles = null;
                    continue block32;
                }
                case HeldItem: {
                    this.heldItem = ByteBufUtils.readItemStack((ByteBuf)buf);
                    continue block32;
                }
                case Friendship: {
                    this.friendship = buf.readShort();
                    continue block32;
                }
                case Ability: {
                    String abilityName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    this.ability = AbilityBase.getAbility(abilityName).orElse(new ComingSoon(abilityName));
                    BaseStats bs = this.getBaseStats();
                    for (int i = 0; i < bs.abilities.length; ++i) {
                        if (bs.abilities[i] == null || !abilityName.equalsIgnoreCase(bs.abilities[i])) continue;
                        this.abilitySlot = i;
                    }
                    continue block32;
                }
                case Texture: {
                    this.customTexture = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    continue block32;
                }
                case Pokerus: {
                    boolean hasPokerus = buf.readBoolean();
                    if (!hasPokerus) {
                        this.pokerus = null;
                        continue block32;
                    }
                    try {
                        this.pokerus = (Pokerus)Pokerus.SERIALIZER.func_187159_a(new PacketBuffer(buf));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block32;
                }
                case InRanch: {
                    this.inRanch = buf.readBoolean();
                    continue block32;
                }
                case OriginalTrainer: {
                    if (buf.readBoolean()) {
                        this.originalTrainerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        continue block32;
                    }
                    this.originalTrainerName = null;
                    continue block32;
                }
                case Clones: {
                    if (!buf.readBoolean()) continue block32;
                    this.extraStats = new MewStats(buf.readInt());
                    continue block32;
                }
                case Wool_Growth: {
                    if (!buf.readBoolean()) continue block32;
                    this.extraStats = new ShearableStats(buf.readByte());
                    continue block32;
                }
                case Enchants: {
                    if (!buf.readBoolean()) continue block32;
                    this.extraStats = new LakeTrioStats(buf.readInt());
                    continue block32;
                }
                case Smelts: {
                    if (!buf.readBoolean()) continue block32;
                    this.extraStats = new MeltanStats(buf.readInt());
                    continue block32;
                }
                case Minior_Core: {
                    if (!buf.readBoolean()) continue block32;
                    this.extraStats = new MiniorStats(buf.readByte());
                    continue block32;
                }
                case Appearance: {
                    this.species = EnumSpecies.getFromDex(buf.readShort());
                    this.eggCycles = buf.readBoolean() ? Integer.valueOf(40) : null;
                    this.form = buf.readByte();
                    this.gender = Gender.getGender(buf.readByte());
                    this.isShiny = buf.readBoolean();
                    this.caughtBall = EnumPokeballs.getFromIndex(buf.readByte());
                    continue block32;
                }
                case MoveSkills: {
                    int cooldowns = buf.readByte();
                    HashMap<String, Tuple> newCooldownData = new HashMap<String, Tuple>();
                    for (int i = 0; i < cooldowns; ++i) {
                        newCooldownData.put(ByteBufUtils.readUTF8String((ByteBuf)buf), new Tuple((Object)System.currentTimeMillis(), (Object)(System.currentTimeMillis() + buf.readLong())));
                    }
                    this.moveSkillCooldownData = newCooldownData;
                    continue block32;
                }
                case SpecFlags: {
                    this.specFlags.clear();
                    int n = buf.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        this.specFlags.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
                    }
                    continue block32;
                }
            }
        }
        return this;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        block49: {
            super.readFromNBT(nbt);
            byte NBT_VERSION = nbt.func_74771_c("NBT_VERSION");
            this.setUUID(nbt.func_186857_a("UUID"));
            this.setShiny(nbt.func_74767_n("IsShiny"));
            byte special = nbt.func_74771_c("specialTexture");
            switch (special) {
                case 1: {
                    this.dsForm.set(this, EnumMagikarp.ROASTED.getForm());
                    break;
                }
                case 2: {
                    this.dsForm.set(this, EnumSpecial.Zombie.getForm());
                    break;
                }
                case 3: {
                    this.dsForm.set(this, EnumSpecial.Online.getForm());
                    break;
                }
                case 4: {
                    this.dsForm.set(this, EnumSpecial.Drowned.getForm());
                    break;
                }
                case 5: {
                    this.dsForm.set(this, EnumSpecial.Valentine.getForm());
                    break;
                }
                case 6: {
                    this.dsForm.set(this, EnumSpecial.Rainbow.getForm());
                    break;
                }
                case 7: {
                    this.dsForm.set(this, EnumSpecial.Alien.getForm());
                    break;
                }
                case 8: {
                    this.dsForm.set(this, EnumSolgaleo.Real.getForm());
                    break;
                }
                case 9: {
                    this.dsForm.set(this, EnumSpecial.Alter.getForm());
                    break;
                }
                case 10: {
                    this.dsForm.set(this, EnumSpecial.Pink.getForm());
                    break;
                }
                case 11: {
                    this.dsForm.set(this, EnumSpecial.Summer.getForm());
                    break;
                }
                case 12: {
                    this.dsForm.set(this, EnumSpecial.Crystal.getForm());
                }
            }
            this.setCustomTexture(nbt.func_74779_i("CustomTexture"));
            this.setNickname(nbt.func_74779_i("Nickname"));
            this.setCaughtBall(nbt.func_74764_b("CaughtBall") ? EnumPokeballs.getFromIndex(nbt.func_74771_c("CaughtBall")) : EnumPokeballs.PokeBall);
            this.setNature(EnumNature.getNatureFromIndex(nbt.func_74771_c("Nature")));
            int mintNature = nbt.func_74764_b("MintNature") ? (int)nbt.func_74771_c("MintNature") : -1;
            EnumNature enumNature = this.mintNature = mintNature == -1 ? null : EnumNature.getNatureFromIndex(mintNature);
            if (NBT_VERSION == 0 && this.mintNature == EnumNature.Hardy) {
                this.mintNature = null;
            }
            this.setGrowth(EnumGrowth.getGrowthFromIndex(nbt.func_74771_c("Growth")));
            this.eggCycles = nbt.func_74764_b("eggCycles") ? Integer.valueOf(nbt.func_74762_e("eggCycles")) : null;
            this.eggSteps = this.eggCycles != null && nbt.func_74764_b("steps") ? Integer.valueOf(nbt.func_74762_e("steps")) : null;
            this.originalTrainerName = nbt.func_74779_i("originalTrainer");
            this.originalTrainerUUID = nbt.func_186857_a("originalTrainerUUID");
            this.levelContainer.setLevel(nbt.func_74762_e("Level"));
            this.dynamaxLevel = nbt.func_74762_e("DynamaxLevel");
            this.experience = nbt.func_74762_e("EXP");
            this.setDoesLevel(nbt.func_74767_n("DoesLevel"));
            this.setFriendship(nbt.func_74765_d("Friendship"));
            this.moveset.readFromNBT(nbt);
            this.stats.readFromNBT(nbt);
            this.bonusStats.readFromNBT(nbt);
            this.health = nbt.func_74762_e("Health");
            if (this.getExtraStats() != null) {
                this.extraStats.readFromNBT(nbt);
            }
            if (nbt.func_74764_b("AbilitySlot")) {
                this.setAbilitySlot(nbt.func_74771_c("AbilitySlot"));
            } else if (nbt.func_74764_b("Ability")) {
                try {
                    String abilityName = nbt.func_74779_i("Ability");
                    try {
                        AbilityBase.getAbility(abilityName).get();
                        this.setAbility(abilityName);
                    }
                    catch (Exception e) {
                        if (abilityName.equals("ComingSoon")) {
                            if (nbt.func_74764_b("AbilitySlot")) {
                                int tempAbilitySlot = nbt.func_74762_e("AbilitySlot");
                                if (this.getBaseStats().abilities != null && this.getBaseStats().abilities[tempAbilitySlot] != null) {
                                    abilityName = this.getBaseStats().abilities[tempAbilitySlot];
                                    this.setAbility(AbilityBase.getAbility(abilityName).get());
                                }
                            } else if (RandomHelper.getRandomChance(1.0f / PixelmonConfig.getHiddenAbilityRate(this.dimension))) {
                                this.setAbilitySlot(2);
                            } else {
                                this.setAbilitySlot(RandomHelper.getRandomNumberBetween(0, this.getBaseStats().abilities[1] == null ? 0 : 1));
                            }
                            break block49;
                        }
                        if (RandomHelper.getRandomChance(1.0f / PixelmonConfig.getHiddenAbilityRate(this.dimension))) {
                            this.setAbilitySlot(2);
                            break block49;
                        }
                        this.setAbilitySlot(RandomHelper.getRandomNumberBetween(0, this.getBaseStats().abilities[1] == null ? 0 : 1));
                    }
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.info("Didn't have an Ability; giving it one.");
                    if (RandomHelper.getRandomChance(1.0f / PixelmonConfig.getHiddenAbilityRate(this.dimension))) {
                        this.setAbilitySlot(2);
                        break block49;
                    }
                    this.setAbilitySlot(RandomHelper.getRandomNumberBetween(0, this.getBaseStats().abilities[1] == null ? 0 : 1));
                }
            } else if (RandomHelper.getRandomChance(1.0f / PixelmonConfig.getHiddenAbilityRate(this.dimension))) {
                this.setAbilitySlot(2);
            } else {
                this.setAbilitySlot(RandomHelper.getRandomNumberBetween(0, this.getBaseStats().abilities[1] == null ? 0 : 1));
            }
        }
        if (nbt.func_74764_b("Pokerus")) {
            this.pokerus = Pokerus.deserializeFromNBT(nbt.func_74775_l("Pokerus"));
        }
        this.inRanch = nbt.func_74767_n("isInRanch");
        this.relearnableMoves = new ArrayList();
        if (nbt.func_74764_b("EggMoves")) {
            for (int moveID : nbt.func_74759_k("EggMoves")) {
                this.relearnableMoves.add(moveID);
            }
        }
        if (nbt.func_74764_b("RelearnableMoves")) {
            for (int moveID : nbt.func_74759_k("RelearnableMoves")) {
                if (this.relearnableMoves.contains(moveID)) continue;
                this.relearnableMoves.add(moveID);
            }
        }
        this.status = StatusPersist.readStatusFromNBT(nbt);
        this.heldItem = ItemHeld.readHeldItemFromNBT(nbt);
        this.persistentData = nbt.func_74775_l("PersistentData");
        if (nbt.func_74764_b("pixelmonID1")) {
            int[] id = new int[]{nbt.func_74762_e("pixelmonID1"), nbt.func_74762_e("pixelmonID2")};
            this.persistentData.func_74783_a("OLD_pixelmonID", id);
        }
        if (nbt.func_74764_b("ForgeData") && nbt.func_74764_b("pixelmonID1")) {
            NBTTagCompound customEntityData = nbt.func_74775_l("ForgeData");
            this.persistentData.func_179237_a(customEntityData);
        }
        if (nbt.func_74764_b("isEgg") && !nbt.func_74767_n("isEgg")) {
            this.eggCycles = null;
        }
        if (nbt.func_74764_b("MoveSkillCooldowns")) {
            NBTTagCompound moveSkillCooldowns = nbt.func_74775_l("MoveSkillCooldowns");
            for (String moveSkillID : moveSkillCooldowns.func_150296_c()) {
                MoveSkill moveSkill;
                if (moveSkillID.endsWith("Most")) {
                    moveSkillID = moveSkillID.substring(0, moveSkillID.length() - 4);
                }
                if ((moveSkill = MoveSkill.getMoveSkillByID(moveSkillID)) == null) continue;
                UUID cooldown = moveSkillCooldowns.func_186857_a(moveSkill.id);
                this.moveSkillCooldownData.put(moveSkill.id, (Tuple<Long, Long>)new Tuple((Object)cooldown.getMostSignificantBits(), (Object)cooldown.getLeastSignificantBits()));
            }
        }
        if (nbt.func_74764_b("SpecFlags")) {
            for (NBTBase str : nbt.func_150295_c("SpecFlags", 8)) {
                String s = ((NBTTagString)str).func_150285_a_();
                this.specFlags.add(s);
            }
        } else {
            for (ISpecType specType : PokemonSpec.extraSpecTypes) {
                String key;
                if (!(specType instanceof SpecFlag) || !this.persistentData.func_74767_n(key = ((SpecFlag)specType).key)) continue;
                this.specFlags.add(((SpecFlag)specType).key);
                this.persistentData.func_82580_o(key);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("NBT_VERSION", (byte)1);
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74757_a("IsShiny", this.isShiny);
        if (!this.customTexture.isEmpty()) {
            nbt.func_74778_a("CustomTexture", this.customTexture);
        } else {
            nbt.func_82580_o("CustomTexture");
        }
        if (this.nickname != null && !this.nickname.isEmpty() && !Objects.equals(this.nickname, this.species.name)) {
            nbt.func_74778_a("Nickname", this.nickname);
        } else {
            nbt.func_82580_o("Nickname");
        }
        if (this.caughtBall != null) {
            nbt.func_74774_a("CaughtBall", (byte)this.caughtBall.ordinal());
        } else {
            nbt.func_82580_o("CaughtBall");
        }
        nbt.func_74774_a("Nature", (byte)this.nature.index);
        if (this.mintNature != null) {
            nbt.func_74774_a("MintNature", (byte)this.mintNature.index);
        }
        nbt.func_74774_a("Growth", (byte)this.growth.index);
        if (this.eggCycles != null) {
            nbt.func_74768_a("eggCycles", this.eggCycles.intValue());
            nbt.func_74768_a("steps", this.getEggSteps());
        } else {
            nbt.func_82580_o("eggCycles");
        }
        if (this.originalTrainerName != null && !this.originalTrainerName.isEmpty()) {
            nbt.func_74778_a("originalTrainer", this.originalTrainerName);
        } else {
            nbt.func_82580_o("originalTrainer");
        }
        if (this.originalTrainerUUID != null) {
            nbt.func_186854_a("originalTrainerUUID", this.originalTrainerUUID);
        } else {
            nbt.func_82580_o("originalTrainerUUID");
        }
        nbt.func_74768_a("Level", this.level);
        nbt.func_74768_a("DynamaxLevel", this.dynamaxLevel);
        nbt.func_74768_a("EXP", this.experience);
        nbt.func_74757_a("DoesLevel", this.doesLevel);
        nbt.func_74757_a("isInRanch", this.inRanch);
        nbt.func_74777_a("Friendship", (short)this.friendship);
        this.moveset.writeToNBT(nbt);
        this.stats.writeToNBT(nbt);
        this.bonusStats.writeToNBT(nbt);
        nbt.func_74768_a("Health", this.health);
        if (this.getExtraStats() != null) {
            this.extraStats.writeToNBT(nbt);
        }
        if (this.abilitySlot != -1) {
            nbt.func_74774_a("AbilitySlot", (byte)this.abilitySlot);
        } else if (this.ability != null) {
            String abilityName = this.getAbilityName();
            nbt.func_74778_a("Ability", abilityName);
        }
        if (this.pokerus != null) {
            nbt.func_74782_a("Pokerus", (NBTBase)this.pokerus.serializeToNBT());
        }
        this.status.writeToNBT(nbt);
        ItemHeld.writeHeldItemToNBT(nbt, this.heldItem);
        nbt.func_74782_a("PersistentData", (NBTBase)this.persistentData);
        if (!this.relearnableMoves.isEmpty()) {
            int[] relearnableMoves = new int[this.relearnableMoves.size()];
            for (int i = 0; i < this.relearnableMoves.size(); ++i) {
                relearnableMoves[i] = this.relearnableMoves.get(i);
            }
            nbt.func_74783_a("RelearnableMoves", relearnableMoves);
        }
        NBTTagCompound moveSkillCooldowns = new NBTTagCompound();
        long cur = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_82737_E();
        for (Map.Entry<String, Tuple<Long, Long>> entry : this.moveSkillCooldownData.entrySet()) {
            if ((Long)entry.getValue().func_76340_b() < cur) continue;
            moveSkillCooldowns.func_186854_a(entry.getKey(), new UUID((Long)entry.getValue().func_76341_a(), (Long)entry.getValue().func_76340_b()));
        }
        if (moveSkillCooldowns.func_186856_d() != 0) {
            nbt.func_74782_a("MoveSkillCooldowns", (NBTBase)moveSkillCooldowns);
        }
        NBTTagList specList = new NBTTagList();
        for (String specFlag : this.specFlags) {
            specList.func_74742_a((NBTBase)new NBTTagString(specFlag));
        }
        nbt.func_74782_a("SpecFlags", (NBTBase)specList);
        return nbt;
    }

    @Override
    public void registerDataParameters(Map<String, DataParameter<?>> map) {
        super.registerDataParameters(map);
        this.dataSyncMap.put(map.get("uuid").func_187155_a(), this.dsUUID.registerDataParameter(map.get("uuid")));
        this.dataSyncMap.put(map.get("growth").func_187155_a(), this.dsGrowth.registerDataParameter(map.get("growth")));
        this.dataSyncMap.put(map.get("level").func_187155_a(), this.dsLevel.registerDataParameter(map.get("level")));
        this.dataSyncMap.put(map.get("exp").func_187155_a(), this.dsExp.registerDataParameter(map.get("exp")));
        this.dataSyncMap.put(map.get("shiny").func_187155_a(), this.dsShiny.registerDataParameter(map.get("shiny")));
        this.dataSyncMap.put(map.get("customTexture").func_187155_a(), this.dsCustomTexture.registerDataParameter(map.get("customTexture")));
        this.dataSyncMap.put(map.get("nickname").func_187155_a(), this.dsNickname.registerDataParameter(map.get("nickname")));
        this.dataSyncMap.put(map.get("health").func_187155_a(), this.dsHealth.registerDataParameter(map.get("health")));
        if (map.containsKey("owner")) {
            this.dataSyncMap.put(map.get("owner").func_187155_a(), this.dsOwner.registerDataParameter(map.get("owner")));
        }
    }

    public String toString() {
        return "Pokemon{" + this.getLocalizedName() + "}";
    }
}

