/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class SpecFlag
extends SpecValue<Boolean>
implements ISpecType {
    public transient ArrayList<String> aliases = new ArrayList();

    public SpecFlag(String ... aliases) {
        super(aliases[0], true);
        for (int i = 0; i < aliases.length; ++i) {
            this.aliases.add(aliases[i]);
        }
    }

    public SpecFlag(String key, boolean value) {
        super(key, value);
    }

    @Override
    public List<String> getKeys() {
        return this.aliases;
    }

    public SpecValue<Boolean> make(boolean value) {
        return new SpecFlag(this.key, value);
    }

    public SpecValue<Boolean> parse(String arg) {
        if (arg == null || !arg.equalsIgnoreCase("false")) {
            return this.make(true);
        }
        return this.make(false);
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return this.make(nbt.func_74767_n(this.key));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74757_a(this.key, Boolean.parseBoolean(value.value.toString()));
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return this.getClass();
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return this.key + ":" + value.value.toString();
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        if (!pokemon.hasSpecFlag(this.key) && ((Boolean)this.value).booleanValue()) {
            pokemon.addSpecFlag(this.key);
        } else if (!((Boolean)this.value).booleanValue()) {
            pokemon.removeSpecFlag(this.key);
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.hasSpecFlag(this.key) == ((Boolean)this.value).booleanValue();
    }

    @Override
    public SpecValue<Boolean> clone() {
        return this.parse(((Boolean)this.value).toString());
    }

    public boolean sentToClient() {
        return true;
    }
}

