/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.screens;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.OpenBadgeCasePacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CustomBadgeCaseScreen {
    public static void openDisplayCase(EntityPlayerMP player, String name, EnumBadgeCase color, List<ItemStack> badges, List<Pokemon> pokemon) {
        CustomBadgeCaseScreen.builder().setTitle(name).setAllowEditing(false).setColor(color).setBadges(badges).setPokemon(pokemon).sendTo(player);
    }

    public static void openDisplayCase(EntityPlayerMP player, String name, EnumBadgeCase color, List<ItemStack> badges) {
        CustomBadgeCaseScreen.builder().setTitle(name).setAllowEditing(false).setColor(color).setBadges(badges).sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String title) {
        return new Builder().setTitle(title);
    }

    public static class Builder {
        private String owner = null;
        private boolean allowEdit;
        private EnumBadgeCase color;
        private List<ItemStack> badges = Lists.newArrayList();
        private final List<Pokemon> party = Lists.newArrayList();

        public Builder setTitle(String title) {
            this.owner = (String)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder setAllowEditing(boolean allowEdit) {
            this.allowEdit = allowEdit;
            return this;
        }

        public Builder setColor(EnumBadgeCase color) {
            this.color = (EnumBadgeCase)((Object)Preconditions.checkNotNull((Object)((Object)color), (Object)"color"));
            return this;
        }

        public Builder setBadges(List<ItemStack> badges) {
            Preconditions.checkNotNull(badges, (Object)"badges");
            Preconditions.checkArgument((badges.size() <= 100 ? 1 : 0) != 0, (Object)"Badge list size must be less then 100");
            for (int i = 0; i < badges.size(); ++i) {
                Preconditions.checkNotNull((Object)badges.get(i), (Object)("stack #" + i));
                Preconditions.checkArgument((!badges.get(i).func_190926_b() ? 1 : 0) != 0, (Object)("stack #" + i + " cannot be empty"));
            }
            this.badges = Lists.newArrayList(badges);
            return this;
        }

        public Builder addBadge(ItemStack stack) {
            Preconditions.checkNotNull((Object)stack, (Object)"stack");
            Preconditions.checkArgument((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"Item stack cannot be empty");
            this.badges.add(stack);
            return this;
        }

        public Builder setPokemon(List<Pokemon> pokemon) {
            Preconditions.checkNotNull(pokemon, (Object)"pokemon");
            Preconditions.checkArgument((pokemon.size() <= 6 ? 1 : 0) != 0, (Object)"List cannot exceed a size of 6");
            this.party.clear();
            for (int i = 0; i < 6; ++i) {
                if (pokemon.size() > i) {
                    this.party.add(i, pokemon.get(i));
                    continue;
                }
                this.party.set(i, null);
            }
            return this;
        }

        public void sendTo(EntityPlayerMP player) {
            if (this.owner == null) {
                this.owner = "";
            }
            Pixelmon.network.sendTo((IMessage)new OpenBadgeCasePacket(this.owner, this.allowEdit, true, this.color, this.badges, this.party), player);
        }
    }
}

