/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendaryCheckSpawnsEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICheckSpawns;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LegendaryCheckSpawns
implements ICheckSpawns {
    public String node;

    public LegendaryCheckSpawns(String node) {
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, ICommandSender sender, List<String> arguments) {
        if (!(spawner instanceof LegendarySpawner)) {
            return;
        }
        LegendaryCheckSpawnsEvent event = new LegendaryCheckSpawnsEvent(sender);
        Pixelmon.EVENT_BUS.post((Event)event);
        LegendarySpawner lSpawner = (LegendarySpawner)spawner;
        EntityPlayerMP target = null;
        ArrayList<EntityPlayerMP> targets = new ArrayList<EntityPlayerMP>();
        if (!(sender instanceof EntityPlayerMP)) {
            PlayerList playerList = sender.func_184102_h().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
        }
        if (target == null) {
            targets.addAll(sender.func_184102_h().func_184103_al().func_181057_v());
        } else {
            targets.add(target);
        }
        HashMap<String, Double> totalPercentages = new HashMap<String, Double>();
        double percentageSum = 0.0;
        for (EntityPlayerMP player : targets) {
            ArrayList<SpawnLocation> spawnLocations = lSpawner.spawnLocationCalculator.calculateSpawnableLocations(spawner.getTrackedBlockCollection((Entity)player, 0.0f, 0.0f, lSpawner.horizontalSliceRadius, lSpawner.verticalSliceRadius, 0, 0));
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            for (SpawnLocation spawnLocation : spawnLocations) {
                ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
                if (spawns.isEmpty()) continue;
                possibleSpawns.put(spawnLocation, spawns);
            }
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            for (Map.Entry<String, Double> entry : percentages.entrySet()) {
                totalPercentages.put(entry.getKey(), entry.getValue() + totalPercentages.getOrDefault(entry.getKey(), 0.0));
                percentageSum += entry.getValue().doubleValue();
            }
        }
        DecimalFormat df = new DecimalFormat(".####", DecimalFormatSymbols.getInstance(Locale.US));
        DecimalFormat df2 = new DecimalFormat(".##", DecimalFormatSymbols.getInstance(Locale.US));
        if (percentageSum > 100.0) {
            double multiplier = 100.0 / percentageSum;
            for (String string : totalPercentages.keySet()) {
                double percentage = (Double)totalPercentages.get(string) * multiplier;
                if (percentage < 0.01 || percentage > 99.99) {
                    totalPercentages.put(string, Double.parseDouble(df.format(percentage)));
                    continue;
                }
                totalPercentages.put(string, Double.parseDouble(df2.format(percentage)));
            }
        }
        sender.func_184102_h().func_152344_a(() -> {
            ArrayList<Object> messages = new ArrayList<Object>();
            long timeToGo = lSpawner.nextSpawnTime - System.currentTimeMillis();
            int minutes = (int)Math.ceil((float)timeToGo / 1000.0f / 60.0f);
            if (event.shouldShowTime) {
                messages.add(this.translate(TextFormatting.GOLD, "spawning.checkspawns.timeuntilnextattempt1", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)this.translate(TextFormatting.DARK_AQUA, "spawning.checkspawns.timeuntilnextattempt2", minutes)));
            }
            if (event.shouldShowChance) {
                messages.add(this.translate(TextFormatting.GOLD, "spawning.checkspawns.chanceofspawning", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" " + TextFormatting.DARK_AQUA + new DecimalFormat(".##").format((lSpawner == PixelmonSpawning.legendarySpawner ? PixelmonConfig.getLegendaryRate() : PixelmonConfig.bossSpawnChance) * 100.0f) + "%")));
            }
            messages.add(this.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns", new Object[0]));
            messages.addAll(this.generateMessages(totalPercentages, arguments));
            messages.forEach(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
        });
    }
}

