/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICheckSpawns;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;

public class PlayerTrackingCheckSpawns
implements ICheckSpawns {
    @Override
    public void checkSpawns(AbstractSpawner spawner, ICommandSender sender, List<String> arguments) {
        if (!(spawner instanceof PlayerTrackingSpawner)) {
            ICheckSpawns.getDefault().checkSpawns(spawner, sender, arguments);
        } else {
            PlayerTrackingSpawner pSpawner = (PlayerTrackingSpawner)spawner;
            EntityPlayerMP player = pSpawner.getTrackedPlayer();
            if (player == null) {
                sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "pixelmon.command.general.invalidplayer", new Object[0]));
                return;
            }
            ArrayList<SpawnLocation> spawnLocations = pSpawner.spawnLocationCalculator.calculateSpawnableLocations(spawner.getTrackedBlockCollection((Entity)player, 0.0f, 0.0f, pSpawner.horizontalSliceRadius, pSpawner.verticalSliceRadius, 0, 0));
            for (String argument : arguments) {
                if (!argument.equalsIgnoreCase("specific")) continue;
                spawnLocations.removeIf(spawnLocation -> !spawnLocation.location.pos.equals((Object)player.func_180425_c()));
                if (!spawnLocations.isEmpty()) break;
                sender.func_145747_a((ITextComponent)this.translate(TextFormatting.RED, "spawning.error.midairorinvalid", new Object[0]));
                return;
            }
            HashMap<SpawnLocation, ArrayList<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, ArrayList<SpawnInfo>>();
            for (SpawnLocation spawnLocation2 : spawnLocations) {
                ArrayList<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation2);
                if (spawns.isEmpty()) continue;
                possibleSpawns.put(spawnLocation2, spawns);
            }
            sender.func_184102_h().func_152344_a(() -> {
                Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
                List<TextComponentBase> messages = this.generateMessages(percentages, arguments);
                messages.add(0, (TextComponentBase)this.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns", new Object[0]));
                messages.forEach(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
            });
        }
    }
}

