/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ICalculateSpawnLocations;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.List;
import net.minecraft.entity.Entity;

public abstract class TickingSpawner
extends AbstractSpawner {
    public long lastCycleTime = 0L;
    public long nextSpawnTime = 0L;
    public ICalculateSpawnLocations spawnLocationCalculator = ICalculateSpawnLocations.getDefault();
    public int capacity = PixelmonConfig.entitiesPerPlayer;
    public int spawnsPerPass = PixelmonConfig.spawnsPerPass;
    public float spawnFrequency = PixelmonConfig.spawnFrequency;
    public float minDistBetweenSpawns = PixelmonConfig.minimumDistanceBetweenSpawns;
    private int pass = -1;

    public TickingSpawner(String name) {
        super(name);
    }

    public abstract List<SpawnAction<? extends Entity>> getSpawns(int var1);

    public abstract int getNumPasses();

    public boolean hasCapacity(int numSpawns) {
        if (this.capacity == -1 || PixelmonConfig.maximumSpawnedPokemon < 0) {
            return true;
        }
        return numSpawns + this.spawned.size() <= this.capacity;
    }

    @Override
    public boolean shouldDoSpawning() {
        return super.shouldDoSpawning() && this.hasCapacity(1) && ((this.pass + 1) % this.getNumPasses() != 0 || System.currentTimeMillis() > this.nextSpawnTime);
    }

    public void onSpawnEnded() {
        this.lastCycleTime = System.currentTimeMillis();
        this.nextSpawnTime = this.lastCycleTime + (long)(60000.0 / (double)this.spawnFrequency);
    }

    public void doPass(SpawnerCoordinator coordinator) {
        this.pass = (this.pass + 1) % this.getNumPasses();
        List<SpawnAction<? extends Entity>> spawns = this.getSpawns(this.pass);
        if (spawns != null && !spawns.isEmpty()) {
            while (!this.hasCapacity(1) || spawns.size() > this.spawnsPerPass) {
                spawns.remove(RandomHelper.rand.nextInt(spawns.size()));
            }
            for (SpawnAction<? extends Entity> spawn : spawns) {
                spawn.doSpawn(this);
            }
        }
        this.onSpawnEnded();
    }

    public static abstract class TickingSpawnerBuilder<T extends TickingSpawner>
    extends AbstractSpawner.SpawnerBuilder<T> {
        protected ICalculateSpawnLocations spawnLocationCalculator = ICalculateSpawnLocations.getDefault();
        protected Integer capacity = null;
        protected Integer spawnsPerPass = null;
        protected Float minDistBetweenSpawns = null;
        protected Float spawnFrequency = null;

        public <E extends TickingSpawnerBuilder<T>> E setSpawnLocationCalculator(ICalculateSpawnLocations spawnLocationCalculator) {
            if (spawnLocationCalculator != null) {
                this.spawnLocationCalculator = spawnLocationCalculator;
            }
            return (E)((TickingSpawnerBuilder)this.getThis());
        }

        public <E extends TickingSpawnerBuilder<T>> E setSpawnFrequency(float spawnFrequency) {
            if (spawnFrequency == 0.0f) {
                spawnFrequency = 1.0E-5f;
            }
            this.spawnFrequency = Float.valueOf(spawnFrequency);
            return (E)((TickingSpawnerBuilder)this.getThis());
        }

        public <E extends TickingSpawnerBuilder<T>> E setCapacity(int capacity) {
            if (capacity < 0 && capacity != -1) {
                capacity = 0;
            }
            this.capacity = capacity;
            return (E)((TickingSpawnerBuilder)this.getThis());
        }

        public <E extends TickingSpawnerBuilder<T>> E setDistanceBetweenSpawns(float minDistBetweenSpawns) {
            if (minDistBetweenSpawns < 0.0f) {
                minDistBetweenSpawns = 0.0f;
            }
            this.minDistBetweenSpawns = Float.valueOf(minDistBetweenSpawns);
            return (E)((TickingSpawnerBuilder)this.getThis());
        }

        public <E extends TickingSpawnerBuilder<T>> E setSpawnsPerPass(int spawnsPerPass) {
            if (spawnsPerPass < 0) {
                spawnsPerPass = 0;
            }
            this.spawnsPerPass = spawnsPerPass;
            return (E)((TickingSpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            ((TickingSpawner)spawner).spawnLocationCalculator = this.spawnLocationCalculator;
            ((TickingSpawner)spawner).capacity = this.capacity != null ? this.capacity : PixelmonConfig.entitiesPerPlayer;
            ((TickingSpawner)spawner).spawnsPerPass = this.spawnsPerPass != null ? this.spawnsPerPass : PixelmonConfig.spawnsPerPass;
            ((TickingSpawner)spawner).spawnFrequency = this.spawnFrequency != null ? this.spawnFrequency.floatValue() : PixelmonConfig.spawnFrequency;
            ((TickingSpawner)spawner).minDistBetweenSpawns = this.minDistBetweenSpawns != null ? this.minDistBetweenSpawns.floatValue() : PixelmonConfig.minimumDistanceBetweenSpawns;
            super.apply(spawner);
            return spawner;
        }
    }
}

