/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.enums.EnumType;

public class HiddenPower
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        user.attack.overrideType(HiddenPower.getHiddenPowerType(user.getStats().ivs));
        return AttackResult.proceed;
    }

    public static EnumType getHiddenPowerType(IVStore ivs) {
        int f = ivs.specialDefence % 2;
        int e = ivs.specialAttack % 2;
        int d = ivs.speed % 2;
        int c = ivs.defence % 2;
        int b = ivs.attack % 2;
        int a = ivs.hp % 2;
        double fedbca = 32 * f + 16 * e + 8 * d + 4 * c + 2 * b + a;
        int type = (int)Math.floor(fedbca * 15.0 / 63.0);
        if (type == 0) {
            return EnumType.Fighting;
        }
        if (type == 1) {
            return EnumType.Flying;
        }
        if (type == 2) {
            return EnumType.Poison;
        }
        if (type == 3) {
            return EnumType.Ground;
        }
        if (type == 4) {
            return EnumType.Rock;
        }
        if (type == 5) {
            return EnumType.Bug;
        }
        if (type == 6) {
            return EnumType.Ghost;
        }
        if (type == 7) {
            return EnumType.Steel;
        }
        if (type == 8) {
            return EnumType.Fire;
        }
        if (type == 9) {
            return EnumType.Water;
        }
        if (type == 10) {
            return EnumType.Grass;
        }
        if (type == 11) {
            return EnumType.Electric;
        }
        if (type == 12) {
            return EnumType.Psychic;
        }
        if (type == 13) {
            return EnumType.Ice;
        }
        if (type == 14) {
            return EnumType.Dragon;
        }
        return EnumType.Dark;
    }

    public static IVStore getOptimalIVs(EnumType type) {
        IVStore ivs = new IVStore();
        ivs.hp = 31;
        ivs.attack = 31;
        ivs.defence = 31;
        ivs.specialAttack = 31;
        ivs.specialDefence = 31;
        ivs.speed = 31;
        switch (type) {
            case Bug: {
                ivs.attack = 30;
                ivs.defence = 30;
                ivs.specialDefence = 30;
                break;
            }
            case Dark: {
                break;
            }
            case Dragon: {
                ivs.attack = 30;
                break;
            }
            case Electric: {
                ivs.specialAttack = 30;
                break;
            }
            case Fighting: {
                ivs.defence = 30;
                ivs.specialAttack = 30;
                ivs.specialDefence = 30;
                ivs.speed = 30;
                break;
            }
            case Fire: {
                ivs.attack = 30;
                ivs.specialAttack = 30;
                ivs.speed = 30;
                break;
            }
            case Flying: {
                ivs.hp = 30;
                ivs.attack = 30;
                ivs.defence = 30;
                ivs.specialAttack = 30;
                ivs.specialDefence = 30;
                break;
            }
            case Ghost: {
                ivs.attack = 30;
                ivs.specialDefence = 30;
                break;
            }
            case Grass: {
                ivs.attack = 30;
                ivs.specialAttack = 30;
                break;
            }
            case Ground: {
                ivs.specialAttack = 30;
                ivs.specialDefence = 30;
                break;
            }
            case Ice: {
                ivs.attack = 30;
                ivs.defence = 30;
                break;
            }
            case Poison: {
                ivs.defence = 30;
                ivs.specialAttack = 30;
                ivs.specialDefence = 30;
                break;
            }
            case Psychic: {
                ivs.attack = 30;
                ivs.speed = 30;
                break;
            }
            case Rock: {
                ivs.defence = 30;
                ivs.specialDefence = 30;
                ivs.speed = 30;
                break;
            }
            case Steel: {
                ivs.specialDefence = 30;
                break;
            }
            case Water: {
                ivs.attack = 30;
                ivs.defence = 30;
                ivs.specialAttack = 30;
                break;
            }
        }
        return ivs;
    }
}

