/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.ArrayList;

public class Trick
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        ItemHeld userItem = user.getHeldItem();
        ItemHeld targetItem = target.getHeldItem();
        if (!((user.hasHeldItem() || target.hasHeldItem()) && user.isItemRemovable(user) && target.isItemRemovable(user) && target.isItemGivable(userItem))) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (userItem.getHeldItemType() == EnumHeldItems.choiceItem && targetItem.getHeldItemType() == EnumHeldItems.choiceItem) {
            user.choiceSwapped = true;
            target.choiceSwapped = true;
        }
        userItem.applySwitchOutEffect(user);
        targetItem.applySwitchOutEffect(target);
        user.bc.sendToAll("pixelmon.effect.trick", user.getNickname(), target.getNickname());
        if (targetItem != NoItem.noItem) {
            user.bc.sendToAll("pixelmon.effect.trickitem", user.getNickname(), targetItem.getLocalizedName());
        }
        user.setNewHeldItem(targetItem);
        if (userItem != NoItem.noItem) {
            target.bc.sendToAll("pixelmon.effect.trickitem", target.getNickname(), userItem.getLocalizedName());
        }
        target.setNewHeldItem(userItem);
        user.bc.enableReturnHeldItems(user, target);
        target.bc.modifyStats(target);
        user.bc.modifyStats(user);
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        ItemHeld userItem = pw.getHeldItem();
        boolean userNegative = userItem == null || userItem.hasNegativeEffect();
        for (PixelmonWrapper target : userChoice.targets) {
            boolean targetNegative;
            ItemHeld targetItem = target.getHeldItem();
            boolean bl = targetNegative = targetItem == null || targetItem.hasNegativeEffect();
            if (!userNegative || targetNegative) continue;
            userChoice.raiseWeight(40.0f);
        }
    }
}

