/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.DynamaxEvent;
import com.pixelmonmod.pixelmon.api.events.MegaEvolutionEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonKnockoutEvent;
import com.pixelmonmod.pixelmon.api.events.battles.UseBattleItemEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.MultipleHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.Recoil;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BatonPass;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BeatUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.FalseSwipe;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleKick;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.CalcPriority;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.BagItemAction;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.log.SwitchAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariation;
import com.pixelmonmod.pixelmon.battles.status.PsychicTerrain;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Substitute;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.Dynamax;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.LevelUpUpdate;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.MegaEvolve;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateMoveset;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UseItem;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UseZMove;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.StatusPacket;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2Client;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Corrosion;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Illusion;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Imposter;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Levitate;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Multitype;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.RKSSystem;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.StickyHold;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Trace;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BattleStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.TempBattleLevel;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.forms.EnumMega;
import com.pixelmonmod.pixelmon.enums.forms.EnumNecrozma;
import com.pixelmonmod.pixelmon.enums.forms.EnumPrimal;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.ItemMemory;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.items.heldItems.ItemOrb;
import com.pixelmonmod.pixelmon.items.heldItems.ItemPlate;
import com.pixelmonmod.pixelmon.items.heldItems.ItemZCrystal;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PixelmonWrapper {
    public EntityPixelmon entity;
    public Pokemon pokemon;
    public Pokemon initialCopyOfPokemon;
    private BattleParticipant participant;
    public BattleControllerBase bc;
    public Attack attack;
    public Attack selectedAttack;
    public Attack lastAttack;
    public List<PixelmonWrapper> lastTargets = new ArrayList<PixelmonWrapper>();
    public int targetIndex;
    public Set<Attack> usedMoves = new HashSet<Attack>();
    public int escapeAttempts = 0;
    public int damageTakenThisTurn = 0;
    public float priority;
    public boolean canAttack = true;
    public boolean willTryFlee = false;
    public boolean isSwitching = false;
    public boolean willEvolve = false;
    public boolean nextSwitchIsMove;
    public UUID willUseItemPokemon;
    public ItemStack willUseItemInStack;
    public int willUseItemInStackInfo;
    public boolean wait;
    public int battlePosition;
    private int partyPosition;
    private double[] basePos;
    private List<EnumType> initialType = null;
    public EnumType addedType;
    public AbilityBase tempAbility = null;
    public Moveset temporaryMoveset = null;
    private boolean returnHeldItem = false;
    public List<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
    public UUID newPokemonUUID;
    public boolean inMultipleHit = false;
    public boolean inParentalBond = false;
    public int protectsInARow = 0;
    public boolean hasAwardedExp = false;
    private Set<PixelmonWrapper> attackers = new HashSet<PixelmonWrapper>();
    public boolean switchedThisTurn = false;
    public boolean changeBurmy = false;
    public Attack choiceLocked;
    public boolean choiceSwapped = false;
    public int metronomeBoost;
    private ItemHeld consumedHeldItem = NoItem.noItem;
    public boolean eatenBerry = false;
    public boolean eatingBerry = false;
    public int lastDirectDamage = -1;
    public int lastHP = -1;
    public AttackCategory lastDirectCategory;
    public int lastDirectPosition;
    public EvolutionQuery evolution = null;
    private boolean tempLevel;
    protected Level temporaryLevel = null;
    int startHealth;
    private BattleStats battleStats = new BattleStats(this);
    private List<StatusBase> status = new ArrayList<StatusBase>();
    public List<EnumType> type = new ArrayList<EnumType>();
    public boolean isMega;
    public int isDynamax;
    public int dynamaxTurns = 3;
    public int dynamaxAnimationTicks = 0;
    public static final int dynamaxAnimationTicksUp = 60;
    public static final float dynamaxAnimationTicksUpAmount = 0.1f;
    public static final int dynamaxAnimationTicksDown = 60;
    public static final float dynamaxAnimationTicksDownAmount = 0.1f;
    public boolean animateHP = true;
    public boolean usingZ = false;
    public ZMove zMove = null;
    public boolean ignoringZCrystal = false;

    private PixelmonWrapper(BattleParticipant participant) {
        this.participant = participant;
    }

    public PixelmonWrapper(BattleParticipant participant, EntityPixelmon entity, int partyPosition) {
        this(participant);
        this.pokemon = entity.getPokemonData();
        this.entity = entity;
        this.entity.setPixelmonWrapper(this);
        this.loadFromPokemon(this.pokemon);
        this.isMega = entity.getSpecies().hasMega() && entity.getBossMode().isBossPokemon();
    }

    public PixelmonWrapper(BattleParticipant participant, EntityPixelmon pixelmon, int partyPosition, BattleControllerBase bc) {
        this(participant, pixelmon, partyPosition);
        this.entity.battleController = bc;
        this.bc = bc;
    }

    public PixelmonWrapper(BattleParticipant participant, Pokemon pokemon, int partyPosition) {
        this(participant);
        this.pokemon = pokemon;
        this.loadFromPokemon(pokemon);
        this.isMega = false;
        this.isDynamax = 0;
        this.partyPosition = partyPosition;
    }

    private void loadFromPokemon(Pokemon pokemon) {
        this.isMega = false;
        this.isDynamax = 0;
        this.dynamaxAnimationTicks = 0;
        this.type = new ArrayList<EnumType>(pokemon.getBaseStats().types);
        this.initialCopyOfPokemon = Pixelmon.pokemonFactory.create(pokemon.writeToNBT(new NBTTagCompound()));
        if (pokemon.getStatus() != NoStatus.noStatus) {
            this.getStatuses().add(pokemon.getStatus());
        }
    }

    public BaseStats getBaseStats() {
        return this.pokemon.getBaseStats();
    }

    public Stats getStats() {
        return this.pokemon.getStats();
    }

    public BattleStats getBattleStats() {
        return this.battleStats;
    }

    public List<EnumType> getInitialType() {
        return this.initialType;
    }

    public int getFriendship() {
        return this.pokemon.getFriendship();
    }

    public Set<PixelmonWrapper> getAttackers() {
        return this.attackers;
    }

    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.getInnerLink().getPokerus());
    }

    public boolean hasType(EnumType ... types) {
        for (EnumType type : types) {
            if (!this.type.contains(type)) continue;
            return true;
        }
        return false;
    }

    public void clearTurnVariables() {
        this.canAttack = true;
        this.willTryFlee = false;
        if (this.isAlive()) {
            this.isSwitching = false;
        }
        this.switchedThisTurn = false;
    }

    public void setMoveTargets(PixelmonWrapper ... pokemon) {
        this.targets.clear();
        Collections.addAll(this.targets, pokemon);
    }

    public void selectAIAction() {
        if (this.attack == null || !this.attack.doesPersist(this)) {
            if (this.bc == null) {
                this.bc = this.participant.bc;
            }
            this.chooseMove();
        }
    }

    public void chooseMove() {
        this.chooseMove(this.participant.getMove(this));
    }

    public void chooseMove(MoveChoice moveChoice) {
        if (moveChoice != null) {
            if (moveChoice.isAttack()) {
                this.setAttack(moveChoice.attack, moveChoice.targets, true);
            } else {
                this.bc.switchPokemon(this.getPokemonUUID(), moveChoice.switchPokemon, false);
            }
        }
    }

    public ArrayList<PixelmonWrapper> getTargets(Attack chosenAttack) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        if (chosenAttack == null) {
            return targets;
        }
        TargetingInfo info = chosenAttack.getMove().getTargetingInfo();
        ArrayList<PixelmonWrapper> teamPokemon = this.bc.getTeamPokemon(this.participant);
        ArrayList<PixelmonWrapper> opponentPokemon = this.bc.getOpponentPokemon(this.participant);
        boolean[][] targetted = new boolean[][]{new boolean[teamPokemon.size()], new boolean[opponentPokemon.size()]};
        int mypos = teamPokemon.indexOf(this);
        if (info.hitsAll) {
            if (info.hitsOppositeFoe && targetted[1].length > mypos) {
                targetted[1][mypos] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (mypos - 1 >= 0) {
                    targetted[1][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[1].length) {
                    targetted[1][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos - 2 >= 0) {
                    targetted[1][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[1].length) {
                    targetted[1][mypos + 2] = true;
                }
            }
            if (info.hitsSelf) {
                targetted[0][mypos] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (mypos - 1 >= 0) {
                    targetted[0][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[0].length) {
                    targetted[0][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos - 2 >= 0) {
                    targetted[0][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[0].length) {
                    targetted[0][mypos + 2] = true;
                }
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < targetted[i].length; ++j) {
                    if (!targetted[i][j]) continue;
                    if (i == 0) {
                        targets.add(teamPokemon.get(j));
                        continue;
                    }
                    targets.add(opponentPokemon.get(j));
                }
            }
        } else {
            ArrayList<PixelmonWrapper> tempTargets = new ArrayList<PixelmonWrapper>();
            if (info.hitsSelf) {
                tempTargets.add(this);
            }
            if (info.hitsAdjacentAlly) {
                if (mypos > 0) {
                    tempTargets.add(teamPokemon.get(mypos - 1));
                }
                if (mypos < teamPokemon.size() - 1) {
                    tempTargets.add(teamPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos > 1) {
                    tempTargets.add(teamPokemon.get(mypos - 2));
                }
                if (mypos < teamPokemon.size() - 2) {
                    tempTargets.add(teamPokemon.get(mypos + 2));
                }
            }
            if (info.hitsOppositeFoe && mypos < opponentPokemon.size()) {
                tempTargets.add(opponentPokemon.get(mypos));
            }
            if (info.hitsAdjacentFoe) {
                if (mypos > 0) {
                    tempTargets.add(opponentPokemon.get(mypos - 1));
                }
                if (mypos < opponentPokemon.size() - 1) {
                    tempTargets.add(opponentPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos > 1) {
                    tempTargets.add(opponentPokemon.get(mypos - 2));
                }
                if (mypos < opponentPokemon.size() - 2) {
                    tempTargets.add(opponentPokemon.get(mypos + 2));
                }
            }
            for (int i = 0; i < tempTargets.size(); ++i) {
                if (tempTargets.get(i) != null) continue;
                tempTargets.remove(i);
                --i;
            }
            ArrayList invalid = new ArrayList();
            if (!tempTargets.isEmpty()) {
                if (info.hitsOppositeFoe || info.hitsExtendedFoe || info.hitsAdjacentFoe) {
                    invalid.addAll(tempTargets.stream().filter(pw -> pw.getParticipant().team == this.getParticipant().team || pw.isFainted()).collect(Collectors.toList()));
                }
                tempTargets.removeAll(invalid);
                if (!tempTargets.isEmpty()) {
                    targets.add((PixelmonWrapper)tempTargets.get(RandomHelper.getRandomNumberBetween(0, tempTargets.size() - 1)));
                }
            }
        }
        return targets;
    }

    public void useAttack() {
        this.selectedAttack = this.attack;
        if (!this.bc.simulateMode) {
            for (BattleParticipant participant : this.bc.participants) {
                participant.getBattleAI().registerMove(this);
            }
        }
        this.useAttack(true);
    }

    /*
     * WARNING - void declaration
     */
    public void useAttack(boolean affectPP) {
        PixelmonWrapper target2;
        if (this.attack == null || this.isFainted()) {
            return;
        }
        if (this.participant.bc.oldGen) {
            if (this.usingZ && this.zMove == null) {
                this.zMove = this.attack.getMove().getZMove(this.pokemon, this.ignoringZCrystal);
            }
            if (this.zMove == null) {
                this.usingZ = false;
            }
        }
        this.usedMoves.add(this.attack);
        this.getBattleAbility().startMove(this);
        if (!this.attack.isAttack("Focus Punch") && !this.hasStatus(StatusType.Bide)) {
            this.bc.sendToAll("pixelmon.battletext.used", this.getNickname(), this.usingZ ? this.zMove.getLocalizedName() : this.attack.getMove().getTranslatedName());
        }
        boolean reducePP = false;
        if (this.bc.rules.battleType.numPokemon > 1 && !this.attack.getMove().getTargetingInfo().hitsAll) {
            if (!this.attack.isAttack("Me First") && !this.attack.getMove().getTargetingInfo().hitsAdjacentAlly && this.attack.getMove().getTargetingInfo().hitsAdjacentFoe && this.attack.getMove().getTargetingInfo().hitsOppositeFoe) {
                this.targets = this.getTargets(this.attack);
            } else if (this.targets.size() > 1) {
                PixelmonWrapper firstPokemon = this.targets.get(0);
                this.targets.clear();
                this.targets.add(firstPokemon);
            }
        }
        if (this.attack.isAttack("Expanding Force") && this.bc.globalStatusController.getTerrain() instanceof PsychicTerrain && !this.isAlly(target2 = this.targets.get(0))) {
            this.targets.clear();
            ArrayList<PixelmonWrapper> adj = this.bc.getAdjacentPokemon(this);
            for (PixelmonWrapper pw : adj) {
                if (this.isAlly(pw)) continue;
                this.targets.add(pw);
            }
        }
        ArrayList deadPokes = new ArrayList();
        ArrayList correctedTargets = new ArrayList();
        if (!this.attack.canHitNoTarget()) {
            this.targets.stream().filter(PixelmonWrapper::isFainted).forEach(target -> {
                deadPokes.add(target);
                if (!target.isSameTeam(this) && this.targets.size() == 1) {
                    for (PixelmonWrapper otherTarget : target.getTeamPokemon()) {
                        if (otherTarget.isFainted()) continue;
                        correctedTargets.add(otherTarget);
                    }
                }
            });
            deadPokes.forEach(this.targets::remove);
            this.targets.addAll(correctedTargets.stream().collect(Collectors.toList()));
        }
        this.targets = CalcPriority.getTurnOrder(this.targets);
        MoveResults[] arr = new MoveResults[this.targets.size()];
        this.attack.hasPlayedAnimationOnce = false;
        this.targetIndex = 0;
        while (this.targetIndex < this.targets.size()) {
            void var8_10;
            PixelmonWrapper target3 = this.targets.get(this.targetIndex);
            MoveResults results = new MoveResults(target3, 0, this.priority, AttackResult.proceed);
            this.attack.saveAttack();
            reducePP = this.attack.use(this, target3, results, this.usingZ ? this.zMove : null) || reducePP;
            Object var8_11 = null;
            for (EffectBase e : new ArrayList<EffectBase>(this.attack.getMove().effects)) {
                if (!(e instanceof AttackModifierBase) || !(e instanceof CriticalHit)) continue;
                EffectBase effectBase = e;
            }
            if (Attack.calcCriticalHit((EffectBase)var8_10, this, target3) > 1.0) {
                ++this.pokemon.lastBattleCrits;
            }
            this.attack.restoreAttack();
            if (this.targetIndex >= arr.length) {
                arr = Arrays.copyOf(arr, this.targetIndex + 1);
            }
            if (arr[this.targetIndex] == null) {
                arr[this.targetIndex] = results;
            }
            ++this.targetIndex;
        }
        this.attack.hasPlayedAnimationOnce = false;
        boolean hadTarget = false;
        boolean ignore = false;
        for (MoveResults result : arr) {
            if (result == null) continue;
            if (result.result == AttackResult.ignore) {
                ignore = true;
            }
            if (result.result != AttackResult.notarget) {
                hadTarget = true;
            }
            if (result.result == AttackResult.charging || result.result == AttackResult.ignore) continue;
            this.lastAttack = this.attack;
            this.lastTargets = this.targets;
            this.bc.lastAttack = this.attack;
        }
        if (!hadTarget) {
            this.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
        if (!ignore) {
            this.bc.battleLog.addEvent(new AttackAction(this.bc.battleTurn, this.bc.getPositionOfPokemon(this), this, this.attack.getMove().getAttackId(), arr));
        }
        if (reducePP && affectPP && this.attack.pp > 0) {
            --this.attack.pp;
            this.setTemporaryMoveset(this.temporaryMoveset);
        }
        if (this.participant.bc.oldGen && this.usingZ) {
            this.participant.usedZ = true;
            if (this.participant.getType() == ParticipantType.Player) {
                PlayerParticipant playerParticipant = (PlayerParticipant)this.participant;
                Pixelmon.network.sendTo((IMessage)new UseZMove(), playerParticipant.player);
            }
            this.zMove = null;
        }
    }

    public MoveResults[] useAttackOnly() {
        MoveResults saveResult = this.attack.moveResult;
        MoveResults[] resultsArray = new MoveResults[this.targets.size()];
        this.targetIndex = 0;
        while (this.targetIndex < this.targets.size()) {
            PixelmonWrapper target = this.targets.get(this.targetIndex);
            resultsArray[this.targetIndex] = new MoveResults(target, 0, this.priority, AttackResult.proceed);
            this.attack.saveAttack();
            this.attack.use(this, target, resultsArray[this.targetIndex]);
            this.attack.restoreAttack();
            ++this.targetIndex;
        }
        this.attack.moveResult = saveResult;
        return resultsArray;
    }

    public void useItem() {
        UseBattleItemEvent event;
        PixelmonItem item = null;
        EntityPlayerMP user = null;
        ItemStack usedStack = null;
        int additionalInfo = 0;
        PlayerParticipant playerPart = (PlayerParticipant)this.participant;
        user = playerPart.player;
        PlayerPartyStorage party = playerPart.getStorage();
        if (party == null) {
            return;
        }
        PixelmonWrapper target = this;
        if (this.willUseItemInStackInfo == -1) {
            target = this.getParticipant().getPokemonFromParty(this.willUseItemPokemon);
        }
        usedStack = this.willUseItemInStack;
        additionalInfo = this.willUseItemInStackInfo;
        this.willUseItemInStack = null;
        this.willUseItemInStackInfo = 0;
        item = (PixelmonItem)usedStack.func_77973_b();
        boolean isPokeBall = item instanceof ItemPokeball;
        if (isPokeBall && this.bc.getOpponentPokemon(this.participant).size() >= 1) {
            for (PixelmonWrapper opponent : this.bc.getOpponentPokemon(this.participant)) {
                if (!opponent.isAlive()) continue;
                target = opponent;
                break;
            }
        }
        if (Pixelmon.EVENT_BUS.post((Event)(event = new UseBattleItemEvent(this, target, usedStack, additionalInfo)))) {
            this.bc.getPlayers().forEach(pp -> {
                pp.wait = false;
            });
            return;
        }
        item = (PixelmonItem)event.stack.func_77973_b();
        additionalInfo = event.additionalInfo;
        if (target != null) {
            this.bc.battleLog.addEvent(new BagItemAction(this.bc.battleTurn, this.bc.getPositionOfPokemon(this), this, target.getPokemonName(), item));
        }
        if (isPokeBall) {
            this.bc.sendToAll("pixelmon.pokeballs.throw", this.participant.getDisplayName(), item.getLocalizedName());
        } else {
            this.bc.sendToAll("pixelmon.items.useitem", this.participant.getDisplayName(), item.getLocalizedName());
        }
        if (!isPokeBall && this.hasStatus(StatusType.Embargo)) {
            this.bc.sendToAll("pixelmon.status.embargo", this.getNickname());
        } else if (item.useFromBag(this, target, additionalInfo)) {
            user.field_71071_by.func_174925_a((Item)item, 0, 1, null);
            Pixelmon.network.sendTo((IMessage)new UseItem(item), user);
        }
    }

    public void useTempAttack(Attack tempAttack) {
        this.useTempAttack(tempAttack, this.getTargets(tempAttack), false);
    }

    public void useTempAttack(Attack tempAttack, PixelmonWrapper target) {
        this.useTempAttack(tempAttack, Lists.newArrayList((Object[])new PixelmonWrapper[]{target}));
    }

    public void useTempAttack(Attack tempAttack, List<PixelmonWrapper> targets) {
        this.useTempAttack(tempAttack, targets, false);
    }

    public void useTempAttack(Attack tempAttack, List<PixelmonWrapper> targets, boolean affectPP) {
        this.targets = targets;
        Attack saveAttack = this.attack;
        this.attack = tempAttack;
        if (this.usingZ) {
            this.ignoringZCrystal = true;
        }
        if (!this.hasStatus(StatusType.Flinch) || this.getStatus(StatusType.Flinch).canAttackThisTurn(this, tempAttack)) {
            this.useAttack(affectPP);
            for (EffectBase effect : this.attack.getMove().effects) {
                if (!(effect instanceof MultiTurnSpecialAttackBase)) continue;
                return;
            }
        }
        this.ignoringZCrystal = false;
        this.attack = saveAttack;
    }

    public void turnTick() {
        boolean resetProtect;
        boolean isActive;
        if (this.bc == null) {
            this.bc = this.participant.bc;
        }
        this.returnToBasePos();
        boolean bl = isActive = this.isAlive() && this.bc != null && !this.bc.battleEnded;
        if (isActive) {
            this.getBattleAbility().applyRepeatedEffect(this);
        }
        Moveset moveset = this.getMoveset();
        for (int i = 0; i < moveset.size(); ++i) {
            moveset.get(i).setDisabled(false, this);
        }
        this.checkSkyBattleDisable();
        ItemHeld usableItem = this.getUsableHeldItem();
        if (isActive && this.isAlive()) {
            usableItem.applyRepeatedEffect(this);
        }
        for (int i = 0; i < this.getStatusSize(); ++i) {
            StatusBase s = this.getStatus(i);
            try {
                if (this.bc == null || this.bc.battleEnded || !this.isAlive() && !s.isTeamStatus()) continue;
                int beforeSize = this.getStatusSize();
                s.applyRepeatedEffect(this);
                if (beforeSize <= this.getStatusSize()) continue;
                --i;
                continue;
            }
            catch (Exception e) {
                this.bc.battleLog.onCrash(e, "Error calculating applyRepeatedEffect() for " + s.type.toString());
            }
        }
        if (isActive && this.isAlive()) {
            usableItem.applyRepeatedEffectAfterStatus(this);
        }
        this.damageTakenThisTurn = 0;
        boolean bl2 = resetProtect = this.attack == null;
        if (!resetProtect) {
            resetProtect = true;
            for (EffectBase e : this.attack.getMove().effects) {
                if (!(e instanceof ProtectVariation)) continue;
                resetProtect = false;
                break;
            }
        }
        if (resetProtect) {
            this.protectsInARow = 0;
        }
        this.switchedThisTurn = false;
        this.lastDirectDamage = -1;
        this.lastHP = -1;
    }

    public BattleParticipant getParticipant() {
        return this.participant;
    }

    public PixelmonWrapper doSwitch() {
        if (!this.bc.simulateMode) {
            this.isSwitching = false;
            this.canAttack = false;
            if (this.isFainted()) {
                this.resetBattleEvolution();
                if (this.isMega) {
                    this.isMega = false;
                }
                if (this.isDynamax > 0) {
                    this.dynamax(true, this.getHealthPercent());
                }
            }
        }
        ArrayList<StatusBase> statusCopy = new ArrayList<StatusBase>();
        boolean batonPassing = false;
        BattleStats tempStats = new BattleStats(this);
        boolean wasSimulateMode = this.bc.simulateMode;
        this.bc.simulateMode = false;
        tempStats.copyStats(this.getBattleStats());
        this.bc.simulateMode = wasSimulateMode;
        if (this.nextSwitchIsMove && this.attack != null && this.attack.isAttack("Baton Pass")) {
            batonPassing = true;
        }
        if (!this.bc.simulateMode) {
            for (int i = 0; i < this.getStatusSize(); ++i) {
                try {
                    StatusBase status = this.getStatus(i);
                    if (status.isTeamStatus() || batonPassing && BatonPass.isBatonPassable(status)) {
                        statusCopy.add(status);
                        continue;
                    }
                    if (StatusType.isPrimaryStatus(status.type)) continue;
                    this.removeStatus(status, false);
                    --i;
                    continue;
                }
                catch (Exception e2) {
                    this.bc.battleLog.onCrash(e2, "Error in doSwitch().");
                }
            }
        }
        UUID oldUUID = this.getPokemonUUID();
        if (!this.bc.simulateMode) {
            this.update(EnumUpdateType.Status);
        }
        if (this.newPokemonUUID == null) {
            return null;
        }
        PixelmonWrapper newPokemon = this.participant.switchPokemon(this, this.newPokemonUUID);
        this.newPokemonUUID = null;
        if (newPokemon.entity != null) {
            newPokemon.entity.func_70606_j(newPokemon.getHealth());
            newPokemon.entity.battleController = this.bc;
        }
        newPokemon.battlePosition = this.battlePosition;
        newPokemon.switchedThisTurn = true;
        if (!this.bc.simulateMode) {
            newPokemon.isDynamax = 0;
            newPokemon.dynamaxTurns = 0;
            newPokemon.dynamaxAnimationTicks = 0;
        }
        if (newPokemon.getPokemonUUID().equals(this.participant.evolution)) {
            ItemMegaStone megaStone = newPokemon.getHeldItem() instanceof ItemMegaStone ? (ItemMegaStone)newPokemon.getHeldItem() : null;
            newPokemon.isMega = true;
            int form = megaStone == null ? 1 : megaStone.getForm(newPokemon.getForm());
            newPokemon.setForm(form);
            if (newPokemon.entity != null) {
                newPokemon.tempAbility = null;
            }
        }
        if (!this.bc.simulateMode) {
            this.bc.sendSwitchPacket(oldUUID, newPokemon);
        }
        if (batonPassing) {
            this.bc.simulateMode = false;
            newPokemon.getBattleStats().copyStats(tempStats);
            this.bc.simulateMode = wasSimulateMode;
        }
        if (this.attack != null && this.attack.moveResult != null && !this.bc.simulateMode && (this.attack.moveResult.result == AttackResult.succeeded || this.attack.moveResult.result == AttackResult.proceed) && this.usingZ && this.attack.isAttack("Memento", "Parting Shot")) {
            newPokemon.healByPercent(100.0f);
        }
        if (!statusCopy.isEmpty()) {
            for (StatusBase e : statusCopy) {
                newPokemon.addStatus(e, newPokemon);
            }
            ArrayList<StatusBase> entryHazards = new ArrayList<StatusBase>();
            for (StatusBase e : statusCopy) {
                if (!(e instanceof EntryHazard)) {
                    e.applyEffectOnSwitch(newPokemon);
                    continue;
                }
                entryHazards.add(e);
            }
            for (StatusBase e : entryHazards) {
                e.applyEffectOnSwitch(newPokemon);
            }
        }
        for (GlobalStatusBase status : this.bc.globalStatusController.getGlobalStatuses()) {
            status.applyEffectOnSwitch(newPokemon);
        }
        if (!this.bc.simulateMode) {
            this.bc.getOpponentPokemon(this.participant).stream().filter(pw -> pw.targets.contains(this)).forEach(pw -> {
                pw.targets.remove(this);
                pw.targets.add(newPokemon);
            });
            this.bc.getTeamPokemon(this.participant).stream().filter(pw -> pw != this).filter(pw -> pw.targets.contains(this)).forEach(pw -> {
                pw.targets.remove(this);
                pw.targets.add(newPokemon);
            });
            newPokemon.addAttackers();
            this.bc.participants.stream().filter(p2 -> p2.team != this.participant.team).forEach(p2 -> p2.updateOtherPokemon());
        }
        return newPokemon;
    }

    public void beforeSwitch() {
        if (!this.bc.simulateMode) {
            this.getBattleStats().clearBattleStats();
            if (this.isAlive()) {
                this.getBattleAbility().applySwitchOutEffect(this);
            }
            for (int i = 0; i < this.getStatusSize(); ++i) {
                StatusBase status = this.getStatus(i);
                if (!this.isAlive() && !status.isTeamStatus()) continue;
                status.applySwitchOutEffect(this);
            }
            this.getUsableHeldItem().applySwitchOutEffect(this);
            this.resetOnSwitch();
        }
    }

    public void afterSwitch() {
        if (!this.bc.simulateMode) {
            this.checkPrimalReversion();
            this.getBattleAbility().applySwitchInEffect(this);
            this.getUsableHeldItem().applySwitchInEffect(this);
            if (this.participant.getType() == ParticipantType.Player && this.getSpecies() == EnumSpecies.Burmy) {
                this.changeBurmy = true;
            }
            this.checkSkyBattleDisable();
        }
    }

    private void checkPrimalReversion() {
        if ((this.getSpecies() == EnumSpecies.Kyogre && this.getHeldItem() == PixelmonItemsHeld.blueOrb || this.getSpecies() == EnumSpecies.Groudon && this.getHeldItem() == PixelmonItemsHeld.redOrb) && this.getForm() != EnumPrimal.PRIMAL.getForm()) {
            this.setForm(EnumPrimal.PRIMAL);
            this.bc.sendToAll("pixelmon.battletext.primalreversion", this.getNickname());
        }
    }

    private void checkSkyBattleDisable() {
        for (Attack move : this.getMoveset()) {
            if (move == null || move.checkSkyBattle(this.bc)) continue;
            move.setDisabled(true, this);
        }
    }

    public void takeTurn() {
        if (this.isSwitching) {
            this.bc.battleLog.addEvent(new SwitchAction(this.bc.battleTurn, this.bc.getPositionOfPokemon(this), this, this.newPokemonUUID));
            this.doSwitch();
        } else if (this.willUseItemInStack != null) {
            this.useItem();
        } else {
            this.canAttack = this.getBattleAbility().canAttackThisTurn(this, this.attack);
            if (this.canAttack) {
                for (StatusBase statusBase : new ArrayList<StatusBase>(this.status)) {
                    try {
                        if (!(statusBase instanceof StatusPersist) || statusBase.canAttackThisTurn(this, this.attack)) continue;
                        this.canAttack = false;
                        this.bc.battleLog.addEvent(new AttackAction(this.bc.battleTurn, this.bc.getPositionOfPokemon(this), this, 0, new MoveResults[]{new MoveResults(null, 0, AttackResult.unable)}));
                        break;
                    }
                    catch (Exception exc) {
                        this.bc.battleLog.onCrash(exc, "Error calculating canAttackThisTurn for " + statusBase.type.toString());
                    }
                }
            }
            if (this.canAttack) {
                for (StatusBase statusBase : new ArrayList<StatusBase>(this.status)) {
                    try {
                        if (statusBase instanceof StatusPersist || statusBase.canAttackThisTurn(this, this.attack)) continue;
                        this.canAttack = false;
                        this.bc.battleLog.addEvent(new AttackAction(this.bc.battleTurn, this.bc.getPositionOfPokemon(this), this, 0, new MoveResults[]{new MoveResults(null, 0, AttackResult.unable)}));
                        break;
                    }
                    catch (Exception exc) {
                        this.bc.battleLog.onCrash(exc, "Error calculating canAttackThisTurn for " + statusBase.type.toString());
                    }
                }
            }
            if (this.canAttack) {
                this.participant.bc.clearHurtTimer();
                this.getUsableHeldItem().onAttackUsed(this, this.attack);
                for (int i = 0; i < this.status.size(); ++i) {
                    StatusBase statusBase = this.status.get(i);
                    int initialSize = this.status.size();
                    statusBase.onAttackUsed(this, this.attack);
                    if (initialSize <= this.status.size()) continue;
                    --i;
                }
                if (this.attack != null) {
                    if (this.usingZ && this.attack.getAttackCategory() == AttackCategory.STATUS && this.attack.getMove().getZMove(this.pokemon, false) != null) {
                        for (EffectBase effectBase : this.attack.getMove().getZMove((Pokemon)this.pokemon, (boolean)false).effects) {
                            try {
                                if (effectBase instanceof StatsEffect) {
                                    ((StatsEffect)effectBase).applyStatEffect(this, this, this.attack.getMove());
                                    continue;
                                }
                                if (effectBase instanceof SpecialAttackBase) {
                                    if (effectBase.applyEffectStart(this, this) != AttackResult.proceed) continue;
                                    ((SpecialAttackBase)effectBase).applyEffectDuring(this, this);
                                    continue;
                                }
                                if (effectBase instanceof StatusBase) {
                                    effectBase.applyEffect(this, this);
                                    continue;
                                }
                                if (!(effectBase instanceof CriticalHit) || this.getBattleStats().increaseCritStage(2)) continue;
                                this.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (this.isDynamax == 1) {
                        this.attack = MaxMoveConverter.getMaxMoveFromAttack(this.attack);
                    } else if (this.isDynamax == 2) {
                        this.attack = MaxMoveConverter.getGMaxMoveFromAttack(this.attack);
                    }
                }
                if (this.attack != null) {
                    this.useAttack();
                }
            } else if (this.attack != null && this.hasStatus(StatusType.MultiTurn)) {
                for (EffectBase effectBase : this.attack.getMove().effects) {
                    if (!(effectBase instanceof MultiTurnSpecialAttackBase)) continue;
                    ((MultiTurnSpecialAttackBase)effectBase).removeEffect(this, this);
                }
            }
            for (StatusBase statusBase : new ArrayList<StatusBase>(this.status)) {
                statusBase.onEndOfTurn(this);
            }
        }
    }

    public boolean dynamax(boolean revert, float healthPercentage) {
        int currentHP = this.getHealth();
        if (revert) {
            if (this.isDynamax > 0) {
                this.isDynamax = -1;
                this.dynamaxAnimationTicks = -60;
                this.updateHPIncrease();
                int newHP = (int)Math.ceil((double)this.getMaxHealth() * ((double)healthPercentage / 100.0));
                this.setHealth(newHP);
                this.updateBattleDamage(currentHP - newHP);
                if (this.participant.getType() == ParticipantType.Player) {
                    PlayerParticipant player = (PlayerParticipant)this.participant;
                    Pixelmon.network.sendTo((IMessage)new Dynamax(UUID.randomUUID(), false), player.player);
                }
                if (!this.bc.battleEnded) {
                    String nickname = this.getNickname();
                    this.bc.sendToAll("pixelmon.battletext.dynamaxlost", nickname, this.participant.getDisplayName());
                }
            }
        } else if (!this.bc.battleEnded) {
            this.dynamaxTurns = 3;
            this.dynamaxAnimationTicks = 60;
            this.participant.dynamax = this.getPokemonUUID();
            this.updateHPIncrease();
            int newHP = (int)Math.ceil((double)this.getMaxHealth() * ((double)healthPercentage / 100.0));
            this.setHealth(newHP);
            this.updateBattleDamage(currentHP - newHP);
            String nickname = this.getNickname();
            if (this.participant.getType() == ParticipantType.Player) {
                PlayerParticipant player = (PlayerParticipant)this.participant;
                Pixelmon.network.sendTo((IMessage)new Dynamax(this.getPokemonUUID(), this.isDynamax == 2), player.player);
            }
            this.bc.sendToAll("pixelmon.battletext.dynamax", nickname, this.participant.getDisplayName());
        }
        return false;
    }

    public boolean megaEvolve() {
        if (this.bc.simulateMode) {
            return false;
        }
        this.willEvolve = false;
        if (this.bc.oldGen) {
            if (this.canUltraBurst() && this.participant.ultraBurst == null && this.canUltraBurst()) {
                if (Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.BattleEvolve(this, null, true))) {
                    return false;
                }
                this.participant.ultraBurst = this.getPokemonUUID();
                this.bc.sendToAll("pixelmon.battletext.necrozmaultrareact", this.participant.getDisplayName());
                this.pokemon.getPersistentData().func_74768_a("SrcForm", this.pokemon.getForm());
                this.evolution = new EvolutionQuery(this.entity, EnumNecrozma.ULTRA.getForm());
                this.tempAbility = null;
                this.setForm(EnumNecrozma.ULTRA);
                if (this.participant.getType() == ParticipantType.Player) {
                    PlayerParticipant player = (PlayerParticipant)this.participant;
                    Pixelmon.network.sendTo((IMessage)new MegaEvolve(this.getPokemonUUID(), true), player.player);
                }
                this.bc.updateFormChange(this.entity);
                return true;
            }
            boolean isRayquaza = this.entity.isPokemon(EnumSpecies.Rayquaza);
            if (this.canMegaEvolve() && this.participant.evolution == null && (this.participant.canMegaEvolve() || isRayquaza)) {
                ItemMegaStone megaStone;
                ItemMegaStone itemMegaStone = megaStone = this.getHeldItem() instanceof ItemMegaStone ? (ItemMegaStone)this.getHeldItem() : null;
                if (Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.BattleEvolve(this, megaStone, false))) {
                    return false;
                }
                this.isMega = true;
                this.participant.evolution = this.getPokemonUUID();
                String nickname = this.getNickname();
                if (isRayquaza) {
                    this.bc.sendToAll("pixelmon.battletext.rayquazamegareact", this.participant.getDisplayName());
                } else {
                    this.bc.sendToAll("pixelmon.battletext.megareact", nickname, this.getHeldItem().getLocalizedName(), this.participant.getDisplayName());
                }
                int form = megaStone == null ? 1 : megaStone.getForm(this.getForm());
                this.evolution = new EvolutionQuery(this.entity, form);
                this.tempAbility = null;
                this.setForm(form);
                if (this.participant.getType() == ParticipantType.Player) {
                    PlayerParticipant player = (PlayerParticipant)this.participant;
                    Pixelmon.network.sendTo((IMessage)new MegaEvolve(this.getPokemonUUID(), false), player.player);
                }
                this.bc.updateFormChange(this.entity);
                return true;
            }
        } else if (this.participant.dynamax == null && this.participant.canDynamax()) {
            boolean gigantamax = this.canGigantamax();
            boolean dynamax = this.canDynamax();
            if (gigantamax || dynamax) {
                if (Pixelmon.EVENT_BUS.post((Event)new DynamaxEvent.BattleEvolve(this, gigantamax))) {
                    return false;
                }
                float healthPercentage = this.getHealthPercent();
                this.isDynamax = gigantamax ? 2 : 1;
                this.dynamax(false, healthPercentage);
                return true;
            }
        }
        return false;
    }

    public void setAttack(int buttonId, ArrayList<PixelmonWrapper> targets, boolean megaEvolving) {
        Attack attack = this.getMoveset().get(buttonId >= 4 ? buttonId - 4 : buttonId);
        this.usingZ = buttonId >= 4 && !this.participant.usedZ && attack.getMove().hasZMove(this.pokemon) ? this.participant.bc.oldGen : false;
        this.setAttack(attack, targets, megaEvolving);
    }

    public void setAttack(Attack attack, ArrayList<PixelmonWrapper> targets, boolean megaEvolving) {
        this.attack = attack;
        this.targets = targets;
        if (!this.bc.simulateMode) {
            this.wait = false;
            this.willEvolve = megaEvolving;
        }
    }

    public boolean isFainted() {
        return this.getHealth() <= 0;
    }

    public boolean isAlive() {
        return !this.isFainted();
    }

    public void setStruggle(ArrayList<PixelmonWrapper> targets) {
        this.setAttack(new Attack("Struggle"), targets, false);
    }

    public void returnToBasePos() {
        if (this.basePos != null && this.entity != null) {
            this.entity.func_70012_b(this.basePos[0], this.basePos[1], this.basePos[2], this.participant.team == 0 ? 270.0f : 90.0f, 0.0f);
            this.entity.field_70126_B = this.entity.field_70177_z;
        }
    }

    public void setBasePosition(double[] ds) {
        if (this.entity != null) {
            this.basePos = ds;
            this.entity.func_70012_b(ds[0], ds[1], ds[2], 0.0f, 0.0f);
        }
    }

    public void setTempType(EnumType newType) {
        this.setTempType(newType.makeTypeList());
    }

    public void setTempType(List<EnumType> newType) {
        if (!this.bc.simulateMode) {
            if (this.initialType == null) {
                this.initialType = this.type;
            }
            this.type = newType;
        }
    }

    public void setTempAbility(AbilityBase newAbility) {
        this.setTempAbility(newAbility, false);
    }

    public void setTempAbility(AbilityBase newAbility, boolean formChange) {
        if (!this.bc.simulateMode) {
            this.getBattleAbility().onAbilityLost(this);
            if (newAbility.needNewInstance()) {
                newAbility = newAbility.getNewInstance();
            }
            this.tempAbility = newAbility;
            AbilityBase pokemonAbility = this.getBattleAbility();
            if (formChange || !(pokemonAbility instanceof Trace) && !(pokemonAbility instanceof Imposter)) {
                pokemonAbility.applySwitchInEffect(this);
            }
        }
    }

    public void resetOnSwitch() {
        int i;
        if (this.bc != null && this.bc.simulateMode) {
            return;
        }
        this.lastAttack = null;
        this.lastTargets = null;
        this.protectsInARow = 0;
        if (this.initialType != null) {
            this.type = this.initialType;
            this.initialType = null;
        }
        this.tempAbility = null;
        Moveset moveset = this.getMoveset();
        for (i = 0; i < moveset.size(); ++i) {
            moveset.get(i).setDisabled(false, this, true);
        }
        this.usedMoves.clear();
        this.escapeAttempts = 0;
        this.damageTakenThisTurn = 0;
        this.nextSwitchIsMove = false;
        this.wait = false;
        this.isSwitching = false;
        this.choiceLocked = null;
        this.inMultipleHit = false;
        this.inParentalBond = false;
        for (i = 0; i < this.status.size(); ++i) {
            if (this.status.get((int)i).type.isPrimaryStatus()) continue;
            this.status.remove(i--);
        }
        this.battleStats.clearBattleStats();
    }

    public float getWeight(boolean ignoreAbility) {
        float weight = this.getBaseStats().weight.floatValue();
        if (!ignoreAbility) {
            weight = this.getBattleAbility().modifyWeight(weight);
        }
        weight = this.getUsableHeldItem().modifyWeight(weight);
        for (StatusBase status : this.getStatuses()) {
            weight = status.modifyWeight(weight);
        }
        return weight;
    }

    public void consumeItem() {
        ItemHeld item = this.getHeldItem();
        this.setConsumedItem(item);
        this.bc.getActiveUnfaintedPokemon().forEach(pw -> pw.getBattleAbility().onItemConsumed((PixelmonWrapper)pw, this, item));
        this.removeHeldItem();
    }

    public void setConsumedItem(ItemHeld heldItem) {
        if (!this.bc.simulateMode) {
            this.consumedHeldItem = heldItem == null ? NoItem.noItem : heldItem;
        }
    }

    public ItemHeld getConsumedItem() {
        return this.consumedHeldItem;
    }

    public void setNewHeldItem(ItemHeld heldItem) {
        this.setHeldItem(heldItem);
        this.getUsableHeldItem().applySwitchInEffect(this);
    }

    public boolean isGrounded() {
        return this.hasStatus(StatusType.SmackedDown) || this.bc.globalStatusController.hasStatus(StatusType.Gravity) || this.getUsableHeldItem().getHeldItemType() == EnumHeldItems.ironBall;
    }

    public boolean isAirborne() {
        return !this.isGrounded() && (this.hasType(EnumType.Flying) || this.getBattleAbility() instanceof Levitate || this.hasStatus(StatusType.MagnetRise, StatusType.Telekinesis) || this.getUsableHeldItem().getHeldItemType() == EnumHeldItems.airBalloon);
    }

    public boolean addTeamStatus(StatusBase status, PixelmonWrapper cause) {
        boolean succeeded = false;
        for (PixelmonWrapper pw : this.getTeamPokemon()) {
            succeeded = pw.addStatus(status.copy(), cause) || succeeded;
        }
        return succeeded;
    }

    public boolean removeTeamStatus(StatusBase status) {
        return this.removeTeamStatus(status.type);
    }

    public boolean removeTeamStatus(StatusType ... statuses) {
        boolean hadStatus = false;
        for (StatusType status : statuses) {
            for (PixelmonWrapper pw : this.getTeamPokemon()) {
                hadStatus = pw.removeStatus(status) || hadStatus;
            }
        }
        return hadStatus;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon() {
        return this.bc.getTeamPokemon(this);
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonExcludeSelf() {
        return this.bc.getTeamPokemonExcludeSelf(this);
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon() {
        return this.bc.getOpponentPokemon(this);
    }

    public boolean isAlly(PixelmonWrapper pokemon) {
        return this.getTeamPokemon().contains(pokemon);
    }

    public boolean isOpponent(PixelmonWrapper pokemon) {
        return this.getOpponentPokemon().contains(pokemon);
    }

    public int getControlledIndex() {
        return this.participant.controlledPokemon.indexOf(this);
    }

    public BattleAIBase getBattleAI() {
        return this.getParticipant().getBattleAI();
    }

    public void setUpSwitchMove() {
        this.wait = true;
        this.nextSwitchIsMove = true;
        this.canAttack = false;
        this.bc.removeFromTurnList(this);
    }

    public void forceRandomSwitch(UUID switchPokemon) {
        this.setUpSwitchMove();
        this.bc.switchPokemon(this.getPokemonUUID(), switchPokemon, true);
    }

    public boolean isImmuneToPowder() {
        if (this.hasType(EnumType.Grass) || this.getBattleAbility() instanceof Overcoat) {
            return true;
        }
        ItemHeld item = this.getHeldItem();
        return item.getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    public String toString() {
        return this.getPokemonName();
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof PixelmonWrapper) {
            PixelmonWrapper otherPW = (PixelmonWrapper)other;
            return this.getPokemonUUID().equals(otherPW.getPokemonUUID());
        }
        return false;
    }

    public boolean hasMoved() {
        return this.bc.turnList.indexOf(this) <= this.bc.turn;
    }

    public boolean isFirstTurn() {
        return this.bc.battleTurn == 0 || this.bc.battleLog.getActionForPokemon(this.bc.battleTurn - 1, this) == null || this.bc.battleLog.getActionForPokemon(this.bc.battleTurn - 1, this) instanceof SwitchAction;
    }

    public boolean isSameTeam(PixelmonWrapper other) {
        return this.getParticipant().team == other.getParticipant().team;
    }

    public Moveset getMoveset() {
        return this.temporaryMoveset == null ? this.pokemon.getMoveset() : this.temporaryMoveset;
    }

    public void setTemporaryMoveset(Moveset moveset) {
        this.temporaryMoveset = moveset;
        if (this.participant instanceof PlayerParticipant) {
            EntityPlayerMP player = ((PlayerParticipant)this.participant).player;
            Pixelmon.network.sendTo((IMessage)new UpdateMoveset(this), player);
        }
    }

    public boolean removeStatus(StatusType s) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != s) continue;
            this.removeStatus(base);
            return true;
        }
        return false;
    }

    public boolean removeStatuses(StatusType ... statuses) {
        return this.removeStatuses(true, statuses);
    }

    public boolean removeStatuses(boolean showMessage, StatusType ... statuses) {
        boolean wasRemoved = false;
        block0: for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            for (StatusType type : statuses) {
                if (base.type != type) continue;
                int beforeSize = this.status.size();
                this.removeStatus(base, showMessage);
                if (this.status.size() < beforeSize) {
                    --i;
                }
                wasRemoved = true;
                continue block0;
            }
        }
        return wasRemoved;
    }

    public void removeStatus(int i) {
        this.removeStatus(this.status.get(i));
    }

    public StatusBase getStatus(StatusType type) {
        for (StatusBase base : this.status) {
            if (base.type != type) continue;
            return base;
        }
        return null;
    }

    public boolean hasStatus(StatusType ... statuses) {
        for (StatusBase base : this.status) {
            for (StatusType current : statuses) {
                if (base.type != current) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPrimaryStatus() {
        return this.hasStatus(StatusType.Poison, StatusType.Burn, StatusType.PoisonBadly, StatusType.Freeze, StatusType.Sleep, StatusType.Paralysis);
    }

    public int countStatuses(StatusType ... statuses) {
        int count = 0;
        for (StatusBase base : this.status) {
            for (StatusType current : statuses) {
                if (base.type != current) continue;
                ++count;
            }
        }
        return count;
    }

    public int getStatusSize() {
        return this.status.size();
    }

    public List<StatusBase> getStatuses() {
        return this.status;
    }

    public StatusBase getStatus(int i) {
        return this.status.get(i);
    }

    public int getStatusIndex(StatusType findStatus) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != findStatus) continue;
            return i;
        }
        return -1;
    }

    public StatusPersist getPrimaryStatus() {
        for (StatusBase s : this.status) {
            if (!(s instanceof StatusPersist)) continue;
            return (StatusPersist)s;
        }
        return NoStatus.noStatus;
    }

    public void setStatus(int i, StatusBase newStatus) {
        this.status.set(i, newStatus);
    }

    public void clearStatus() {
        if (this.bc.simulateMode) {
            return;
        }
        if (this.hasPrimaryStatus() && this.entity != null) {
            this.sendStatusPacket(-1);
        }
        this.status.clear();
    }

    public boolean addStatus(StatusBase e, PixelmonWrapper opponent) {
        return this.addStatus(e, opponent, null);
    }

    public boolean addStatus(StatusBase e, PixelmonWrapper opponent, TextComponentTranslation message) {
        if (this.cannotHaveStatus(e, opponent)) {
            return false;
        }
        e.applyBeforeEffect(this, opponent);
        if (!this.bc.simulateMode) {
            this.status.add(e);
        }
        if (this.bc.sendMessages) {
            if (message != null) {
                this.bc.sendToAll(message);
            }
            if (!this.bc.simulateMode && e.type.isPrimaryStatus()) {
                this.sendStatusPacket(e.type.ordinal());
            }
            this.getBattleAbility().onStatusAdded(e, this, opponent);
            this.getUsableHeldItem().onStatusAdded(this, opponent, e);
            if (!this.bc.simulateMode) {
                if (this.getPlayerOwner() != null && e.type.isPrimaryStatus()) {
                    this.update(EnumUpdateType.Status);
                }
                this.bc.updatePokemonHealth();
            }
        }
        return true;
    }

    public void sendStatusPacket(int statusID) {
        if (this.bc != null && !this.bc.simulateMode) {
            this.bc.participants.stream().filter(p -> p.getType() == ParticipantType.Player).forEach(p -> Pixelmon.network.sendTo((IMessage)new StatusPacket(this.getPokemonUUID(), statusID), ((PlayerParticipant)p).player));
            this.bc.spectators.forEach(spectator -> spectator.sendMessage(new StatusPacket(this.getPokemonUUID(), statusID)));
        }
    }

    public void removeStatus(StatusBase e) {
        this.removeStatus(e, true);
    }

    public void removeStatus(StatusBase e, boolean showMessage) {
        if (this.bc.simulateMode) {
            return;
        }
        if (this.status.remove(e) && showMessage) {
            String message;
            String string = message = this.eatingBerry ? e.getCureMessageItem() : e.getCureMessage();
            if (!message.isEmpty()) {
                String nickname = this.getNickname();
                if (this.eatingBerry) {
                    this.bc.sendToAll(message, nickname, this.getHeldItem().getLocalizedName());
                } else {
                    this.bc.sendToAll(message, nickname);
                }
            }
        }
        if (e.type.isPrimaryStatus()) {
            this.sendStatusPacket(-1);
            this.update(EnumUpdateType.Status);
        }
        this.bc.updatePokemonHealth();
    }

    public StatusBase removePrimaryStatus() {
        return this.removePrimaryStatus(true);
    }

    public StatusBase removePrimaryStatus(boolean showMessage) {
        try {
            for (int i = 0; i < this.status.size(); ++i) {
                StatusBase base = this.status.get(i);
                if (!StatusType.isPrimaryStatus(base.type)) continue;
                this.removeStatus(base, showMessage);
                return base;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean cannotHaveStatus(StatusBase t, PixelmonWrapper opponent) {
        return this.cannotHaveStatus(t, opponent, false);
    }

    public boolean cannotHaveStatus(StatusBase t, PixelmonWrapper opponent, boolean ignorePrimaryOverlap) {
        StatusType type = t.type;
        if (StatusType.isPrimaryStatus(type) && this.hasPrimaryStatus() && !ignorePrimaryOverlap) {
            return true;
        }
        if (t.isImmune(this) && t instanceof Poison && opponent.getBattleAbility().getClass() != Corrosion.class || this.isFainted() && !t.isTeamStatus() || this.hasStatus(type)) {
            return true;
        }
        for (StatusBase statusBase : this.status) {
            try {
                if (!statusBase.stopsStatusChange(type, this, opponent)) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Problem with cannotHaveStatus for StatusType " + type.name());
                e.printStackTrace();
            }
        }
        for (GlobalStatusBase globalStatusBase : this.bc.globalStatusController.getGlobalStatuses()) {
            try {
                if (!globalStatusBase.stopsStatusChange(type, this, opponent)) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Problem with cannotHaveStatus for StatusType " + type.name());
                e.printStackTrace();
            }
        }
        for (PixelmonWrapper pixelmonWrapper : this.bc.getTeamPokemon(this)) {
            if (pixelmonWrapper.getBattleAbility(opponent).allowsStatusTeammate(type, pixelmonWrapper, this, opponent)) continue;
            return true;
        }
        return !this.getBattleAbility().allowsStatus(type, this, opponent);
    }

    public List<EntryHazard> getEntryHazards() {
        ArrayList<EntryHazard> hazards = new ArrayList<EntryHazard>();
        for (StatusBase s : this.status) {
            if (!(s instanceof EntryHazard)) continue;
            hazards.add((EntryHazard)s);
        }
        return hazards;
    }

    private void updateBattleDamage(float damage) {
        this.updateBattleDamage((int)damage);
    }

    private void updateBattleDamage(int damage) {
        NPCTrainer trainer;
        if (this.entity == null) {
            return;
        }
        this.bc.updatePokemonHealth();
        this.bc.sendDamagePacket(this, damage);
        this.update(EnumUpdateType.HP);
        if (this.isFainted()) {
            int turnIndex = this.bc.turnList.indexOf(this);
            if (turnIndex > this.bc.turn) {
                this.bc.turnList.remove(turnIndex);
            }
            if (this.removePrimaryStatus(false) != null) {
                this.sendStatusPacket(-1);
                this.update(EnumUpdateType.Status);
            }
        }
        if ((trainer = this.entity.getTrainer()) != null) {
            // empty if block
        }
    }

    public List<EnumType> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        List<EnumType> effectiveTypes = user.getBattleAbility().getEffectiveTypes(user, target);
        if (!effectiveTypes.equals(target.type)) {
            return effectiveTypes;
        }
        for (int i = 0; i < target.getStatusSize(); ++i) {
            effectiveTypes = target.getStatus(i).getEffectiveTypes(user, target);
            if (effectiveTypes.equals(target.type)) continue;
            return effectiveTypes;
        }
        effectiveTypes = target.getUsableHeldItem().getEffectiveTypes(user, target);
        for (GlobalStatusBase status : target.bc.globalStatusController.getGlobalStatuses()) {
            effectiveTypes = status.getEffectiveTypes(user, target);
        }
        return effectiveTypes;
    }

    /*
     * WARNING - void declaration
     */
    public float doBattleDamage(PixelmonWrapper source, float damage, DamageTypeEnum damageType) {
        void var10_22;
        this.lastHP = this.getHealth();
        AbilityBase thisAbility = this.getBattleAbility(source);
        ItemHeld thisHeldItem = this.getUsableHeldItem();
        if (source == null) {
            source = this;
        }
        if (this.isFainted()) {
            return -1.0f;
        }
        boolean isMultiHit = false;
        Substitute substitute = null;
        boolean hitSubstitute = false;
        if (source != this) {
            if (damageType == DamageTypeEnum.ATTACK || damageType == DamageTypeEnum.ATTACKFIXED) {
                substitute = (Substitute)this.getStatus(StatusType.Substitute);
                boolean bl = hitSubstitute = substitute != null && !substitute.ignoreSubstitute(source);
            }
            if (damageType == DamageTypeEnum.ATTACK) {
                Object allies;
                for (EffectBase effectBase : source.attack.getMove().effects) {
                    if (!(effectBase instanceof MultipleHit) && !(effectBase instanceof TripleKick) && !(effectBase instanceof BeatUp)) continue;
                    isMultiHit = true;
                    break;
                }
                if (!isMultiHit) {
                    source.attack.sendEffectiveChat(source, this);
                }
                if (((ArrayList)(allies = this.bc.getTeamPokemon(this.getParticipant()))).size() > 1) {
                    Iterator iterator = ((ArrayList)allies).iterator();
                    while (iterator.hasNext()) {
                        PixelmonWrapper ally = (PixelmonWrapper)iterator.next();
                        if (ally == this) continue;
                        damage = ally.getBattleAbility().modifyDamageTeammate((int)damage, source, this, source.attack);
                    }
                }
                damage = source.getBattleAbility().modifyDamageUser((int)damage, source, this, source.attack);
                if (!AbilityBase.ignoreAbility(source, this)) {
                    damage = thisAbility.modifyDamageTarget((int)damage, source, this, source.attack);
                    if (!hitSubstitute) {
                        damage = thisAbility.modifyDamageIncludeFixed((int)damage, source, this, source.attack);
                    }
                }
                if (!hitSubstitute) {
                    for (StatusBase status : this.getStatuses()) {
                        damage = status.modifyDamageIncludeFixed((int)damage, source, this, source.attack, damageType);
                    }
                    damage = (float)thisHeldItem.modifyDamageIncludeFixed(damage, source, this, source.attack);
                }
            } else if (damageType == DamageTypeEnum.ATTACKFIXED && !hitSubstitute) {
                for (StatusBase statusBase : this.getStatuses()) {
                    damage = statusBase.modifyDamageIncludeFixed((int)damage, source, this, source.attack, damageType);
                }
                damage = thisAbility.modifyDamageIncludeFixed((int)damage, source, this, source.attack);
                damage = (float)thisHeldItem.modifyDamageIncludeFixed(damage, source, this, source.attack);
            }
        }
        damage = (float)Math.floor(damage);
        if (hitSubstitute) {
            float damageResult = substitute.attackSubstitute(damage, this);
            source.attack.moveResult.damage = (int)damageResult;
            source.attack.moveResult.fullDamage = (int)damage;
            source.attack.moveResult.target = this;
            source.attack.moveResult.result = AttackResult.succeeded;
            source.getUsableHeldItem().postProcessAttackUser(source, this, source.attack, damageResult);
            if (!isMultiHit) {
                Attack.postProcessAttackAllHits(source, this, source.attack, damageResult, damageType, true);
            }
            for (EffectBase effect : source.attack.getMove().effects) {
                if (!(effect instanceof Recoil)) continue;
                ((Recoil)effect).applyRecoil(source, damageResult);
            }
            return damageResult;
        }
        if (source.attack != null && source.attack.getMove().hasEffect(FalseSwipe.class)) {
            damage = Math.min(damage, (float)(this.getHealth() - 1));
        }
        float damageResult = Math.min((float)this.getHealth(), damage);
        if (source != this && source.attack != null && source.attack.moveResult != null) {
            source.attack.moveResult.damage = (int)damageResult;
            source.attack.moveResult.fullDamage = (int)damage;
            source.attack.moveResult.target = this;
            source.attack.moveResult.result = AttackResult.hit;
        }
        if (!this.bc.simulateMode) {
            if (this.entity != null) {
                double d = this.entity.field_70159_w;
                double prevMotionY = this.entity.field_70181_x;
                double prevMotionZ = this.entity.field_70179_y;
                this.entity.func_70097_a(new BattleDamageSource("battle", source), 0.0f);
                this.entity.field_70159_w = d;
                this.entity.field_70181_x = prevMotionY;
                this.entity.field_70179_y = prevMotionZ;
            }
            this.setHealth(Math.max(this.getHealth() - (int)damageResult, 0));
            this.updateBattleDamage(damage);
            if (source.attack != null && !this.isSameTeam(source)) {
                this.lastDirectPosition = source.battlePosition;
                this.lastDirectDamage = (int)damageResult;
                this.lastDirectCategory = source.attack.getAttackCategory();
            }
        }
        boolean bl = false;
        while (var10_22 < this.getStatusSize()) {
            this.getStatus((int)var10_22).onDamageReceived(source, this, source.attack, (int)damageResult, damageType);
            ++var10_22;
        }
        this.getBattleAbility(source).onDamageReceived(source, this, source.attack, (int)damageResult, damageType);
        if (source != this && damageType.isDirect()) {
            if (source.attack.getMove().getMakesContact()) {
                Attack.applyContact(source, this);
            }
            source.getBattleAbility(source).tookDamageUser((int)damageResult, source, this, source.attack);
            thisAbility.tookDamageTarget((int)damageResult, source, this, source.attack);
            if (this.isFainted()) {
                ArrayList<PixelmonWrapper> arrayList = this.bc.getTeamPokemon(this);
                ArrayList<PixelmonWrapper> foes = this.bc.getOpponentPokemon(this);
                this.getBattleAbility(source).onSelfFaint(this, source);
                for (PixelmonWrapper pw : arrayList) {
                    if (pw == this) continue;
                    pw.getBattleAbility(source).onAllyFaint(pw, this, source);
                }
                for (PixelmonWrapper pw : foes) {
                    pw.getBattleAbility(source).onFoeFaint(pw, this, source);
                }
            }
            source.getUsableHeldItem().postProcessAttackUser(source, this, source.attack, damageResult);
            if (!isMultiHit) {
                Attack.postProcessAttackAllHits(source, this, source.attack, damageResult, damageType, false);
            }
            for (EffectBase effect : source.attack.getMove().effects) {
                if (!(effect instanceof Recoil)) continue;
                ((Recoil)effect).applyRecoil(source, damageResult);
            }
        }
        if (source.attack == null || !source.attack.canRemoveBerry()) {
            thisHeldItem.tookDamage(source, this, damageResult, damageType);
        }
        if (this.getHealth() <= 0) {
            String string = this.getNickname();
            this.bc.sendToAll("battlecontroller.hasfainted", string);
            if (this.participant.getType() == ParticipantType.WildPokemon) {
                this.entity.func_70097_a(new BattleDamageSource("battle", source), this.entity.func_110138_aP());
            } else {
                this.pokemon.decreaseFriendship(1);
                Pixelmon.EVENT_BUS.post((Event)new PixelmonFaintEvent(this.getPlayerOwner(), this.entity));
            }
            Pixelmon.EVENT_BUS.post((Event)new PixelmonKnockoutEvent(source, this));
        } else if (!this.bc.simulateMode) {
            this.damageTakenThisTurn = (int)((float)this.damageTakenThisTurn + damage);
        }
        return damageResult;
    }

    public AbilityBase getAbility() {
        return this.pokemon.getAbility();
    }

    public AbilityBase getBattleAbility() {
        return this.getBattleAbility(true, null);
    }

    public AbilityBase getBattleAbility(PixelmonWrapper moveUser) {
        return this.getBattleAbility(true, moveUser);
    }

    public AbilityBase getBattleAbility(boolean canIgnore) {
        return this.getBattleAbility(canIgnore, null);
    }

    public AbilityBase getBattleAbility(boolean canIgnore, PixelmonWrapper moveUser) {
        if (canIgnore && AbilityBase.ignoreAbility(moveUser, this)) {
            return ComingSoon.noAbility;
        }
        if (this.tempAbility != null) {
            return this.tempAbility;
        }
        return this.pokemon.getAbility();
    }

    public boolean hasHeldItem() {
        return this.pokemon.getHeldItemAsItemHeld() != NoItem.noItem;
    }

    public ItemHeld getHeldItem() {
        return this.pokemon.getHeldItemAsItemHeld();
    }

    public ItemHeld getUsableHeldItem() {
        if (ItemHeld.canUseItem(this)) {
            return this.getHeldItem();
        }
        return NoItem.noItem;
    }

    public void removeHeldItem() {
        this.setHeldItem(NoItem.noItem);
    }

    public void setHeldItem(ItemHeld newItem) {
        if (!this.bc.simulateMode) {
            this.pokemon.setHeldItem(newItem == null ? null : new ItemStack((Item)newItem));
            this.getBattleAbility().onItemChanged(this, this.pokemon.getHeldItemAsItemHeld());
        }
    }

    public void setHeldItem(ItemStack itemStack) {
        if (!this.bc.simulateMode) {
            this.pokemon.setHeldItem(itemStack);
            this.getBattleAbility().onItemChanged(this, this.pokemon.getHeldItemAsItemHeld());
        }
    }

    public boolean canMegaEvolve() {
        if (this.getSpecies() == EnumSpecies.Rayquaza) {
            return this.pokemon.getMoveset().hasAttack("Dragon Ascent");
        }
        return PixelmonWrapper.canMegaEvolve(this.getHeldItem(), this.pokemon.getSpecies(), this.pokemon.getForm());
    }

    public boolean canUltraBurst() {
        return PixelmonWrapper.canUltraBurst(this.getSpecies(), this.getHeldItem(), this.getForm());
    }

    public boolean canDynamax() {
        return PixelmonWrapper.canDynamax(this.getSpecies(), this.getForm());
    }

    public boolean canGigantamax() {
        return PixelmonWrapper.canGigantamax(this.getSpecies(), this.getForm());
    }

    public static boolean canMegaEvolve(ItemStack heldItem, EnumSpecies pokemon, int form) {
        return PixelmonWrapper.canMegaEvolve(ItemHeld.getItemHeld(heldItem), pokemon, form);
    }

    public static boolean canUseZMove(ItemStack heldItem) {
        return heldItem.func_77973_b() instanceof ItemZCrystal;
    }

    public static boolean canMegaEvolve(ItemHeld heldItem, EnumSpecies species, int form) {
        if ((form == 1 || form == 2) && species == EnumSpecies.Necrozma && heldItem == PixelmonItemsHeld.ultranecrozium_z) {
            return true;
        }
        return PixelmonWrapper.hasCompatibleMegaStone(heldItem, species, form);
    }

    public static boolean canUltraBurst(EnumSpecies species, ItemHeld heldItem, int form) {
        return species == EnumSpecies.Necrozma && (form == 1 || form == 2) && heldItem == PixelmonItemsHeld.ultranecrozium_z;
    }

    public static boolean canDynamax(EnumSpecies species, int form) {
        return true;
    }

    public static boolean canGigantamax(EnumSpecies species, int form) {
        return species.getDefaultForms().contains(EnumMega.Gigantamax) && form == EnumMega.Gigantamax.getForm();
    }

    public boolean hasCompatibleMegaStone() {
        return PixelmonWrapper.hasCompatibleMegaStone(this.getHeldItem(), this.getSpecies(), this.getForm());
    }

    public static boolean hasCompatibleMegaStone(ItemHeld heldItem, EnumSpecies pokemon, int form) {
        EnumMegaPokemon mega = EnumMegaPokemon.getMega(pokemon);
        if (mega != null && mega.getMegaEvoItems().length == 0) {
            return true;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.megaStone) {
            ItemMegaStone megaStone = (ItemMegaStone)heldItem;
            return megaStone.pokemon == pokemon && megaStone.isFormAllowed(form) && megaStone.getForm(form) != form;
        }
        return false;
    }

    public boolean isItemRemovable(PixelmonWrapper user) {
        if (user != this && this.getBattleAbility(user) instanceof StickyHold) {
            return false;
        }
        if (user.isWildPokemon()) {
            return false;
        }
        if (this.hasStatus(StatusType.Substitute)) {
            return false;
        }
        if (this.hasSpecialItem(user)) {
            return false;
        }
        ItemHeld heldItem = this.getHeldItem();
        if (heldItem.getHeldItemType() == EnumHeldItems.mail) {
            return false;
        }
        if (PixelmonWrapper.hasCompatibleMegaStone(heldItem, user.getSpecies(), user.getForm()) || this.hasCompatibleMegaStone()) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.megaStone && (this.isMega || user.isMega)) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.zCrystal) {
            return false;
        }
        if (heldItem == PixelmonItemsHeld.griseous_orb && (this.getSpecies() == EnumSpecies.Giratina || user.getSpecies() == EnumSpecies.Giratina)) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.drive && (this.getSpecies() == EnumSpecies.Genesect || user.getSpecies() == EnumSpecies.Genesect)) {
            return false;
        }
        if ((this.getSpecies() == EnumSpecies.Kyogre && heldItem == PixelmonItemsHeld.blueOrb || this.getSpecies() == EnumSpecies.Groudon && heldItem == PixelmonItemsHeld.redOrb) && this.getForm() != EnumPrimal.PRIMAL.getForm()) {
            return false;
        }
        if ((user.getSpecies() == EnumSpecies.Kyogre && user.getHeldItem() == PixelmonItemsHeld.blueOrb || user.getSpecies() == EnumSpecies.Groudon && user.getHeldItem() == PixelmonItemsHeld.redOrb) && user.getForm() != EnumPrimal.PRIMAL.getForm()) {
            return false;
        }
        if (heldItem.getHeldItemType() == EnumHeldItems.memory && (user.getSpecies() == EnumSpecies.Silvally || this.getSpecies() == EnumSpecies.Silvally)) {
            return false;
        }
        return this.getSpecies() != EnumSpecies.Arceus;
    }

    public boolean isItemGivable(ItemHeld item) {
        if (item == PixelmonItemsHeld.griseous_orb && this.getSpecies() == EnumSpecies.Giratina) {
            return false;
        }
        if (item.getHeldItemType() == EnumHeldItems.drive && this.getSpecies() == EnumSpecies.Genesect) {
            return false;
        }
        if (item instanceof ItemPlate && this.getSpecies() == EnumSpecies.Arceus) {
            return false;
        }
        if (item instanceof ItemMemory && this.getSpecies() == EnumSpecies.Silvally) {
            return false;
        }
        if (item instanceof ItemMegaStone && PixelmonWrapper.hasCompatibleMegaStone(item, this.getSpecies(), this.getForm())) {
            return false;
        }
        if (item instanceof ItemOrb) {
            ItemOrb orb = (ItemOrb)item;
            if (orb.shard == EnumOrbShard.BLUE && this.getSpecies() == EnumSpecies.Kyogre) {
                return false;
            }
            if (orb.shard == EnumOrbShard.RED && this.getSpecies() == EnumSpecies.Groudon) {
                return false;
            }
        }
        return true;
    }

    public boolean hasSpecialItem(PixelmonWrapper user) {
        ItemHeld item = this.getHeldItem();
        if (item == null) {
            return false;
        }
        if ((this.getSpecies() == EnumSpecies.Kyogre || user.getSpecies() == EnumSpecies.Kyogre) && item == PixelmonItemsHeld.blueOrb) {
            return true;
        }
        if ((this.getSpecies() == EnumSpecies.Groudon || user.getSpecies() == EnumSpecies.Groudon) && item == PixelmonItemsHeld.redOrb) {
            return true;
        }
        if (item instanceof ItemPlate && this.getBattleAbility() instanceof Multitype) {
            return true;
        }
        if (item instanceof ItemMemory && this.getBattleAbility() instanceof RKSSystem) {
            return true;
        }
        if (item instanceof ItemZCrystal) {
            return true;
        }
        if ((this.getSpecies() == EnumSpecies.Giratina || user.getSpecies() == EnumSpecies.Giratina) && item == PixelmonItemsHeld.griseous_orb) {
            return true;
        }
        if ((this.getSpecies() == EnumSpecies.Genesect || user.getSpecies() == EnumSpecies.Genesect) && item.getHeldItemType() == EnumHeldItems.drive) {
            return true;
        }
        return this.hasCompatibleMegaStone() || PixelmonWrapper.hasCompatibleMegaStone(item, user.getSpecies(), user.getForm());
    }

    public String getNickname() {
        AbilityBase battleAbility = this.getBattleAbility();
        if (battleAbility instanceof Illusion) {
            Illusion illusion = (Illusion)battleAbility;
            if (illusion.disguisedPokemon != null) {
                if (!illusion.disguisedNickname.isEmpty()) {
                    return illusion.disguisedNickname;
                }
                return illusion.disguisedPokemon.getLocalizedName();
            }
        }
        return this.getRealNickname();
    }

    public String getRealNickname() {
        return this.pokemon.getDisplayName();
    }

    public Gender getGender() {
        return this.pokemon.getGender();
    }

    public int getHealth(boolean ignoreDynamax) {
        int hp = this.pokemon.getHealth();
        if (this.isDynamax > 0 && ignoreDynamax) {
            hp = (int)Math.ceil((double)hp / (1.0 + this.getDynamaxHealthMod()));
        }
        return hp;
    }

    public int getHealth() {
        return this.getHealth(false);
    }

    public int getMaxHealth(boolean ignoreDynamax) {
        int maxHP = this.pokemon.getStat(StatsType.HP);
        if (this.isDynamax > 0 && !ignoreDynamax) {
            double percent = this.getDynamaxHealthMod();
            maxHP += (int)Math.ceil((double)maxHP * percent);
        }
        return maxHP;
    }

    public int getMaxHealth() {
        return this.getMaxHealth(false);
    }

    public double getDynamaxHealthMod() {
        return 0.5 + (double)this.pokemon.getDynamaxLevel() * 0.05;
    }

    public float getHealthPercent() {
        return this.getHealthPercent(this.getHealth());
    }

    public float getHealthPercent(float amount) {
        return amount / (float)this.getMaxHealth() * 100.0f;
    }

    public float getHealPercent(float amount) {
        return this.getHealthPercent(Math.min(amount, (float)this.getHealthDeficit()));
    }

    public int getHealthDeficit() {
        return this.getMaxHealth() - this.getHealth();
    }

    public boolean hasFullHealth() {
        return this.getHealth() >= this.getMaxHealth();
    }

    public int getPercentMaxHealth(float percent, boolean ignoreDynamax) {
        int maxHP = this.getMaxHealth();
        if (ignoreDynamax) {
            maxHP = (int)Math.ceil((double)maxHP / (1.0 + this.getDynamaxHealthMod()));
        }
        return Math.max(1, (int)((float)maxHP * percent / 100.0f));
    }

    public int getPercentMaxHealth(float percent) {
        return this.getPercentMaxHealth(percent, false);
    }

    public void healByPercent(float percent) {
        this.healEntityBy(this.getPercentMaxHealth(percent));
    }

    public void healEntityBy(int i) {
        if (i + this.getHealth() > this.getMaxHealth()) {
            i = this.getMaxHealth() - this.getHealth();
        }
        if (i != 0 && !this.bc.simulateMode) {
            if (this.animateHP) {
                this.bc.sendHealPacket(this, i);
            }
            this.setHealth(this.getHealth() + i);
        }
    }

    public void setHealth(int newHP) {
        this.pokemon.setHealth(newHP);
    }

    public void setAttackFailed() {
        if (this.attack != null && this.attack.moveResult != null) {
            this.attack.moveResult.result = AttackResult.failed;
        }
    }

    public boolean doesLevel() {
        return this.pokemon.doesLevel();
    }

    public UUID getPokemonUUID() {
        return this.pokemon.getUUID();
    }

    public void update(EnumUpdateType ... types) {
        PartyStorage storage = this.participant.getStorage();
        if (storage != null) {
            this.pokemon.markDirty(types);
        }
    }

    public int getForm() {
        return this.pokemon.getForm();
    }

    public IEnumForm getFormEnum() {
        return this.pokemon.getFormEnum();
    }

    public void setForm(IEnumForm form) {
        this.setForm(form.getForm());
    }

    public void setForm(int form) {
        if (this.bc != null && this.bc.simulateMode) {
            return;
        }
        float healthPercent = this.pokemon.getHealthPercentage();
        float dynScale = this.entity != null ? this.entity.getDynamaxScale() : 1.0f;
        this.pokemon.setForm(form);
        if (this.entity != null) {
            this.entity.setDynamaxScale(dynScale);
        }
        this.type = this.getBaseStats().getTypeList();
        this.initialType = this.type;
        if (this.tempLevel && !this.bc.battleEnded) {
            this.pokemon.getStats().setLevelStats(this.getNature(), this.getBaseStats(), this.temporaryLevel.getLevel());
            this.setHealth(Math.round(healthPercent / 100.0f * (float)this.getMaxHealth()));
        }
        this.updateHPIncrease();
    }

    public void resetBattleEvolution() {
        if (this.getFormEnum().isTemporary()) {
            this.setForm(this.initialCopyOfPokemon.getFormEnum());
        }
        if (this.getFormEnum().isTemporary()) {
            this.setForm(this.getFormEnum().getDefaultFromTemporary(this.pokemon));
        }
    }

    public BlockPos getWorldPosition() {
        EntityPixelmon entity = this.entity;
        if (this.entity == null) {
            entity = this.getParticipant().getEntity();
        }
        return entity.func_180425_c();
    }

    public World getWorld() {
        return this.getParticipant().getEntity().field_70170_p;
    }

    public EntityPlayerMP getPlayerOwner() {
        BattleParticipant participant = this.getParticipant();
        if (participant.getType() == ParticipantType.Player) {
            PlayerParticipant player = (PlayerParticipant)participant;
            return player.player;
        }
        return null;
    }

    public NPCTrainer getTrainerOwner() {
        BattleParticipant participant = this.getParticipant();
        if (participant.getType() == ParticipantType.Trainer) {
            TrainerParticipant trainer = (TrainerParticipant)participant;
            return trainer.trainer;
        }
        return null;
    }

    public boolean isWildPokemon() {
        BattleParticipant participant = this.getParticipant();
        return participant.getType() == ParticipantType.WildPokemon;
    }

    public boolean isSingleType() {
        return this.type.size() == 1;
    }

    public boolean isSingleType(EnumType type) {
        return this.isSingleType() && this.hasType(type);
    }

    public void addAttackers() {
        ArrayList<PixelmonWrapper> opponents = this.getOpponentPokemon();
        this.attackers.addAll(opponents);
        for (PixelmonWrapper opponent : opponents) {
            opponent.attackers.add(this);
        }
    }

    public String getOriginalTrainer() {
        return this.pokemon.getOriginalTrainer();
    }

    public String getRealTextureNoCheck() {
        IEnumForm form = EnumSpecies.mfTextured.contains(this.getSpecies()) ? this.pokemon.getGender() : this.pokemon.getFormEnum();
        String customTexture = this.pokemon.getCustomTexture();
        return Entity2Client.getTextureFor(this.getSpecies(), form, this.pokemon.getGender(), customTexture, this.pokemon.isShiny()).toString();
    }

    public String getPokemonName() {
        return this.getSpecies().name;
    }

    public EnumSpecies getSpecies() {
        return this.pokemon.getSpecies();
    }

    public EnumNature getNature() {
        return this.pokemon.getNature();
    }

    public EnumNature getBaseNature() {
        return this.pokemon.getBaseNature();
    }

    public Level getLevel() {
        if (this.tempLevel) {
            return this.temporaryLevel;
        }
        return this.pokemon.getLevelContainer();
    }

    public int getLevelNum() {
        if (this.tempLevel) {
            return this.temporaryLevel.getLevel();
        }
        return this.pokemon.getLevel();
    }

    public int getExp() {
        if (this.tempLevel) {
            return this.temporaryLevel.getExp();
        }
        return this.pokemon.getExperience();
    }

    public void setLevelNum(int level) {
        if (this.tempLevel) {
            this.temporaryLevel.setLevel(level);
        } else {
            this.pokemon.setLevelNum(level);
        }
    }

    public void setExp(int experience) {
        this.pokemon.setExperience(experience);
    }

    public void setTempLevel(int level) {
        this.tempLevel = true;
        this.temporaryLevel = new TempBattleLevel(new DelegateLink(this.pokemon), level);
    }

    public Pokemon getInnerLink() {
        return this.pokemon;
    }

    public int getPartyPosition() {
        return this.partyPosition;
    }

    public void enableReturnHeldItem() {
        this.returnHeldItem = true;
    }

    public void writeToNBT() {
        if (this.pokemon == null) {
            return;
        }
        if (!this.tempLevel && this.entity != null) {
            this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.pokemon.getMaxHealth());
        }
        if (this.tempLevel) {
            float heath = this.pokemon.getHealthPercentage();
            this.pokemon.getStats().setLevelStats(this.pokemon.getNature(), this.pokemon.getBaseStats(), this.pokemon.getLevel());
            this.setHealth(Math.round(heath / 100.0f * (float)this.pokemon.getMaxHealth()));
            this.update(EnumUpdateType.Stats);
        }
        if (this.bc.rules.fullHeal) {
            this.pokemon.setHealth(this.startHealth);
        } else {
            this.pokemon.setStatus(this.getPrimaryStatus());
        }
        if (!this.tempLevel) {
            // empty if block
        }
        if (this.getHeldItem() != this.initialCopyOfPokemon.getHeldItemAsItemHeld() && this.returnHeldItem) {
            this.pokemon.setHeldItem(this.initialCopyOfPokemon.getHeldItem());
        }
        this.pokemon.markDirty(new EnumUpdateType[0]);
    }

    public void updateHPIncrease() {
        if (this.bc != null) {
            this.bc.sendToPlayers(new LevelUpUpdate(this.getPokemonUUID(), this.getLevelNum(), this.getHealth(), this.getMaxHealth()));
        }
    }
}

