/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses.tiers;

import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;

public abstract class TierSet
extends Tier {
    private Set<PokemonForm> pokemon;

    protected TierSet(String id, Set<PokemonForm> pokemon) {
        super(id);
        this.setPokemon(pokemon);
        this.condition = this.getCondition();
        if (this.condition == null) {
            throw new NullPointerException("Condition cannot be null.");
        }
    }

    public TierSet setPokemon(Set<PokemonForm> pokemon) {
        if (pokemon == null) {
            pokemon = new HashSet<PokemonForm>();
        }
        this.pokemon = pokemon;
        return this;
    }

    protected abstract Predicate<PokemonForm> getCondition();

    protected boolean isInSet(PokemonForm pokemonForm) {
        return this.pokemon.contains(pokemonForm);
    }

    @Override
    public String getTierDescription() {
        if (this.pokemon.isEmpty()) {
            return I18n.func_135052_a((String)"pixelmon.command.tier.everything", (Object[])new Object[0]);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (PokemonForm form : this.pokemon) {
            names.add(form.getLocalizedName());
        }
        Collections.sort(names);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append(name);
        }
        return builder.toString();
    }
}

