/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Levitate;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.List;

public abstract class EntryHazard
extends StatusBase {
    public static List<String> ENTRY_HAZARDS = Lists.newArrayList((Object[])new String[]{"Spikes", "Stealth Rock", "Sticky Web", "Toxic Spikes"});
    private int maxLayers;
    protected transient int numLayers = 1;

    public EntryHazard(StatusType type, int maxLayers) {
        super(type);
        this.maxLayers = maxLayers;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            int message = 0;
            EntryHazard hazard = (EntryHazard)target.getStatus(this.type);
            if (hazard == null) {
                target.addTeamStatus(this.getNewInstance(), user);
                message = 3;
            } else if (hazard.numLayers >= this.maxLayers) {
                message = 1;
            } else {
                if (!user.bc.simulateMode) {
                    ++hazard.numLayers;
                }
                message = 2;
            }
            switch (message) {
                case 1: {
                    user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                    user.attack.moveResult.result = AttackResult.failed;
                    break;
                }
                case 2: {
                    user.bc.sendToAll(this.getMultiLayerMessage(), target.getNickname());
                    break;
                }
                case 3: {
                    user.bc.sendToAll(this.getFirstLayerMessage(), target.getNickname());
                    break;
                }
            }
        }
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    public abstract EntryHazard getNewInstance();

    protected abstract String getFirstLayerMessage();

    protected String getMultiLayerMessage() {
        return this.getFirstLayerMessage();
    }

    protected abstract String getAffectedMessage();

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public void applyEffectOnSwitch(PixelmonWrapper pw) {
        if (!this.isUnharmed(pw)) {
            pw.bc.sendToAll(this.getAffectedMessage(), pw.getNickname());
            this.doEffect(pw);
        }
    }

    protected void doEffect(PixelmonWrapper pw) {
        pw.doBattleDamage(pw, this.getDamage(pw), DamageTypeEnum.STATUS);
    }

    public int getDamage(PixelmonWrapper pw) {
        return 0;
    }

    @Override
    public StatusBase copy() {
        EntryHazard copy = this.getNewInstance();
        copy.numLayers = this.numLayers;
        return copy;
    }

    protected boolean isAirborne(PixelmonWrapper pw) {
        return !pw.isGrounded() && (pw.hasType(EnumType.Flying) || pw.getBattleAbility() instanceof Levitate && !this.ignoreLevitate(pw) || pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.airBalloon || pw.hasStatus(StatusType.MagnetRise, StatusType.Telekinesis));
    }

    private boolean ignoreLevitate(PixelmonWrapper pw) {
        if (pw.bc.turn >= pw.bc.turnList.size()) {
            return false;
        }
        PixelmonWrapper attacker = pw.bc.turnList.get(pw.bc.turn);
        return AbilityBase.ignoreAbility(attacker, pw) && attacker.targets.get((int)0).battlePosition == pw.battlePosition && this.wasForcedSwitch(attacker);
    }

    private boolean wasForcedSwitch(PixelmonWrapper opponent) {
        return opponent.attack != null && opponent.attack.isAttack("Circle Throw", "Dragon Tail", "Roar", "Whirlwind") && (opponent.attack.moveResult.result == AttackResult.hit || opponent.attack.moveResult.result == AttackResult.proceed);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        int totalReserve = 0;
        for (BattleParticipant opponent : pw.getParticipant().getOpponents()) {
            totalReserve += opponent.countAblePokemon() - opponent.controlledPokemon.size();
        }
        userChoice.raiseWeight(totalReserve * this.getAIWeight());
    }

    public abstract int getAIWeight();

    protected boolean isUnharmed(PixelmonWrapper pw) {
        return pw.getHeldItem() == PixelmonItemsHeld.heavyDutyBoots;
    }
}

