/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Infiltrator;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import java.util.ArrayList;

public class Mist
extends StatusBase {
    public transient int effectTurns = 0;

    public Mist() {
        super(StatusType.Mist);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            if (user.hasStatus(StatusType.Mist)) {
                user.bc.sendToAll("pixelmon.effect.alreadymist", user.getNickname());
                user.attack.moveResult.result = AttackResult.failed;
                return;
            }
            if (user.addTeamStatus(new Mist(), user)) {
                user.bc.sendToAll("pixelmon.effect.usemist", user.getNickname());
            }
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (user.attack.getAttackCategory() == AttackCategory.STATUS && !(user.getBattleAbility() instanceof Infiltrator) && this.hasTargetStatsEffect(user.attack)) {
            user.bc.sendToAll("pixelmon.status.mistprotect", pokemon.getNickname());
            return true;
        }
        return false;
    }

    private boolean hasTargetStatsEffect(Attack attack) {
        for (EffectBase e : attack.getMove().effects) {
            if (!(e instanceof StatsEffect)) continue;
            for (ModifierBase m : ((StatsEffect)e).modifiers) {
                if (m.type != ModifierType.User) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsStatChange(PixelmonWrapper pokemon, PixelmonWrapper user, StatsEffect e) {
        return e.getUser() || e.amount > 0 || user.getBattleAbility() instanceof Infiltrator;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (++this.effectTurns >= 5) {
            pw.bc.sendToAll("pixelmon.status.mistoff", pw.getNickname());
            pw.removeTeamStatus(this);
        }
    }

    @Override
    public StatusBase copy() {
        Mist copy = new Mist();
        copy.effectTurns = this.effectTurns;
        return copy;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        boolean hasTargetStatsEffect = false;
        block0: for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            if (opponent.getBattleAbility() instanceof Infiltrator) continue;
            for (Attack attack : pw.getBattleAI().getMoveset(opponent)) {
                if (!this.hasTargetStatsEffect(attack)) continue;
                hasTargetStatsEffect = true;
                continue block0;
            }
        }
        if (hasTargetStatsEffect) {
            userChoice.raiseWeight(15.0f);
        }
    }
}

