/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;

public abstract class Weather
extends GlobalStatusBase {
    protected transient int turnsToGo;
    protected EnumHeldItems weatherRock;
    protected transient String langStart;
    protected transient String langContinue;
    protected transient String langEnd;
    public transient boolean extreme = false;

    public Weather(StatusType type, int turnsToGo, EnumHeldItems weatherRock, String langStart, String langContinue, String langEnd, boolean extreme) {
        super(type);
        this.turnsToGo = turnsToGo;
        this.weatherRock = weatherRock;
        this.langStart = langStart;
        this.langContinue = langContinue;
        this.langEnd = langEnd;
        this.extreme = extreme;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Weather weather = user.bc.globalStatusController.getWeatherIgnoreAbility();
        if (weather != null && weather.type == this.type || !user.bc.globalStatusController.canWeatherChange(this)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            int turns = this.getStartTurns(user);
            user.bc.sendToAll(this.langStart, new Object[0]);
            user.bc.globalStatusController.addGlobalStatus(this.getNewInstance(turns));
        }
    }

    private int getStartTurns(PixelmonWrapper user) {
        return user.getUsableHeldItem().getHeldItemType() == this.weatherRock ? 8 : 5;
    }

    public void setStartTurns(PixelmonWrapper user) {
        this.turnsToGo = this.getStartTurns(user);
    }

    public int getRemainingTurns() {
        return this.turnsToGo;
    }

    protected abstract Weather getNewInstance(int var1);

    @Override
    public void applyRepeatedEffect(GlobalStatusController global) {
        if (--this.turnsToGo == 0) {
            global.removeGlobalStatus(this);
            global.bc.sendToAll(this.langEnd, new Object[0]);
            return;
        }
        global.bc.sendToAll(this.langContinue, new Object[0]);
        this.applyRepeatedEffect(global.bc);
    }

    protected void applyRepeatedEffect(BattleControllerBase bc) {
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        int allyBenefits = 0;
        int opponentBenefits = 0;
        Weather currentWeather = pw.bc.globalStatusController.getWeather();
        for (PixelmonWrapper ally : pw.getTeamPokemon()) {
            allyBenefits += this.countBenefits(pw, ally);
            if (currentWeather == null) continue;
            allyBenefits -= currentWeather.countBenefits(pw, ally);
        }
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            opponentBenefits += this.countBenefits(pw, opponent);
            if (currentWeather == null) continue;
            opponentBenefits -= currentWeather.countBenefits(pw, opponent);
        }
        if (allyBenefits > opponentBenefits) {
            userChoice.raiseWeight(40 * (allyBenefits - opponentBenefits));
        }
    }

    protected abstract int countBenefits(PixelmonWrapper var1, PixelmonWrapper var2);
}

