/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnData;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.World;

public class BlockSpawnArea {
    public String name;
    public EnumBattleStartTypes type;
    public HashMap<String, BlockSpawnData> blockSpawns = new HashMap();

    public BlockSpawnArea(String name, EnumBattleStartTypes type, HashMap<String, BlockSpawnData> blockSpawns) {
        this.name = name;
        this.type = type;
        this.blockSpawns = blockSpawns;
    }

    public String getRandomPokemon(World world) {
        return this.getPokemonFromList(world);
    }

    public String getPokemonFromList(World world) {
        ArrayList<WorldTime> times = WorldTime.getCurrent(world);
        int totalRarity = 0;
        for (BlockSpawnData spawnList : this.blockSpawns.values()) {
            totalRarity += spawnList.getRarity(times);
        }
        if (totalRarity > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalRarity - 1);
            int sum = 0;
            for (BlockSpawnData spawnList : this.blockSpawns.values()) {
                int rarity = 0;
                if (num < sum + (rarity += spawnList.getRarity(times))) {
                    return spawnList.name;
                }
                sum += rarity;
            }
        }
        return null;
    }
}

