/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectPokemon;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiVersus;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectPokemonIcon;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiRoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.ConfirmTeamSelect;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.ShowTeamSelect;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UnconfirmTeamSelect;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTeamSelect
extends GuiVersus {
    public static ShowTeamSelect teamSelectPacket;
    private NPCTrainer trainer;
    private GuiRoundButton confirmButton;
    private boolean confirmed;
    private boolean timeExpired;
    private ClientBattleManager bm;
    private List<TeamSelectPokemonIcon> icons = new ArrayList<TeamSelectPokemonIcon>();
    private int numSelected;
    public String rejectClause = "";
    private static final String SELECT_TEAM = "gui.battlerules.selectteam";

    public GuiTeamSelect() {
        Optional<NPCTrainer> entityNPCOptional;
        this.confirmButton = new GuiRoundButton(85, 152, I18n.func_135052_a((String)SELECT_TEAM, (Object[])new Object[0]));
        this.bm = ClientProxy.battleManager;
        this.bm.setTeamSelectTime();
        if (GuiTeamSelect.teamSelectPacket.npcID != -1 && (entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, GuiTeamSelect.teamSelectPacket.npcID, NPCTrainer.class)).isPresent()) {
            this.trainer = entityNPCOptional.get();
            this.isNPC = true;
        }
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        if (this.icons.isEmpty()) {
            i = 0;
            for (Pokemon data : ClientStorageManager.party.getAll()) {
                TeamSelectPokemon pokemon = null;
                if (data != null) {
                    pokemon = new TeamSelectPokemon(data);
                }
                this.icons.add(new TeamSelectPokemonIcon(pokemon, GuiTeamSelect.teamSelectPacket.disabled[i]));
                ++i;
            }
            if (this.bm.rules.teamPreview) {
                for (TeamSelectPokemon pokemon : GuiTeamSelect.teamSelectPacket.opponentTeam) {
                    this.icons.add(new TeamSelectPokemonIcon(pokemon, "n"));
                }
            }
        }
        i = 0;
        for (TeamSelectPokemonIcon icon : this.icons) {
            if (i < 6) {
                icon.setPosition(this.playerPartyX + i * 12, this.playerPartyY);
            } else {
                icon.setPosition(this.opponentPartyX + (i - 6) * 12, this.opponentPartyY);
            }
            ++i;
        }
    }

    protected void func_73869_a(char key, int keyCode) {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.ticks == 0) {
            boolean canHighlight = this.numSelected > 0;
            int currentX = canHighlight ? mouseX : 0;
            int currentY = canHighlight ? mouseY : 0;
            this.confirmButton.drawButton(this.leftX, this.topY, currentX, currentY, this.field_73735_i, this.confirmed);
        }
        int i = 0;
        for (TeamSelectPokemonIcon icon : this.icons) {
            icon.setTickOffset(i++ < 6 ? this.offset1 : this.offset2);
            icon.drawIcon(mouseX, mouseY, this.field_73735_i, this.isFullSelect());
        }
        if (!this.bm.rules.teamPreview) {
            this.drawOpponentPokeBalls(GuiTeamSelect.teamSelectPacket.opponentSize);
        }
        if (this.bm.afkOn) {
            GuiHelper.drawBattleTimer(this, this.bm.afkTime);
            if (this.bm.afkTime <= 0 && !this.timeExpired) {
                this.confirmed = true;
                this.timeExpired = true;
                Pixelmon.network.sendToServer((IMessage)new ConfirmTeamSelect(GuiTeamSelect.teamSelectPacket.teamSelectID, this.getSelectionOrder(), true));
            }
        }
        String centerMessage = "";
        if (!this.rejectClause.isEmpty()) {
            centerMessage = I18n.func_135052_a((String)"gui.battlerules.teamviolated", (Object[])new Object[0]) + " " + BattleClause.getLocalizedName(this.rejectClause);
            this.confirmed = false;
        } else if (this.confirmed) {
            centerMessage = I18n.func_135052_a((String)"gui.battlerules.waitselect", (Object[])new Object[0]);
        }
        if (!centerMessage.isEmpty()) {
            GuiHelper.renderTooltip(this.leftX + 140, this.topY + 60, this.field_146297_k.field_71466_p.func_78271_c(centerMessage, 100), Color.BLUE.getRGB(), Color.BLACK.getRGB(), 200, true, true);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int par3) {
        if (this.timeExpired) {
            return;
        }
        if (!this.confirmed) {
            for (TeamSelectPokemonIcon icon : this.icons) {
                if (!icon.isMouseOver(mouseX, mouseY) || icon.isDisabled()) continue;
                if (icon.selectIndex == -1) {
                    if (this.isFullSelect()) break;
                    icon.selectIndex = this.numSelected++;
                    if (this.numSelected == 1) {
                        this.confirmButton.setText(I18n.func_135052_a((String)"gui.battlerules.confirm", (Object[])new Object[0]));
                    }
                } else {
                    for (TeamSelectPokemonIcon icon2 : this.icons) {
                        if (icon2.selectIndex <= icon.selectIndex) continue;
                        --icon2.selectIndex;
                    }
                    icon.selectIndex = -1;
                    if (--this.numSelected == 0) {
                        this.confirmButton.setText(I18n.func_135052_a((String)SELECT_TEAM, (Object[])new Object[0]));
                    }
                }
                this.rejectClause = "";
                break;
            }
        }
        if (this.numSelected > 0 && this.confirmButton.isMouseOver(this.leftX, this.topY, mouseX, mouseY)) {
            boolean bl = this.confirmed = !this.confirmed;
            if (this.confirmed) {
                Pixelmon.network.sendToServer((IMessage)new ConfirmTeamSelect(GuiTeamSelect.teamSelectPacket.teamSelectID, this.getSelectionOrder(), false));
            } else {
                Pixelmon.network.sendToServer((IMessage)new UnconfirmTeamSelect(GuiTeamSelect.teamSelectPacket.teamSelectID));
            }
        }
    }

    private boolean isFullSelect() {
        return this.numSelected >= this.bm.rules.numPokemon;
    }

    @Override
    protected EntityLivingBase getOpponent() {
        if (GuiTeamSelect.teamSelectPacket.opponentUUID == null) {
            return this.trainer;
        }
        return this.field_146297_k.field_71441_e.func_152378_a(GuiTeamSelect.teamSelectPacket.opponentUUID);
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private int[] getSelectionOrder() {
        int[] selection = new int[6];
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = this.icons.get((int)i).selectIndex;
        }
        return selection;
    }
}

