/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.GuiFishingLogInformation;
import com.pixelmonmod.pixelmon.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class GuiFishingLog
extends GuiScreen {
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private EnumSpecies species;
    private int[] encountered;
    private LinkedHashMultimap<Integer, PokemonSpec> categories = LinkedHashMultimap.create();
    private BiMap<PokemonSpec, GuiButton> buttons = HashBiMap.create();
    private int currentScroll = 0;
    private int waitingScroll = 0;
    private int viewedForm = -1;
    private double percentComplete = 0.0;
    int maxScroll;

    public GuiFishingLog(int species, int ... data) {
        this.species = EnumSpecies.getFromDex(species);
        this.encountered = data;
        this.setCategories();
        for (int i : this.encountered) {
            if (i <= 0) continue;
            this.percentComplete += 1.0;
        }
        this.percentComplete /= (double)data.length;
        this.maxScroll = 40;
        Object object = this.categories.keySet().iterator();
        while (object.hasNext()) {
            Integer category = (Integer)object.next();
            this.maxScroll += 32;
            for (int i = 0; i < this.categories.get((Object)category).size(); ++i) {
                if (i % 3 != 0 && i != this.categories.get((Object)category).size()) continue;
                this.maxScroll += 65;
            }
        }
    }

    public void setCategories() {
        LinkedHashMultimap<Integer, PokemonSpec> c = FormLogRegistry.getFormsForSpecies(this.species);
        for (Integer integer : c.keySet()) {
            ArrayList specs = Lists.newArrayList();
            for (PokemonSpec spec : c.get((Object)integer)) {
                int id = FormLogRegistry.getFormId(this.species, spec);
                if (this.encountered[id] <= 0) continue;
                specs.add(spec);
            }
            this.categories.putAll((Object)integer, (Iterable)specs);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        for (PokemonSpec spec : this.categories.values()) {
            this.buttons.put((Object)spec, (Object)this.func_189646_b(new GuiButton(FormLogRegistry.getFormId(this.species, spec), 0, 0, 40, 46, spec.toString())));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiHelper.bindFontRenderer("pixelmon:textures/gui/pokemonfont.png", true);
        this.drawScreenBackground();
        this.processScroll();
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * (float)sr.func_78325_e();
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * (float)sr.func_78325_e();
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 5.0f) * (float)sr.func_78325_e();
        float y2 = ((float)this.centerY + this.guiHeight / 2.0f - 5.0f) * (float)sr.func_78325_e();
        GL11.glScissor((int)((int)x1), (int)((int)((float)Display.getHeight() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        this.drawScreenForeground(mouseX, mouseY);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogTitle);
        int height = 15;
        float width = (float)height * 6.168067f;
        GuiHelper.drawImageQuad((float)this.centerX - width / 2.0f, this.centerY - 117, width, height, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        GuiHelper.drawScaledCenteredString(I18n.func_74837_a((String)"gui.fishinglog.title", (Object[])new Object[]{this.species.getLocalizedName()}), this.centerX, (float)this.centerY - 112.5f, -7781367, 14.0f);
        GuiHelper.resetFontRenderer();
    }

    public void drawScreenBackground() {
        this.field_146297_k.field_71446_o.func_110577_a(this.viewedForm == -1 ? GuiResources.fishingLogBackground : GuiResources.fishingLogInformationBackground);
        GuiHelper.drawImageQuad((float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    public void drawScreenForeground(int mouseX, int mouseY) {
        float x = (float)this.centerX - this.guiWidth / 2.0f + 14.5f;
        AtomicInteger top = new AtomicInteger((int)((float)(-this.currentScroll + this.centerY) - this.guiHeight / 2.0f - 5.0f));
        DecimalFormat format = new DecimalFormat("###.#");
        GuiHelper.drawScaledString(I18n.func_74837_a((String)"gui.fishinglog.percentage", (Object[])new Object[]{format.format(100.0 * this.percentComplete)}), x + 5.0f, top.addAndGet(21), -7781367, 10.0f);
        GuiFishingLog.func_73734_a((int)((int)x), (int)top.get(), (int)((int)x + 2), (int)top.addAndGet(8), (int)-1276390);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        for (Integer category : this.categories.keySet()) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogCategory);
            GuiHelper.drawImageQuad(x, top.addAndGet(14), 127.0, 14.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            GuiHelper.drawScaledString(I18n.func_74838_a((String)("gui.fishinglog." + this.species.name.toLowerCase() + ".category" + category + ".name")), x + 4.0f, top.addAndGet(4), -7781367, 10.0f);
            top.addAndGet(14);
            int i = 0;
            for (PokemonSpec form : this.categories.get((Object)category)) {
                GuiButton button = (GuiButton)this.buttons.get((Object)form);
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogContainer);
                float height = 45.6f;
                float xPos = x + 43.5f * (float)(i % 3);
                GuiHelper.drawImageQuad(xPos, top.get(), 40.0, height, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                button.field_146128_h = (int)xPos;
                button.field_146129_i = top.get();
                Pokemon pokemon = Pixelmon.pokemonFactory.create(this.species);
                form.apply(pokemon);
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.getPokemonSprite(pokemon));
                GuiHelper.drawImageQuad(xPos, top.get() - 1, 39.0, 39.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                int id = button.field_146127_k + 1;
                GuiHelper.drawScaledString("No. " + id, xPos + (id < 10 ? 3.0f : 1.6f), top.get() + 2, -1, 7.0f);
                if (pokemon.isShiny()) {
                    GuiHelper.drawScaledCenteredSplitString(I18n.func_74838_a((String)"gui.trainereditor.shiny"), xPos + 20.0f, (float)top.get() + height + 4.0f, -7845363, 8.0f, 50, false);
                } else {
                    GuiHelper.drawScaledCenteredSplitString(pokemon.getFormEnum().getLocalizedName(), xPos + 20.0f, (float)top.get() + height + 4.0f, -7845363, 8.0f, 50, false);
                }
                if (++i % 3 != 0 && i != this.categories.get((Object)category).size()) continue;
                top.addAndGet(65);
            }
        }
    }

    public void processScroll() {
        int mustard = 6;
        if (this.waitingScroll != 0) {
            if (Math.abs(this.waitingScroll) >= mustard) {
                if (this.waitingScroll < 0) {
                    this.waitingScroll += mustard;
                    this.currentScroll -= mustard;
                } else {
                    this.waitingScroll -= mustard;
                    this.currentScroll += mustard;
                }
            } else if (this.waitingScroll < 0) {
                ++this.waitingScroll;
                --this.currentScroll;
            } else {
                --this.waitingScroll;
                ++this.currentScroll;
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.viewedForm == -1) {
            int i = Mouse.getEventDWheel();
            int speed = 20;
            if (i < 0) {
                this.waitingScroll += speed;
                if (this.currentScroll + this.waitingScroll > this.maxScroll - 240) {
                    this.waitingScroll = this.maxScroll - 240 - this.currentScroll;
                }
            } else if (i > 0) {
                this.waitingScroll -= speed;
                if (this.currentScroll + this.waitingScroll < 0) {
                    this.waitingScroll = -this.currentScroll;
                }
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        PokemonSpec form = (PokemonSpec)this.buttons.inverse().get((Object)button);
        int category = this.categories.entries().stream().filter(e -> ((PokemonSpec)e.getValue()).equals(form)).mapToInt(Map.Entry::getKey).findFirst().orElse(0);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFishingLogInformation(this.species.getNationalPokedexInteger(), category, form, this.encountered));
    }
}

