/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.zygarde;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiRoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde.ZygardeCubePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemZygardeCube;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiZygardeCube
extends GuiScreen {
    EnumHand hand;
    StoragePosition position;
    Pokemon zygarde;
    ItemStack cube;
    Mode mode = Mode.SELECT;
    List<GuiRoundButton> buttons = Lists.newArrayList();
    List<String> lines = Lists.newArrayList();
    private int centerW;
    private int centerH;

    public GuiZygardeCube(EnumHand hand, int partyPos) {
        ItemStack stack;
        this.field_146297_k = Minecraft.func_71410_x();
        this.hand = hand;
        this.position = new StoragePosition(-1, partyPos);
        Pokemon pokemon = ClientStorageManager.party.get(this.position);
        if (pokemon.getSpecies() == EnumSpecies.Zygarde) {
            this.zygarde = pokemon;
        }
        if ((stack = this.field_146297_k.field_71439_g.func_184586_b(hand)).func_77973_b() instanceof ItemZygardeCube) {
            this.cube = stack;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerW = this.field_146294_l / 2;
        this.centerH = this.field_146295_m / 2;
        this.buttons.clear();
        this.lines.clear();
        if (this.cube == null || this.zygarde == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (this.mode == Mode.SELECT) {
            if (!(this.zygarde.getAbility() instanceof PowerConstruct) && ItemZygardeCube.getCoreTypes(this.cube).size() == 0) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.nomoves", (Object[])new Object[0]));
                this.buttons.add(new GuiRoundButton(0, 0, I18n.func_135052_a((String)"gui.button.okay", (Object[])new Object[0]), 150, 20).setId(-1));
            } else if (this.zygarde.getAbility() instanceof PowerConstruct) {
                this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.select", (Object[])new Object[0]));
                if (this.zygarde.getAbility() instanceof PowerConstruct) {
                    this.buttons.add(new GuiRoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.toggleforme", (Object[])new Object[0]), 150, 20).setId(0));
                }
                if (ItemZygardeCube.getCoreTypes(this.cube).size() > 0) {
                    this.buttons.add(new GuiRoundButton(0, 0, I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.teachmove", (Object[])new Object[0]), 150, 20).setId(1));
                }
            } else {
                this.mode = Mode.LEARN_MOVE;
            }
        }
        if (this.mode == Mode.LEARN_MOVE) {
            this.lines.add(I18n.func_135052_a((String)"pixelmon.gui.zygarde_cube.learnmove", (Object[])new Object[0]));
            for (ItemZygardeCube.CoreType type : ItemZygardeCube.getCoreTypes(this.cube)) {
                AttackBase base = AttackBase.getAttackBaseFromEnglishName(type.getMoveName()).get();
                this.buttons.add(new GuiRoundButton(0, 0, base.getLocalizedName(), 150, 20).setId(type.ordinal()));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.lines.isEmpty()) {
            GuiHelper.drawDialogueBox((GuiScreen)this, "", this.lines, 0.0f);
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            GuiRoundButton button = this.buttons.get(i);
            button.drawButton(this.centerW - 70, this.field_146295_m / 4 + 20 + 30 * (i + 1), mouseX, mouseY, 0.0f);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            GuiRoundButton button = this.buttons.get(i);
            if (!button.isMouseOver(this.centerW - 70, this.field_146295_m / 4 + 20 + 30 * (i + 1), mouseX, mouseY)) continue;
            if (this.mode == Mode.SELECT) {
                if (button.getId() == 0) {
                    Pixelmon.network.sendToServer((IMessage)new ZygardeCubePacket(this.position, this.field_146297_k.field_71439_g.field_71071_by.func_184429_b(this.cube)));
                    this.field_146297_k.func_147108_a(null);
                    continue;
                }
                if (button.getId() == 1) {
                    this.mode = Mode.LEARN_MOVE;
                    this.func_73866_w_();
                    continue;
                }
                if (button.getId() != -1) continue;
                this.field_146297_k.func_147108_a(null);
                continue;
            }
            if (this.mode != Mode.LEARN_MOVE) continue;
            Pixelmon.network.sendToServer((IMessage)new ZygardeCubePacket(this.position, this.field_146297_k.field_71439_g.field_71071_by.func_184429_b(this.cube), button.getId()));
            this.field_146297_k.func_147108_a(null);
        }
    }

    static enum Mode {
        SELECT,
        LEARN_MOVE,
        TOGGLE_FORM;

    }
}

