/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LevelUpUpdate
extends BattleMessageBase
implements IMessage {
    public int level;
    public int currentHP;
    public int maxHP;

    public LevelUpUpdate() {
    }

    public LevelUpUpdate(UUID pokemonUUID, int level, int currentHP, int maxHP) {
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.currentHP = currentHP;
        this.maxHP = maxHP;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        this.level = buf.readInt();
        this.currentHP = buf.readInt();
        this.maxHP = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        buf.writeInt(this.level);
        buf.writeInt(this.currentHP);
        buf.writeInt(this.maxHP);
    }

    @Override
    public void process() {
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedOurPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedEnemyPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pokemon : ClientProxy.battleManager.fullOurPokemon) {
            this.updatePokemon(pokemon, this);
        }
        if (ClientProxy.battleManager.displayedAllyPokemon != null) {
            for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedAllyPokemon) {
                this.updatePokemon(pixelmonInGui, this);
            }
        }
        ClientProxy.battleManager.removeBattleMessage(this);
    }

    private void updatePokemon(PixelmonInGui pokemon, LevelUpUpdate message) {
        if (pokemon != null && pokemon.pokemonUUID.equals(message.pokemonUUID)) {
            pokemon.level = message.level;
            pokemon.health = message.currentHP;
            pokemon.maxHealth = message.maxHP;
        }
    }

    public static class Handler
    implements IMessageHandler<LevelUpUpdate, IMessage> {
        public IMessage onMessage(LevelUpUpdate message, MessageContext ctx) {
            if (ClientProxy.battleManager == null || ClientProxy.battleManager.displayedOurPokemon == null) {
                return null;
            }
            message.messageType = MessageType.HP;
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

