/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StatusPacket
extends BattleMessageBase
implements IMessage {
    private int status = -1;

    public StatusPacket() {
    }

    public StatusPacket(UUID uuid, int status) {
        this.pokemonUUID = uuid;
        this.status = status;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        this.status = buf.readInt();
        this.messageType = MessageType.STATUS;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        buf.writeInt(this.status);
    }

    @Override
    public void process() {
        PixelmonInGui pokemon = ClientProxy.battleManager.getPokemon(this.pokemonUUID);
        if (pokemon != null) {
            pokemon.status = this.status;
        }
        ClientProxy.battleManager.removeBattleMessage(this);
    }

    public static class Handler
    implements IMessageHandler<StatusPacket, IMessage> {
        public IMessage onMessage(StatusPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

