/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.overlays;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.OverlayGraphicType;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CustomNoticePacket
implements IMessage {
    private boolean enabled = true;
    private String[] lines;
    private EnumOverlayLayout layout = null;
    private OverlayGraphicType type = null;
    private PokemonSpec spec = null;
    private ItemStack itemStack = null;

    public CustomNoticePacket setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CustomNoticePacket setLines(String[] lines) {
        this.lines = lines;
        return this;
    }

    public CustomNoticePacket setPokemonSprite(PokemonSpec spec, EnumOverlayLayout layout) {
        Preconditions.checkArgument((((PokemonSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec")).name != null ? 1 : 0) != 0, (Object)"The spec doesn't specify a pok\u00e9mon.");
        this.type = OverlayGraphicType.PokemonSprite;
        this.spec = spec;
        this.layout = (EnumOverlayLayout)((Object)Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout"));
        return this;
    }

    public CustomNoticePacket setPokemon3D(PokemonSpec spec, EnumOverlayLayout layout) {
        Preconditions.checkArgument((((PokemonSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec")).name != null ? 1 : 0) != 0, (Object)"The spec doesn't specify a pok\u00e9mon.");
        this.type = OverlayGraphicType.Pokemon3D;
        this.spec = spec;
        this.layout = (EnumOverlayLayout)((Object)Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout"));
        return this;
    }

    public CustomNoticePacket setItemStack(ItemStack itemStack, EnumOverlayLayout layout) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack");
        Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout");
        if (itemStack.func_190926_b()) {
            return this.setEmpty();
        }
        this.type = OverlayGraphicType.ItemStack;
        this.itemStack = itemStack;
        this.layout = layout;
        return this;
    }

    public CustomNoticePacket setEmpty() {
        this.type = null;
        return this;
    }

    @Deprecated
    public void setPokemonSprite(EnumSpecies species, EnumOverlayLayout displayType) {
        this.setPokemonSprite(new PokemonSpec(species.name), displayType);
    }

    @Deprecated
    public void setPokemon3D(EnumSpecies species, EnumOverlayLayout displayType, float scale) {
        this.setPokemon3D(new PokemonSpec(species.name), displayType);
    }

    @Deprecated
    public void setItemSprite(String itemName, EnumOverlayLayout displayType) {
        this.setItemStack(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName))), displayType);
    }

    @Deprecated
    public void setItem3D(String itemName, EnumOverlayLayout displayType) {
        this.setItemStack(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName))), displayType);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.enabled);
        if (!this.enabled) {
            return;
        }
        buf.writeByte(this.lines == null ? -1 : this.lines.length);
        for (String line : this.lines) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)line);
        }
        buf.writeByte(this.type == null ? -1 : this.type.ordinal());
        if (this.type != null) {
            buf.writeByte(this.layout.ordinal());
            switch (this.type) {
                case PokemonSprite: 
                case Pokemon3D: {
                    ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.spec.writeToNBT(new NBTTagCompound()));
                    break;
                }
                case ItemStack: {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        byte typeOrdinal;
        this.enabled = buf.readBoolean();
        if (!this.enabled) {
            return;
        }
        int linesLength = buf.readByte();
        if (linesLength != -1) {
            this.lines = new String[linesLength];
            for (int i = 0; i < linesLength; ++i) {
                this.lines[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }
        if ((typeOrdinal = buf.readByte()) != -1) {
            this.type = OverlayGraphicType.values()[typeOrdinal];
            this.layout = EnumOverlayLayout.values()[buf.readByte()];
            switch (this.type) {
                case PokemonSprite: 
                case Pokemon3D: {
                    this.spec = new PokemonSpec(new String[0]).readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
                    if (this.spec.growth != null) break;
                    this.spec.growth = (byte)EnumGrowth.Ordinary.ordinal();
                    break;
                }
                case ItemStack: {
                    this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CustomNoticePacket, IMessage> {
        public IMessage onMessage(CustomNoticePacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (!message.enabled) {
                    CustomNoticeOverlay.setEnabled(false);
                } else {
                    CustomNoticeOverlay.resetNotice();
                    try {
                        CustomNoticeOverlay.populate(new ArrayList<String>(Arrays.asList(message.lines)));
                        if (message.type != null) {
                            switch (message.type) {
                                case PokemonSprite: {
                                    CustomNoticeOverlay.setPokemonSprite(message.spec, message.layout);
                                    break;
                                }
                                case Pokemon3D: {
                                    CustomNoticeOverlay.setPokemon3D(message.spec, message.layout);
                                    break;
                                }
                                case ItemStack: {
                                    CustomNoticeOverlay.setItemStack(message.itemStack, message.layout);
                                }
                            }
                        }
                        CustomNoticeOverlay.setEnabled(true);
                    }
                    catch (Exception e) {
                        CustomNoticeOverlay.resetNotice();
                        Pixelmon.LOGGER.error("The server is sending weird values to the overlay.", (Throwable)e);
                    }
                }
            });
            return null;
        }
    }
}

