/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import com.pixelmonmod.pixelmon.api.events.ShopkeeperEvent;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.EnumBuySell;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ShopKeeperPacket
implements IMessage {
    EnumBuySell buySell;
    String itemID;
    int amount;
    int shopKeeperID;

    public ShopKeeperPacket() {
    }

    public ShopKeeperPacket(EnumBuySell buySell, int shopkeeperID, String itemID, int amount) {
        this.shopKeeperID = shopkeeperID;
        this.itemID = itemID;
        this.amount = amount;
        this.buySell = buySell;
    }

    public void fromBytes(ByteBuf buf) {
        this.buySell = buf.readBoolean() ? EnumBuySell.Buy : EnumBuySell.Sell;
        this.shopKeeperID = buf.readInt();
        this.itemID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.buySell == EnumBuySell.Buy);
        buf.writeInt(this.shopKeeperID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemID);
        buf.writeInt(this.amount);
    }

    public static class Handler
    implements ISyncHandler<ShopKeeperPacket> {
        @Override
        public void onSyncMessage(ShopKeeperPacket message, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            Optional<NPCShopkeeper> npcOptional = EntityNPC.locateNPCServer(p.field_70170_p, message.shopKeeperID, NPCShopkeeper.class);
            IPixelmonBankAccount account = Pixelmon.moneyManager.getBankAccount(p).orElse(null);
            if (!npcOptional.isPresent() || message.amount <= 0 || account == null) {
                return;
            }
            NPCShopkeeper npc = npcOptional.get();
            if (message.buySell == EnumBuySell.Buy) {
                ArrayList<ShopItemWithVariation> itemList = npc.getItemList();
                for (ShopItemWithVariation shopItem : itemList) {
                    if (!shopItem.getBaseShopItem().id.equals(message.itemID)) continue;
                    if (message.amount > PixelmonConfig.getShopMaxStackSize(shopItem.getItemStack())) {
                        return;
                    }
                    if (account.getMoney() < shopItem.getBuyCost() * message.amount) continue;
                    if (shopItem.getBuyCost() * message.amount < 0) {
                        return;
                    }
                    ItemStack item = shopItem.getItemStack();
                    ItemStack buyStack = item.func_77946_l();
                    int initialAmount = message.amount;
                    buyStack.func_190920_e(message.amount);
                    if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Purchase(p, npc, buyStack, EnumBuySell.Buy))) {
                        return;
                    }
                    if (p.func_191521_c(buyStack)) {
                        Item buyItem = buyStack.func_77973_b();
                        if (buyItem instanceof ItemPokeball && ((ItemPokeball)buyItem).type == EnumPokeballs.PokeBall && message.amount >= 10) {
                            ItemStack premierBall = new ItemStack(PixelmonItemsPokeballs.premierBall, 1);
                            p.func_191521_c(premierBall);
                        }
                        account.changeMoney(-shopItem.getBuyCost() * message.amount);
                        this.updateTransaction(p, npc);
                        return;
                    }
                    if (initialAmount <= buyStack.func_190916_E()) continue;
                    int actualAmount = initialAmount - buyStack.func_190916_E();
                    account.changeMoney(-shopItem.getBuyCost() * actualAmount);
                    this.updateTransaction(p, npc);
                    return;
                }
            } else {
                ArrayList<ShopItemWithVariation> sellList = npc.getSellList((EntityPlayer)p);
                for (ShopItemWithVariation shopItem : sellList) {
                    if (!shopItem.getBaseShopItem().id.equals(message.itemID)) continue;
                    int count = 0;
                    ItemStack sStack = shopItem.getItemStack();
                    for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                        ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                        if (!this.areItemsEqual(item, sStack)) continue;
                        count += item.func_190916_E();
                    }
                    ItemStack copy = sStack.func_77946_l();
                    copy.func_190920_e(message.amount);
                    if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Sell(p, npc, EnumBuySell.Sell, copy))) {
                        return;
                    }
                    if (count < message.amount) continue;
                    int cost = shopItem.getSellCost();
                    count = message.amount;
                    for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                        ItemStack item = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                        if (this.areItemsEqual(item, sStack)) {
                            if (item.func_190916_E() >= count) {
                                item.func_190920_e(item.func_190916_E() - count);
                                count = 0;
                            } else {
                                count -= item.func_190916_E();
                                item.func_190920_e(0);
                            }
                            if (item.func_190916_E() == 0) {
                                p.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                            }
                        }
                        if (count <= 0) break;
                    }
                    account.changeMoney(cost * message.amount);
                    this.updateTransaction(p, npc);
                }
            }
        }

        private void updateTransaction(EntityPlayerMP p, NPCShopkeeper npc) {
            p.field_71069_bz.func_75142_b();
            npc.sendItemsToPlayer((EntityPlayer)p);
        }

        private boolean areItemsEqual(ItemStack item1, ItemStack item2) {
            return !item1.func_190926_b() && ItemStack.func_179545_c((ItemStack)item1, (ItemStack)item2) && ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2) && item1.func_77952_i() == item2.func_77952_i();
        }
    }
}

