/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.items.ItemLureCasing;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelmonItemsLures {
    public static Item weakLureCasing;
    public static Item strongLureCasing;
    public static ArrayList<Item> weakLures;
    public static ArrayList<Item> strongLures;

    public static void load() {
        for (ItemLure.LureType type : ItemLure.LureType.values()) {
            weakLures.add(new ItemLure(type, ItemLure.LureStrength.WEAK));
            strongLures.add(new ItemLure(type, ItemLure.LureStrength.STRONG));
        }
        weakLureCasing = new ItemLureCasing(ItemLure.LureStrength.WEAK);
        strongLureCasing = new ItemLureCasing(ItemLure.LureStrength.STRONG);
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        weakLures.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        strongLures.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        event.getRegistry().register((IForgeRegistryEntry)weakLureCasing);
        event.getRegistry().register((IForgeRegistryEntry)strongLureCasing);
    }

    public static void registerRenderers() {
        weakLures.forEach(lure -> ModelLoader.setCustomModelResourceLocation((Item)lure, (int)0, (ModelResourceLocation)new ModelResourceLocation(lure.getRegistryName(), "inventory")));
        strongLures.forEach(lure -> ModelLoader.setCustomModelResourceLocation((Item)lure, (int)0, (ModelResourceLocation)new ModelResourceLocation(lure.getRegistryName(), "inventory")));
        ModelLoader.setCustomModelResourceLocation((Item)weakLureCasing, (int)0, (ModelResourceLocation)new ModelResourceLocation(weakLureCasing.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)strongLureCasing, (int)0, (ModelResourceLocation)new ModelResourceLocation(strongLureCasing.getRegistryName(), "inventory"));
    }

    public static ItemLure getLure(ItemLure.LureType type, ItemLure.LureStrength strength) {
        return (ItemLure)CollectionHelper.find(strength == ItemLure.LureStrength.WEAK ? weakLures : strongLures, lure -> ((ItemLure)lure).type == type);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemLayers() {
        IItemColor colour = (stack, tint) -> {
            if (tint != 1) {
                return 0xFFFFFF;
            }
            ItemLure lure = (ItemLure)stack.func_77973_b();
            if (lure.type == ItemLure.LureType.SHINY) {
                return 16570112;
            }
            if (lure.type == ItemLure.LureType.HA) {
                return 16318605;
            }
            return lure.type.type.getColor();
        };
        for (Item item : weakLures) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(colour, new Item[]{item});
        }
        for (Item item : strongLures) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(colour, new Item[]{item});
        }
    }

    static {
        weakLures = new ArrayList();
        strongLures = new ArrayList();
    }
}

