/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.ArrayList;

public class StarterList {
    public static final int NUM_STARTERS = 24;
    private static PokemonForm[] starterList;

    public static void setStarterList(PokemonForm[] newStarterList) {
        starterList = newStarterList;
    }

    public static PokemonForm[] getStarterList() {
        if (PixelmonConfig.useCustomStarters) {
            ArrayList<PokemonForm> list = new ArrayList<PokemonForm>();
            for (String str : PixelmonConfig.starterList) {
                PokemonSpec spec = PokemonSpec.from(str);
                EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(spec.name);
                if (species == null) continue;
                PokemonForm poke = new PokemonForm(species);
                if (spec.form != null) {
                    poke.form = spec.form.byteValue();
                }
                if (spec.gender != null) {
                    poke.gender = Gender.getGender(spec.gender.byteValue());
                }
                list.add(poke);
            }
            return list.toArray(new PokemonForm[0]);
        }
        return starterList;
    }

    static {
        EnumSpecies[] starterSpecies = new EnumSpecies[]{EnumSpecies.Bulbasaur, EnumSpecies.Squirtle, EnumSpecies.Charmander, EnumSpecies.Chikorita, EnumSpecies.Totodile, EnumSpecies.Cyndaquil, EnumSpecies.Treecko, EnumSpecies.Mudkip, EnumSpecies.Torchic, EnumSpecies.Turtwig, EnumSpecies.Piplup, EnumSpecies.Chimchar, EnumSpecies.Snivy, EnumSpecies.Oshawott, EnumSpecies.Tepig, EnumSpecies.Chespin, EnumSpecies.Froakie, EnumSpecies.Fennekin, EnumSpecies.Rowlet, EnumSpecies.Popplio, EnumSpecies.Litten, EnumSpecies.Grookey, EnumSpecies.Sobble, EnumSpecies.Scorbunny};
        starterList = new PokemonForm[starterSpecies.length];
        for (int i = 0; i < starterSpecies.length; ++i) {
            StarterList.starterList[i] = new PokemonForm(starterSpecies[i]);
        }
    }
}

