/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.AI.AIExecuteAction;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsTarget;
import com.pixelmonmod.pixelmon.AI.AITargetNearest;
import com.pixelmonmod.pixelmon.AI.AITrainerInBattle;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRules;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ITrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerChat;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import com.pixelmonmod.pixelmon.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.GymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.MovesetDefinition;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.PokemonDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public class NPCTrainer
extends EntityNPC {
    private static final DataParameter<Integer> dwEncounterMode = EntityDataManager.func_187226_a(NPCTrainer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dwBossMode = EntityDataManager.func_187226_a(NPCTrainer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dwTrainerLevel = EntityDataManager.func_187226_a(NPCTrainer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dwBattleAI = EntityDataManager.func_187226_a(NPCTrainer.class, (DataSerializer)DataSerializers.field_187192_b);
    private TrainerPartyStorage party = new TrainerPartyStorage(this);
    public boolean usingDefaultName = true;
    public boolean usingDefaultGreeting = true;
    public boolean usingDefaultWin = true;
    public boolean usingDefaultLose = true;
    public String greeting = "";
    public String winMessage = "";
    public String loseMessage = "";
    public int winMoney;
    public int level;
    private String trainerId = "";
    ItemStack[] winnings = new ItemStack[0];
    private boolean startRotationSet = false;
    private float startRotationYaw;
    public boolean isGymLeader = false;
    public boolean canDynamax = false;
    public boolean oldGen = false;
    public HashMap<UUID, Long> playerEncounters = new HashMap();
    public ArrayList<String> winCommands = new ArrayList();
    public ArrayList<String> loseCommands = new ArrayList();
    public ArrayList<String> forfeitCommands = new ArrayList();
    public ArrayList<String> preBattleCommands = new ArrayList();
    public BattleRules battleRules = new BattleRules();
    public BattleControllerBase battleController;

    public NPCTrainer(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(dwEncounterMode, (Object)0);
        this.field_70180_af.func_187214_a(dwBossMode, (Object)0);
        this.field_70180_af.func_187214_a(dwTrainerLevel, (Object)0);
        this.field_70180_af.func_187214_a(dwBattleAI, (Object)0);
    }

    public void init(BaseTrainer trainer) {
        super.init(trainer.name);
        this.party = new TrainerPartyStorage(this);
        TrainerData info = ServerNPCRegistry.trainers.getRandomData(trainer);
        if (info == null) {
            BaseTrainer b = ServerNPCRegistry.trainers.getRandomBaseWithData();
            info = ServerNPCRegistry.trainers.getRandomData(b.name);
        }
        this.chatIndex = info.getRandomChat();
        if (this.usingDefaultName) {
            this.setName("" + info.getRandomName());
        }
        this.trainerId = info.id;
        this.winMoney = info.winnings;
        this.level = info.getRandomLevel();
        if (this.level == 0) {
            this.level = 1;
        }
        this.field_70180_af.func_187227_b(dwTrainerLevel, (Object)this.level);
        this.setBaseTrainer(info.trainerType);
        if (info.trainerType.textures.size() > 1) {
            this.setTextureIndex(this.field_70170_p.field_73012_v.nextInt(info.trainerType.textures.size()));
        }
        this.loadPokemon(info.getRandomParty());
    }

    public void init(GymNPCData trainer, GymInfo info, int tier) {
        super.init(trainer.id);
        this.party = new TrainerPartyStorage(this);
        this.chatIndex = trainer.getRandomTrainerChatIndex();
        this.setName("" + trainer.getRandomNameIndex());
        this.trainerId = trainer.id;
        this.winMoney = trainer.winnings;
        this.level = info.level;
        if (this.level > 0) {
            this.level = Math.min(PixelmonServerConfig.maxLevel, Math.max(1, this.level - tier));
        } else {
            this.setBossMode(EnumBossMode.Equal);
            this.level = 100;
        }
        this.field_70180_af.func_187227_b(dwTrainerLevel, (Object)this.level);
        this.setBaseTrainer(NPCRegistryTrainers.Steve);
        if (trainer.textures.size() > 0) {
            this.setCustomSteveTexture(trainer.getRandomTexture().replaceAll(".png", ""));
            this.setTextureIndex(4);
        }
        int numPokemon = 6;
        if (tier > 0) {
            numPokemon = 1 + this.field_70170_p.field_73012_v.nextInt(numPokemon - tier);
            this.setBattleAIMode(PixelmonConfig.battleAITrainer);
        } else {
            this.setBattleAIMode(EnumBattleAIMode.Advanced);
            this.isGymLeader = true;
        }
        int tries = 0;
        while (this.party.countPokemon() < numPokemon && tries++ < 100) {
            PokemonDefinition p = RandomHelper.getRandomElementFromList(info.pokemon);
            this.initializePokemon(p, this.level, false);
        }
        if (this.party.countPokemon() == 0) {
            this.func_70106_y();
            return;
        }
        this.updateLvl();
    }

    public String getName(String langCode) {
        if (this.usingDefaultName) {
            try {
                int index = Integer.parseInt(this.func_70005_c_());
                return this.getTranslatedData(langCode).getName(index);
            }
            catch (NumberFormatException e) {
                return this.func_70005_c_();
            }
        }
        return this.func_70005_c_();
    }

    public String getGreeting(String langCode) {
        if (this.usingDefaultGreeting) {
            return this.getChat((String)langCode).opening;
        }
        return this.greeting;
    }

    public String getWinMessage(String langCode) {
        if (this.usingDefaultWin) {
            return this.getChat((String)langCode).win;
        }
        return this.winMessage;
    }

    public String getLoseMessage(String langCode) {
        if (this.usingDefaultLose) {
            return this.getChat((String)langCode).lose;
        }
        return this.loseMessage;
    }

    private ITrainerData getTranslatedData(String langCode) {
        return ServerNPCRegistry.getTranslatedData(langCode, this.getBaseTrainer(), this.trainerId);
    }

    public TrainerChat getChat(String langCode) {
        ITrainerData data = this.getTranslatedData(langCode);
        if (data == null) {
            return new TrainerChat("", "", "");
        }
        return data.getChat(this.chatIndex);
    }

    public int getWinMoney() {
        return this.winMoney;
    }

    public void setEncounterMode(EnumEncounterMode mode) {
        this.field_70180_af.func_187227_b(dwEncounterMode, (Object)mode.ordinal());
    }

    public EnumEncounterMode getEncounterMode() {
        return EnumEncounterMode.getFromIndex((Integer)this.field_70180_af.func_187225_a(dwEncounterMode));
    }

    public void setTrainerType(BaseTrainer model, EntityPlayer player) {
        this.init(model);
        this.setTextureIndex(0);
        this.setBaseTrainer(model);
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), playerMP);
        for (Pokemon pokemon : this.party.getTeam()) {
            Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(pokemon), playerMP);
        }
        String loc = playerMP.field_71148_cg;
        this.setName(ServerNPCRegistry.trainers.getTranslatedRandomName(loc, model, this.trainerId));
        SetTrainerData p = new SetTrainerData(this, loc);
        Pixelmon.network.sendTo((IMessage)new SetNPCEditData(p), playerMP);
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        EnumTrainerAI ai = this.getAIMode();
        return ai != EnumTrainerAI.StandStill && ai != EnumTrainerAI.StillAndEngage;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.startRotationSet && this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            this.field_70177_z = this.startRotationYaw;
            this.field_70759_as = this.startRotationYaw;
        }
    }

    @Override
    protected void checkForRarityDespawn() {
        if (this.battleController != null) {
            return;
        }
        super.checkForRarityDespawn();
    }

    public EntityPixelmon releasePokemon(UUID newPokemonUUID) {
        return this.party.find(newPokemonUUID).getOrSpawnPixelmon((Entity)this);
    }

    public void loadPokemon(ArrayList<Pokemon> pokemonList) {
        for (int i = 0; i < 6; ++i) {
            this.party.set(i, null);
        }
        if (pokemonList == null || pokemonList.isEmpty()) {
            this.party.add(new PokemonSpec(EnumSpecies.Rattata.name, "lvl:5").create());
        } else {
            for (Pokemon pokemon : pokemonList) {
                pokemon.setLevel(Math.max(1, RandomHelper.getRandomNumberBetween(this.level - 1, this.level + 1)));
                this.party.add(pokemon);
            }
        }
    }

    private void initializePokemon(PokemonDefinition definition, int level, boolean isDouble) {
        BaseShopItem item;
        MovesetDefinition moves = RandomHelper.getRandomElementFromList(definition.movesets);
        if (level < moves.minLevel || level < definition.minLevel || level > definition.maxLevel) {
            return;
        }
        if (moves.doubleOnly && !isDouble) {
            return;
        }
        Pokemon pokemon = Pixelmon.pokemonFactory.create(new PokemonSpec(definition.pokemon.name, "form:" + moves.form, "lvl:" + Math.max(1, Math.min(PixelmonServerConfig.maxLevel, RandomHelper.getRandomNumberBetween(level - 1, level + 1)))));
        if (this.isGymLeader) {
            pokemon.getEVs().attack = moves.evAtk;
            pokemon.getEVs().attack = moves.evAtk;
            pokemon.getEVs().defence = moves.evDef;
            pokemon.getEVs().hp = moves.evHP;
            pokemon.getEVs().specialAttack = moves.evSpAtk;
            pokemon.getEVs().specialDefence = moves.evSpDef;
            pokemon.getEVs().speed = moves.evSpeed;
            pokemon.getIVs().attack = moves.ivAtk;
            pokemon.getIVs().defence = moves.ivDef;
            pokemon.getIVs().hp = moves.ivHP;
            pokemon.getIVs().specialAttack = moves.ivSpAtk;
            pokemon.getIVs().specialDefence = moves.ivSpDef;
            pokemon.getIVs().speed = moves.ivSpeed;
            if (moves.nature != null && moves.nature.length > 0) {
                pokemon.setNature(RandomHelper.getRandomElementFromArray(moves.nature));
            }
        }
        pokemon.setHealth(pokemon.getMaxHealth());
        if (moves.ability != null && moves.ability.length > 0) {
            pokemon.setAbility(RandomHelper.getRandomElementFromArray(moves.ability));
        } else {
            ArrayList<String> randomAbilities = new ArrayList<String>();
            for (String ability : pokemon.getBaseStats().abilities) {
                if (ability == null) continue;
                randomAbilities.add(ability);
            }
            if (!randomAbilities.isEmpty()) {
                pokemon.setAbility(AbilityBase.getAbility((String)RandomHelper.getRandomElementFromList(randomAbilities)).get());
            }
        }
        if (moves.heldItem != null && moves.heldItem.length > 0 && (item = ServerNPCRegistry.shopkeepers.getItem(RandomHelper.getRandomElementFromArray(moves.heldItem))) != null) {
            item.getItem().func_190920_e(1);
            pokemon.setHeldItem(item.getItem().func_77946_l());
        }
        pokemon.setFriendship(255);
        Moveset moveset = pokemon.getMoveset();
        moveset.clear();
        this.addGymTrainerMove(moves.move1, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move2, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move3, pokemon, moves.ivsDefined);
        this.addGymTrainerMove(moves.move4, pokemon, moves.ivsDefined);
        this.party.add(pokemon);
        int pos = ((StoragePosition)this.party.find((UUID)pokemon.getUUID()).getStorageAndPosition().func_76340_b()).order;
        if (moves.lead && pos != 0) {
            this.party.swap(pos, 0);
        }
        this.calculateGen();
    }

    private void addGymTrainerMove(String[] possibleMoves, Pokemon pokemon, boolean ivsDefined) {
        if (possibleMoves != null && possibleMoves.length > 0) {
            Attack attack;
            Moveset moveset = pokemon.getMoveset();
            int randomIndex = this.field_70170_p.field_73012_v.nextInt(possibleMoves.length);
            String selectedMove = possibleMoves[randomIndex];
            EnumType hiddenPowerType = null;
            if (selectedMove.contains("Hidden Power")) {
                if (!ivsDefined) {
                    hiddenPowerType = EnumType.parseType(selectedMove.replace("Hidden Power ", ""));
                }
                selectedMove = "Hidden Power";
            }
            if ((attack = new Attack(selectedMove)) != null && !moveset.contains(attack)) {
                moveset.add(attack);
                if (hiddenPowerType != null) {
                    pokemon.getIVs().CopyIVs(HiddenPower.getOptimalIVs(hiddenPowerType));
                }
            } else {
                String[] reducedPossible = (String[])ArrayUtils.remove((Object[])possibleMoves, (int)randomIndex);
                this.addGymTrainerMove(reducedPossible, pokemon, ivsDefined);
            }
        }
    }

    public void startBattle(BattleParticipant battleParticipant) {
        this.calculateGen();
        if (battleParticipant instanceof PlayerParticipant) {
            PlayerParticipant player = (PlayerParticipant)battleParticipant;
            EnumEncounterMode encounterMode = this.getEncounterMode();
            if (encounterMode == EnumEncounterMode.OncePerMCDay) {
                this.playerEncounters.put(player.player.func_110124_au(), this.field_70170_p.func_82737_E());
            } else if (encounterMode == EnumEncounterMode.OncePerDay) {
                this.playerEncounters.put(player.player.func_110124_au(), System.currentTimeMillis());
            }
            String loc = ((EntityPlayerMP)player.getEntity()).field_71148_cg;
            if (this.getGreeting(loc) != null) {
                ChatHandler.sendBattleMessage((Entity)player.player, this.getName(loc) + ": " + this.getGreeting(loc), new Object[0]);
            }
        }
        this.healAllPokemon();
    }

    public boolean calculateGen() {
        this.oldGen = this.party.isOldGen(this.field_71093_bK);
        return this.oldGen;
    }

    public void loseBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getLoseMessage(langCode = ((EntityPlayerMP)opponents.get((int)0).getEntity()).field_71148_cg) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getLoseMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            EntityPlayerMP player = (EntityPlayerMP)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new BeatTrainerEvent(player, this));
            if (this.getEncounterMode() == EnumEncounterMode.Once) {
                this.func_70623_bb();
                this.func_70106_y();
            } else {
                this.healAllPokemon();
                if (this.getEncounterMode() == EnumEncounterMode.OncePerPlayer) {
                    this.playerEncounters.put(player.func_110124_au(), this.field_70170_p.func_82737_E());
                }
            }
            if (player.field_70170_p.func_152378_a(player.func_110124_au()) == null) {
                return;
            }
            if (this.winMoney > 0) {
                int calculatedWinMoney = this.winMoney * this.party.getAverageLevel();
                if (!this.func_70692_ba()) {
                    calculatedWinMoney = this.winMoney;
                }
                PlayerParticipant playerParticipant = (PlayerParticipant)opponents.get(0);
                calculatedWinMoney *= playerParticipant.getPrizeMoneyMultiplier();
                IPixelmonBankAccount account = Pixelmon.moneyManager.getBankAccount(playerParticipant.player).orElse(null);
                if (account != null) {
                    account.changeMoney(calculatedWinMoney);
                    if (playerParticipant.bc == null) {
                        ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.field_71148_cg));
                    } else {
                        ChatHandler.sendBattleMessage((Entity)playerParticipant.getEntity(), "pixelmon.entitytrainer.winnings", "" + calculatedWinMoney, this.getName(player.field_71148_cg));
                    }
                }
            }
            if (this.winnings.length > 0) {
                ArrayList<DroppedItem> drops = new ArrayList<DroppedItem>();
                int id = 0;
                for (ItemStack item : this.winnings) {
                    if (item.func_190916_E() == 0) {
                        item.func_190920_e(1);
                    }
                    drops.add(new DroppedItem(item.func_77946_l(), id++));
                }
                DropItemQueryList.register(this, drops, player);
            }
            if (this.getBaseTrainer() != null && this.getBaseTrainer().name.equals("Fisherman")) {
                int number = RandomHelper.getRandomNumberBetween(1, 100);
                int number2 = RandomHelper.getRandomNumberBetween(1, 1000);
                if (number == 43) {
                    DropItemHelper.giveItemStack(player, new ItemStack(PixelmonItems.goodRod), false);
                    ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, "pixelmon.entitytrainer.goodrod", new Object[0]);
                } else if (number2 == 564) {
                    DropItemHelper.giveItemStack(player, new ItemStack(PixelmonItems.superRod), false);
                    ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, "pixelmon.entitytrainer.superrod", new Object[0]);
                }
            }
        }
    }

    public void winBattle(ArrayList<BattleParticipant> opponents) {
        String langCode;
        if (opponents.get(0) instanceof PlayerParticipant && this.getWinMessage(langCode = ((EntityPlayerMP)opponents.get((int)0).getEntity()).field_71148_cg) != null) {
            ChatHandler.sendBattleMessage(opponents, this.getWinMessage(langCode), new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            EntityPlayerMP player = (EntityPlayerMP)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new LostToTrainerEvent(player, this));
        }
    }

    public void healAllPokemon() {
        this.party.getTeam().forEach(pokemon -> pokemon.heal());
    }

    public UUID getNextPokemonUUID() {
        Pokemon pokemon = this.party.findOne(p -> !p.isEgg() && p.getPixelmonIfExists() == null);
        return pokemon == null ? null : pokemon.getUUID();
    }

    public int getLvl() {
        return (Integer)this.field_70180_af.func_187225_a(dwTrainerLevel);
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemNPCEditor) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (!ItemNPCEditor.checkPermission((EntityPlayer)playerMP)) {
                    return false;
                }
                this.ignoreDespawnCounter = true;
                this.field_70714_bg.field_75782_a.clear();
                this.party.sendCacheToPlayer(playerMP);
                String loc = playerMP.field_71148_cg;
                SetTrainerData p = new SetTrainerData(this, loc);
                Pixelmon.network.sendTo((IMessage)new SetNPCEditData(p), playerMP);
                if (BattleClauseRegistry.getClauseVersion() > 0) {
                    Pixelmon.network.sendTo((IMessage)new UpdateClientRules(), playerMP);
                }
                OpenScreen.open(player, EnumGuiScreen.TrainerEditor, this.getId());
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagCompound pokemonNbt = new NBTTagCompound();
        this.party.writeToNBT(pokemonNbt);
        nbt.func_74782_a("pokeStore", (NBTBase)pokemonNbt);
        nbt.func_74777_a("BossMode", (short)this.getBossMode().index);
        nbt.func_74778_a("Greeting", this.greeting);
        nbt.func_74778_a("WinMessage", this.winMessage);
        nbt.func_74778_a("LoseMessage", this.loseMessage);
        NBTTagCompound tmpWinnings = new NBTTagCompound();
        for (int i = 0; i < this.winnings.length; ++i) {
            NBTTagCompound itemTag = new NBTTagCompound();
            if (this.winnings[i] == null) continue;
            this.winnings[i].func_77955_b(itemTag);
            tmpWinnings.func_74782_a("item" + i, (NBTBase)itemTag);
        }
        nbt.func_74768_a("NPCLevel", this.level);
        nbt.func_74768_a("WinMoney", this.winMoney);
        nbt.func_74782_a("WinningsTag", (NBTBase)tmpWinnings);
        EnumEncounterMode mode = this.getEncounterMode();
        nbt.func_74777_a("EncMode", (short)mode.ordinal());
        if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<UUID, Long> entry : this.playerEncounters.entrySet()) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_186854_a("UUID", entry.getKey());
                if (mode != EnumEncounterMode.OncePerPlayer) {
                    nBTTagCompound.func_74772_a("time", entry.getValue().longValue());
                }
                list.func_74742_a((NBTBase)nBTTagCompound);
            }
            nbt.func_74782_a("Encounters", (NBTBase)list);
        }
        nbt.func_74777_a("BattleAIMode", (short)this.getBattleAIMode().ordinal());
        nbt.func_74757_a("DefaultName", this.usingDefaultName);
        nbt.func_74757_a("DefaultWin", this.usingDefaultWin);
        nbt.func_74757_a("DefaultLose", this.usingDefaultLose);
        nbt.func_74757_a("DefaultGreet", this.usingDefaultGreeting);
        nbt.func_74778_a("TrainerIndex", this.trainerId);
        nbt.func_74768_a("ChatIndex", this.chatIndex);
        nbt.func_74757_a("canDynamax", this.canDynamax);
        nbt.func_74757_a("oldGen", this.oldGen);
        if (this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            nbt.func_74776_a("TrainerRotation", this.startRotationYaw);
        }
        nbt.func_74757_a("GymLeader", this.isGymLeader);
        this.battleRules.writeToNBT(nbt);
        NBTTagCompound commandsNbt = nbt.func_74775_l("Commands");
        NBTTagList winList = new NBTTagList();
        for (String string : this.winCommands) {
            winList.func_74742_a((NBTBase)new NBTTagString(string));
        }
        commandsNbt.func_74782_a("winCommands", (NBTBase)winList);
        NBTTagList nBTTagList = new NBTTagList();
        for (String string : this.loseCommands) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagString(string));
        }
        commandsNbt.func_74782_a("loseCommands", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (String forfeitCommand : this.forfeitCommands) {
            nBTTagList2.func_74742_a((NBTBase)new NBTTagString(forfeitCommand));
        }
        commandsNbt.func_74782_a("forfeitCommands", (NBTBase)nBTTagList2);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (String preBattleCommand : this.preBattleCommands) {
            nBTTagList3.func_74742_a((NBTBase)new NBTTagString(preBattleCommand));
        }
        commandsNbt.func_74782_a("preBattleCommands", (NBTBase)nBTTagList3);
        nbt.func_74782_a("Commands", (NBTBase)commandsNbt);
    }

    public boolean canStartBattle(EntityPlayer opponent, boolean printMessages) {
        if (this.battleController != null) {
            if (printMessages) {
                ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.inbattle", new Object[0]);
            }
            return false;
        }
        Long lastEncounter = this.playerEncounters.get(opponent.func_110124_au());
        if (lastEncounter != null) {
            EnumEncounterMode mode = this.getEncounterMode();
            if (mode == EnumEncounterMode.OncePerDay) {
                long oldTime;
                long oldDay;
                long curTime = System.currentTimeMillis();
                long curDay = curTime / 86400000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 86400000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerMCDay) {
                long oldTime;
                long oldDay;
                long curTime = this.field_70170_p.func_82737_E();
                long curDay = curTime / 24000L;
                if (curDay <= (oldDay = (oldTime = lastEncounter.longValue()) / 24000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.oncemcday", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerPlayer) {
                if (printMessages) {
                    ChatHandler.sendChat((Entity)opponent, "pixelmon.entitytrainer.onceplayer", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("DefaultName")) {
            this.usingDefaultName = nbt.func_74767_n("DefaultName");
            this.usingDefaultWin = nbt.func_74767_n("DefaultWin");
            this.usingDefaultLose = nbt.func_74767_n("DefaultLose");
            this.usingDefaultGreeting = nbt.func_74767_n("DefaultGreet");
            this.trainerId = nbt.func_74779_i("TrainerIndex");
            this.chatIndex = nbt.func_74762_e("ChatIndex");
        }
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("BossMode")) {
            this.setBossMode(EnumBossMode.getMode(nbt.func_74765_d("BossMode")));
        }
        this.party.readFromNBT(nbt.func_74775_l("pokeStore"));
        if (nbt.func_74764_b("Greeting")) {
            this.greeting = nbt.func_74779_i("Greeting");
            this.winMessage = nbt.func_74779_i("WinMessage");
            this.loseMessage = nbt.func_74779_i("LoseMessage");
        }
        if (nbt.func_74764_b("oldGen")) {
            this.oldGen = nbt.func_74767_n("oldGen");
        }
        if (nbt.func_74764_b("canDynamax")) {
            this.canDynamax = nbt.func_74767_n("canDynamax");
        }
        if (nbt.func_74764_b("WinningsTag")) {
            NBTTagCompound tag = nbt.func_74775_l("WinningsTag");
            this.winnings = new ItemStack[tag.func_150296_c().size()];
            int index = 0;
            for (String key : tag.func_150296_c()) {
                this.winnings[index++] = new ItemStack(tag.func_74775_l(key));
            }
        } else if (nbt.func_74764_b("Winnings")) {
            int[] testArray = nbt.func_74759_k("Winnings");
            ArrayList<Item> array = new ArrayList<Item>();
            for (int aTestArray : testArray) {
                array.add(Item.func_150899_d((int)aTestArray));
            }
            this.winnings = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.winnings[i] = new ItemStack((Item)array.get(i));
            }
        }
        if (nbt.func_74764_b("TrainerRotation")) {
            this.setStartRotationYaw(nbt.func_74760_g("TrainerRotation"));
        }
        if (nbt.func_74764_b("EncMode")) {
            EnumEncounterMode mode = EnumEncounterMode.getFromIndex(nbt.func_74765_d("EncMode"));
            this.setEncounterMode(mode);
            this.playerEncounters.clear();
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.func_74764_b("numEncounters")) {
                int numEncounters = nbt.func_74762_e("numEncounters");
                for (int i = 0; i < numEncounters; ++i) {
                    String uuid = nbt.func_74779_i("encPl" + i);
                    long time = 0L;
                    if (mode != EnumEncounterMode.OncePerPlayer) {
                        long oldDay;
                        long curDay;
                        time = nbt.func_74763_f("encTi" + i);
                        if (mode == EnumEncounterMode.OncePerDay) {
                            curDay = System.currentTimeMillis() / 86400000L;
                            if (curDay > (oldDay = time / 86400000L)) continue;
                            this.playerEncounters.put(UUID.fromString(uuid), time);
                            continue;
                        }
                        if (mode != EnumEncounterMode.OncePerMCDay || (curDay = this.field_70170_p.func_82737_E() / 24000L) > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(UUID.fromString(uuid), time);
                        continue;
                    }
                    this.playerEncounters.put(UUID.fromString(uuid), 0L);
                }
            }
            if (mode != EnumEncounterMode.Once && mode != EnumEncounterMode.Unlimited && nbt.func_74764_b("Encounters")) {
                NBTTagList list = nbt.func_150295_c("Encounters", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    long oldDay;
                    long curDay;
                    long time;
                    NBTTagCompound compound = list.func_150305_b(i);
                    UUID uuid = compound.func_186857_a("UUID");
                    long l = time = mode != EnumEncounterMode.OncePerPlayer ? compound.func_74763_f("time") : 0L;
                    if (mode == EnumEncounterMode.OncePerDay) {
                        curDay = System.currentTimeMillis() / 86400000L;
                        if (curDay > (oldDay = time / 86400000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    if (mode == EnumEncounterMode.OncePerMCDay) {
                        curDay = this.field_70170_p.func_82737_E() / 24000L;
                        if (curDay > (oldDay = time / 24000L)) continue;
                        this.playerEncounters.put(uuid, time);
                        continue;
                    }
                    this.playerEncounters.put(uuid, 0L);
                }
            }
        } else {
            this.setEncounterMode(EnumEncounterMode.Once);
        }
        if (nbt.func_74764_b("BattleAIMode")) {
            this.setBattleAIMode(EnumBattleAIMode.getFromIndex(nbt.func_74765_d("BattleAIMode")));
        }
        if (nbt.func_74764_b("NPCLevel")) {
            this.level = nbt.func_74762_e("NPCLevel");
            this.field_70180_af.func_187227_b(dwTrainerLevel, (Object)this.level);
            this.updateLvl();
        }
        if (nbt.func_74764_b("Commands")) {
            NBTTagCompound cmdNbt = nbt.func_74775_l("Commands");
            if (cmdNbt.func_74764_b("winCommands")) {
                NBTTagList wins = cmdNbt.func_150295_c("winCommands", 8);
                for (int i = 0; i < wins.func_74745_c(); ++i) {
                    this.winCommands.add(wins.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("loseCommands")) {
                NBTTagList loss = cmdNbt.func_150295_c("loseCommands", 8);
                for (int i = 0; i < loss.func_74745_c(); ++i) {
                    this.loseCommands.add(loss.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("forfeitCommands")) {
                NBTTagList forfeit = cmdNbt.func_150295_c("forfeitCommands", 8);
                for (int i = 0; i < forfeit.func_74745_c(); ++i) {
                    this.forfeitCommands.add(forfeit.func_150307_f(i));
                }
            }
            if (cmdNbt.func_74764_b("preBattleCommands")) {
                NBTTagList preBattle = cmdNbt.func_150295_c("preBattleCommands", 8);
                for (int i = 0; i < preBattle.func_74745_c(); ++i) {
                    this.preBattleCommands.add(preBattle.func_150307_f(i));
                }
            }
        }
        if (nbt.func_74764_b("WinMoney")) {
            this.winMoney = nbt.func_74762_e("WinMoney");
        }
        if (nbt.func_74764_b("GymLeader")) {
            this.isGymLeader = nbt.func_74767_n("GymLeader");
        }
        this.battleRules.readFromNBT(nbt);
        if (nbt.func_74764_b("BattleType")) {
            this.battleRules.battleType = EnumBattleType.values()[nbt.func_74765_d("BattleType")];
            nbt.func_82580_o("BattleType");
        }
        this.updateLvl();
    }

    public void randomisePokemon(EntityPlayer player) {
        ArrayList<Pokemon> randomParty;
        BaseTrainer base = this.getBaseTrainer();
        if (base.name.equals("Steve")) {
            int partySize = RandomHelper.getRandomNumberBetween(1, 6);
            randomParty = new ArrayList(partySize);
            for (int i = 0; i < partySize; ++i) {
                randomParty.add(new PokemonSpec(EnumSpecies.randomPoke().name).create());
            }
            this.level = RandomHelper.getRandomNumberBetween(2, 99);
        } else {
            TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
            randomParty = data.getRandomParty();
        }
        this.loadPokemon(randomParty);
        this.updateLvl();
        Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), (EntityPlayerMP)player);
        for (Pokemon pokemon : this.party.getTeam()) {
            Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(pokemon), (EntityPlayerMP)player);
        }
    }

    @Override
    public EnumBossMode getBossMode() {
        return EnumBossMode.getMode((Integer)this.field_70180_af.func_187225_a(dwBossMode));
    }

    public void setBossMode(EnumBossMode mode) {
        this.field_70180_af.func_187227_b(dwBossMode, (Object)mode.index);
    }

    public EnumBattleAIMode getBattleAIMode() {
        return EnumBattleAIMode.getFromIndex((Integer)this.field_70180_af.func_187225_a(dwBattleAI));
    }

    public void setBattleAIMode(EnumBattleAIMode mode) {
        if (mode != null) {
            this.field_70180_af.func_187227_b(dwBattleAI, (Object)mode.ordinal());
        }
    }

    public EnumBattleType getBattleType() {
        return this.battleRules.battleType;
    }

    @Deprecated
    public void setBattleType(EnumBattleType type) {
        this.battleRules.battleType = type;
    }

    public void updateLvl() {
        int lvlTotal = 0;
        int count = 0;
        for (Pokemon pokemon : this.party.getTeam()) {
            lvlTotal += pokemon.getLevel();
            ++count;
        }
        this.field_70180_af.func_187227_b(dwTrainerLevel, (Object)(lvlTotal / count));
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, SharedMonsterAttributes.field_111263_d.func_111110_b()));
                break;
            }
            case StillAndEngage: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIExecuteAction(this));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITargetNearest(this, 10.0f, true));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMoveTowardsTarget(this, 10.0f));
                break;
            }
            case WanderAndEngage: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIExecuteAction(this));
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveTowardsTarget(this, 10.0f));
                this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AITargetNearest(this, 10.0f, true));
            }
        }
    }

    public void update(SetTrainerData p) {
        if (!p.greeting.equals("")) {
            this.greeting = p.greeting;
            this.usingDefaultGreeting = false;
        }
        if (!p.lose.equals("")) {
            this.loseMessage = p.lose;
            this.usingDefaultLose = false;
        }
        if (!p.win.equals("")) {
            this.winMessage = p.win;
            this.usingDefaultWin = false;
        }
        this.winMoney = p.winMoney;
        if (p.rules != null) {
            this.battleRules = p.rules;
        }
    }

    public void setStartRotationYaw(float f) {
        this.startRotationSet = true;
        this.startRotationYaw = f;
        this.field_70177_z = f;
        this.field_70759_as = f;
    }

    @Override
    public String getDisplayText() {
        String s = "boss";
        if (this.getBossMode() == EnumBossMode.NotBoss) {
            s = "" + this.getLvl();
        }
        return s;
    }

    @Override
    public String getSubTitleText() {
        return I18n.func_74838_a((String)"gui.screenpokechecker.lvl");
    }

    public void setBattleController(BattleControllerBase battleController) {
        this.battleController = battleController;
    }

    public BattleControllerBase getBattleController() {
        return this.battleController;
    }

    public TrainerPartyStorage getPokemonStorage() {
        return this.party;
    }

    public EntityLiving getEntity() {
        return this;
    }

    public void setAttackTargetPix(EntityLivingBase entity) {
        this.func_70624_b(entity);
    }

    public void updateDrops(ItemStack[] drops) {
        this.winnings = drops;
    }

    public ItemStack[] getWinnings() {
        return this.winnings;
    }

    public void setLevel(int level) {
        this.level = level;
        this.field_70180_af.func_187227_b(dwTrainerLevel, (Object)level);
        BaseTrainer base = this.getBaseTrainer();
        TrainerData data = ServerNPCRegistry.trainers.getRandomData(base);
        this.loadPokemon(data.getRandomParty());
    }
}

