/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.IHasTexture;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.Transform;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumGastrodon;
import com.pixelmonmod.pixelmon.enums.forms.EnumMagikarp;
import com.pixelmonmod.pixelmon.enums.forms.EnumSpecial;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Vector3d;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Entity2Client
extends Entity1Base
implements IHasTexture {
    static final DataParameter<Float> dwScale = EntityDataManager.func_187226_a(Entity2Client.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Boolean> dwShiny = EntityDataManager.func_187226_a(Entity2Client.class, (DataSerializer)DataSerializers.field_187198_h);
    static final DataParameter<String> dwCustomTexture = EntityDataManager.func_187226_a(Entity2Client.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwTransformation = EntityDataManager.func_187226_a(Entity2Client.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Float> dwDynamaxScale = EntityDataManager.func_187226_a(Entity2Client.class, (DataSerializer)DataSerializers.field_187193_c);
    public static float maxScale = 1.25f;
    private static final int animationFlyingDelayLimit = 10;
    private static final int animationDelayLimit = 3;
    static int flyingDelayLimit = 10;
    public PokemonBase transformed = null;
    public ResourceLocation transformedTexture = null;
    boolean animationFlyingCounting = false;
    boolean animationFlyingSwap = false;
    boolean animationCounting = false;
    boolean animationSwap = false;
    int animationFlyingDelayCounter = 0;
    int animationDelayCounter = 0;
    int flyingDelayCounter = 0;
    private AnimationVariables animationVariables;
    private AnimationType animationType;
    private ResourceLocation lastTexture;
    private boolean exists = true;
    private ResourceLocation lastSprite;
    private boolean spriteExists = true;
    public static final float DYNAMAX_SCALE_MINIMUM = 1.0f;
    public float dynamaxScale = 1.0f;
    public int evolvingVal = 0;
    public int evoAnimTicks = 0;
    public EvolutionStage evoStage = null;
    public int fadeCount = 0;
    private boolean fadeDirection = true;
    public float heightDiff;
    public float widthDiff;
    public float lengthDiff;

    public Entity2Client(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(dwScale, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dwShiny, (Object)false);
        this.field_70180_af.func_187214_a(dwCustomTexture, (Object)"");
        this.field_70180_af.func_187214_a(dwTransformation, (Object)0);
        this.field_70180_af.func_187214_a(dwDynamaxScale, (Object)Float.valueOf(1.0f));
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        if (this.transformedTexture != null) {
            return this.transformedTexture;
        }
        ResourceLocation location = this.getRealTexture();
        if (!Objects.equals(this.lastTexture, location)) {
            this.lastTexture = location;
            this.exists = Pixelmon.proxy.resourceLocationExists(location);
        }
        return this.exists ? location : Entity2Client.getOGTexture(this.getSpecies(), this.pokemon.getFormEnum(), this.getPokemonData().getGender(), this.getPokemonData().isShiny());
    }

    public ResourceLocation getTextureNoCheck() {
        if (this.transformedTexture != null) {
            return this.transformedTexture;
        }
        return this.getRealTexture();
    }

    public ResourceLocation getRealTexture() {
        EnumSpecies pokemon = this.getSpecies();
        return Entity2Client.getTextureFor(pokemon, this.pokemon.getFormEnum(), this.pokemon.getGender(), this.pokemon.getCustomTexture(), this.pokemon.isShiny());
    }

    public String getExtraTexture() {
        return (String)this.field_70180_af.func_187225_a(dwCustomTexture);
    }

    public ResourceLocation getSprite() {
        Pokemon pokemon = this.getPokemonData();
        ResourceLocation location = GuiResources.getPokemonSprite(pokemon.getSpecies(), pokemon.getForm(), pokemon.getGender(), pokemon.getCustomTexture(), pokemon.isShiny());
        if (!Objects.equals(this.lastSprite, location)) {
            this.lastSprite = location;
            this.spriteExists = Pixelmon.proxy.resourceLocationExists(location);
        }
        return this.spriteExists ? location : GuiResources.getPokemonSprite(pokemon.getSpecies(), pokemon.getForm(), pokemon.getGender(), "", pokemon.isShiny());
    }

    public void evolve(PokemonSpec evolveTo) {
        if (!EnumSpecies.hasPokemon(evolveTo.name)) {
            return;
        }
        if (this.getPokemonData().getSpecies() == EnumSpecies.Magikarp && this.getPokemonData().getFormEnum() == EnumMagikarp.ROASTED) {
            this.getPokemonData().setForm(EnumSpecial.Zombie);
        }
        if (this.getPokemonData().getSpecies() == EnumSpecies.Shellos) {
            if (this.getPokemonData().getForm() % 2 == 0) {
                this.getPokemonData().setForm(EnumGastrodon.East);
            } else {
                this.getPokemonData().setForm(EnumGastrodon.West);
            }
        }
        this.pokemon.setSpecies(EnumSpecies.getFromName(evolveTo.name).orElse(EnumSpecies.Bulbasaur));
        this.update(EnumUpdateType.Name, EnumUpdateType.Nickname);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel() {
        if (this.transformed != null) {
            return PixelmonModelRegistry.getModel(this.transformed);
        }
        if (PixelmonModelRegistry.hasFlyingModel(this.getSpecies(), this.pokemon.getFormEnum()) && this.flyingDelayCounter >= flyingDelayLimit) {
            return PixelmonModelRegistry.getFlyingModel(this.getSpecies(), this.pokemon.getFormEnum());
        }
        return PixelmonModelRegistry.getModel(this.getSpecies(), this.pokemon.getFormEnum());
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3d getModelSize() {
        return PixelmonModelRegistry.getModelSize(this.getPokemonData());
    }

    private boolean isBufferComplete(Framebuffer framebuffer) {
        try {
            framebuffer.func_147611_b();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void transform(EnumSpecies transformedModel, int transformedForm, String transformedTexture) {
        this.transformed = new PokemonBase(transformedModel, transformedForm, Gender.Male);
        this.transformedTexture = new ResourceLocation(transformedTexture);
    }

    public void cancelTransform() {
        this.transformed = null;
        this.transformedTexture = null;
        this.updateTransformed();
    }

    public void updateTransformed() {
        Transform transform = this.transformed != null ? new Transform(this.func_145782_y(), this.transformed.getSpecies(), this.transformedTexture.toString(), this.transformed.getForm()) : new Transform(this.func_145782_y(), this.pokemon.getSpecies(), this.getRealTexture().toString(), this.pokemon.getForm());
        Pixelmon.network.sendToAll((IMessage)transform);
    }

    public void transformServer(EnumSpecies transformedModel, int form, String texture) {
        this.transformed = new PokemonBase(transformedModel, form, Gender.Male);
        this.transformedTexture = new ResourceLocation(texture);
        this.updateTransformed();
    }

    public int getTransformed() {
        return (Integer)this.field_70180_af.func_187225_a(dwTransformation);
    }

    public float getScaleFactor() {
        return (float)Math.pow(this.getPokemonData().getGrowth().scaleValue, PixelmonConfig.getGrowthModifier()) * this.getBossMode().scaleFactor * this.getDynamaxScale();
    }

    public float getPixelmonScale() {
        return ((Float)this.field_70180_af.func_187225_a(dwScale)).floatValue();
    }

    public void setPixelmonScale(float scale) {
        this.field_70180_af.func_187227_b(dwScale, (Object)Float.valueOf(scale));
    }

    public float getDynamaxScale() {
        return ((Float)this.field_70180_af.func_187225_a(EntityPixelmon.dwDynamaxScale)).floatValue();
    }

    public void setDynamaxScale(float scale) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwDynamaxScale, (Object)Float.valueOf(Math.max(1.0f, scale)));
    }

    public void addDynamaxScale(float scale) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwDynamaxScale, (Object)Float.valueOf(this.getDynamaxScale() + scale));
    }

    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    public void initAnimation() {
        ModelBase base;
        if (this.field_70170_p.field_72995_K && (base = this.getModel()) instanceof PixelmonModelSmd) {
            ValveStudioModel model = ((PixelmonModelSmd)base).theModel;
            model.animate();
        }
    }

    public void checkAnimation() {
        IncrementingVariable inc;
        if (!(this.getModel() instanceof PixelmonModelSmd)) {
            return;
        }
        PixelmonModelSmd smdModel = (PixelmonModelSmd)this.getModel();
        Entity3HasStats pixelmon = (Entity3HasStats)this;
        float f1 = pixelmon.field_184618_aE + (pixelmon.field_70721_aZ - pixelmon.field_184618_aE) * 1.0f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((inc = this.getAnimationVariables().getCounter(-1)) == null) {
            this.getAnimationVariables().setCounter(-1, 2.1474836E9f, smdModel.animationIncrement);
        } else {
            inc.increment = smdModel.animationIncrement;
        }
        if (!pixelmon.animationCounting) {
            this.setAnimation(AnimationType.IDLE);
            pixelmon.animationCounting = true;
        }
        if (pixelmon.func_70090_H()) {
            if (f1 > smdModel.movementThreshold) {
                if (pixelmon.animationSwap) {
                    this.setAnimation(AnimationType.SWIM);
                }
            } else if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.IDLE_SWIM);
            }
        } else if (!pixelmon.field_70122_E || pixelmon.getBaseStats().hovers() && f1 > smdModel.movementThreshold) {
            if (!pixelmon.animationFlyingSwap) {
                pixelmon.animationFlyingCounting = true;
            }
            if (pixelmon.animationFlyingSwap) {
                this.setAnimation(AnimationType.FLY);
            }
        } else if (f1 > smdModel.movementThreshold) {
            if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.WALK);
            }
        } else if (pixelmon.animationSwap) {
            this.setAnimation(AnimationType.IDLE);
        }
        if (smdModel.theModel.currentSequence == null) {
            this.setAnimation(AnimationType.IDLE);
        }
    }

    public void setAnimation(AnimationType animation) {
        this.animationType = animation;
    }

    public AnimationType getCurrentAnimation() {
        if (this.animationType == null) {
            return AnimationType.IDLE;
        }
        return this.animationType;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70122_E && !this.field_70171_ac) {
            if (this.flyingDelayCounter < flyingDelayLimit) {
                ++this.flyingDelayCounter;
            }
        } else {
            this.flyingDelayCounter = 0;
        }
        if (this.field_70170_p.field_72995_K) {
            if (!this.func_82150_aj()) {
                for (ParticleEffects particleEffect : ParticleEffects.getParticleEffects(this)) {
                    particleEffect.onUpdate(this);
                }
            }
            this.tickEvolveAnimation();
            if (this.animationVariables != null) {
                this.animationVariables.tick();
            }
            if (this.animationFlyingCounting) {
                if (this.animationFlyingDelayCounter < 10) {
                    ++this.animationFlyingDelayCounter;
                    this.animationFlyingSwap = false;
                }
                if (this.animationFlyingDelayCounter >= 10) {
                    this.animationFlyingSwap = true;
                    this.animationFlyingDelayCounter = 0;
                }
            } else {
                this.animationFlyingDelayCounter = 0;
                this.animationFlyingSwap = false;
            }
            if (this.animationCounting) {
                if (this.animationDelayCounter < 3) {
                    ++this.animationDelayCounter;
                    this.animationSwap = false;
                }
                if (this.animationDelayCounter >= 3) {
                    this.animationSwap = true;
                    this.animationDelayCounter = 0;
                }
            } else {
                this.animationDelayCounter = 0;
                this.animationSwap = false;
            }
            if (this instanceof EntityPixelmon) {
                try {
                    this.checkAnimation();
                }
                catch (NullPointerException npe) {
                    System.out.println(this.func_70005_c_());
                }
            }
        }
    }

    public boolean isEvolving() {
        return this.evoStage != null && this.evoStage != EvolutionStage.End;
    }

    public void setEvolutionAnimationStage(EvolutionStage stage) {
        if (stage == EvolutionStage.End) {
            this.evoStage = null;
            this.func_70105_a(this.getBaseStats().width.floatValue(), this.getBaseStats().height.floatValue() + (float)(this.getBaseStats().hovers() ? 1 : 0));
        } else {
            this.evoStage = stage;
            this.evoAnimTicks = 0;
            if (stage == EvolutionStage.PreChoice) {
                this.fadeCount = 20;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickEvolveAnimation() {
        ++this.evoAnimTicks;
        if (this.evoStage == null) {
            return;
        }
        ++this.evoAnimTicks;
        if (this.evoStage == EvolutionStage.Choice) {
            if (this.fadeDirection) {
                ++this.fadeCount;
                if (this.fadeCount >= 20) {
                    this.fadeDirection = false;
                }
            } else {
                --this.fadeCount;
                if (this.fadeCount <= 0) {
                    this.fadeDirection = true;
                }
            }
        } else if (this.evoStage == EvolutionStage.PreAnimation) {
            if (this.fadeDirection) {
                if (this.fadeCount < 20) {
                    ++this.fadeCount;
                }
            } else if (this.fadeCount > 0 && this.fadeCount <= 0) {
                this.fadeDirection = true;
            }
        }
        if (this.evoStage == EvolutionStage.Choice || this.evoStage == EvolutionStage.PreAnimation) {
            Random random = this.func_70681_au();
            int numEffects = random.nextInt(10);
            for (int i = 0; i < numEffects; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)((random.nextFloat() * 2.2f - 1.0f) * this.getBaseStats().width.floatValue()), this.field_70163_u + (double)((random.nextFloat() * 2.2f - 1.0f) * this.getBaseStats().height.floatValue()), this.field_70161_v + (double)((random.nextFloat() * 2.2f - 1.0f) * this.getBaseStats().length.floatValue()), 255.0, 255.0, 255.0, new int[0]);
            }
        }
        if (this.evoStage == EvolutionStage.PreAnimation || this.evoStage == EvolutionStage.PostAnimation) {
            if (this.evoStage == EvolutionStage.PreAnimation) {
                if (this.evoAnimTicks > EvolutionStage.PreAnimation.ticks) {
                    --this.evoAnimTicks;
                }
            } else {
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks) {
                    --this.evoAnimTicks;
                }
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks - 21 && this.fadeCount > 0) {
                    --this.fadeCount;
                }
            }
            int ticks = this.evoAnimTicks;
            if (this.evoStage == EvolutionStage.PostAnimation) {
                ticks += EvolutionStage.PreAnimation.ticks;
            }
            float length = this.getBaseStats().length.floatValue() + (float)ticks / 200.0f * this.lengthDiff;
            float height = this.getBaseStats().height.floatValue() + (float)ticks / 200.0f * this.heightDiff;
            float width = this.getBaseStats().width.floatValue() + (float)ticks / 200.0f * this.widthDiff;
            Random random = this.func_70681_au();
            int numEffects = random.nextInt(50);
            for (int i = 0; i < numEffects; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (double)((random.nextFloat() * 2.2f - 1.0f) * width), this.field_70163_u + (double)((random.nextFloat() * 2.2f - 1.0f) * height), this.field_70161_v + (double)((random.nextFloat() * 2.2f - 1.0f) * length), 255.0, 255.0, 255.0, new int[0]);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.getBaseStats().getSoundForGender(this.getPokemonData().getGender());
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (Pixelmon.devEnvironment) {
            nbt.func_74778_a("DebugTexture", this.getTexture().toString());
        }
    }

    @Deprecated
    public static ResourceLocation getTextureFor(EnumSpecies species, IEnumForm form, Gender gender, String customTexture, EnumSpecialTexture specialTexture, boolean shiny) {
        return Entity2Client.getTextureFor(species, form, gender, customTexture, shiny);
    }

    public static ResourceLocation getTextureFor(EnumSpecies species, IEnumForm form, Gender gender, String customTexture, boolean shiny) {
        String path = "textures/pokemon/";
        String folder = "";
        String prefix = "";
        if (shiny && form instanceof ICosmeticForm && ((ICosmeticForm)((Object)form)).isCosmetic()) {
            shiny = ((ICosmeticForm)((Object)form)).hasShiny(species);
        }
        if (shiny) {
            folder = "pokemon-shiny/";
            prefix = "shiny";
        }
        if (!(customTexture.isEmpty() || form instanceof ICosmeticForm && ((ICosmeticForm)((Object)form)).isCosmetic())) {
            folder = "custom-" + customTexture + "/";
        }
        String mf = EnumSpecies.mfTextured.contains(species) && !(form instanceof Gender) ? (gender == Gender.Male ? "male" : "female") : "";
        String formSuffix = form.getFormSuffix(shiny);
        return new ResourceLocation("pixelmon", path + folder + prefix + species.name.toLowerCase() + mf + formSuffix + ".png");
    }

    public static ResourceLocation getOGTexture(EnumSpecies pokemon, IEnumForm form, Gender gender, boolean shiny) {
        String mf = EnumSpecies.mfTextured.contains(pokemon) ? (gender == Gender.Male ? "male" : "female") : "";
        String formSuffix = form instanceof ICosmeticForm && ((ICosmeticForm)((Object)form)).isCosmetic() ? "" : form.getFormSuffix(shiny);
        return new ResourceLocation("pixelmon", "textures/pokemon/" + (shiny ? "pokemon-shiny/shiny" : "") + pokemon.name.toLowerCase() + mf + formSuffix + ".png");
    }
}

