/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;

public class FlashFire
extends AbilityBase {
    boolean activated = false;

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.getType() == EnumType.Fire) {
            if (!this.activated) {
                pokemon.bc.sendToAll("pixelmon.abilities.flashfire", pokemon.getNickname());
                a.moveResult.weightMod -= 25.0f;
                this.activated = true;
            } else {
                pokemon.bc.sendToAll("pixelmon.abilities.flashfire2", pokemon.getNickname());
            }
            return false;
        }
        return true;
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.activated && a.getType() == EnumType.Fire) {
            return new int[]{(int)((double)power * 1.5), accuracy};
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.activated = false;
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        int form;
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return 1.0f;
        }
        SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
        if (spawnInfoPokemon.getPokemonSpec() == null || spawnInfoPokemon.getPokemonSpec().name == null) {
            return 1.0f;
        }
        EnumSpecies species = spawnInfoPokemon.getSpecies();
        int n = form = spawnInfoPokemon.getPokemonSpec().form == null ? -1 : (int)spawnInfoPokemon.getPokemonSpec().form.byteValue();
        if (species.getBaseStats(species.getFormEnum(form)).getTypeList().contains(EnumType.Fire)) {
            return 5.0f;
        }
        return 1.0f;
    }
}

