/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

public class SlowStart
extends AbilityBase {
    private int turnsRemaining = 5;

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.sendToAll("pixelmon.abilities.slowstart", newPokemon.getNickname());
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.turnsRemaining = 5;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (this.turnsRemaining > 0) {
            int n = StatsType.Attack.getStatIndex();
            stats[n] = stats[n] / 2;
            int n2 = StatsType.Speed.getStatIndex();
            stats[n2] = stats[n2] / 2;
        }
        return stats;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (--this.turnsRemaining == 0) {
            pokemon.bc.sendToAll("pixelmon.abilities.slowstartend", pokemon.getNickname());
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

