/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EvolutionQueryList {
    public static final List<EvolutionQuery> queryList = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void declineQuery(EntityPlayerMP player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.decline();
                    queryList.remove(i);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptQuery(EntityPlayerMP player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.accept();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvolutionQuery get(EntityPlayer player) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                if (q.player != player) continue;
                return q;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(World world) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                q.tick(world);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnPokemon(EntityPlayerMP player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
                EntityPixelmon pixelmon = party.find(pokemonUUID).getOrSpawnPixelmon((Entity)player);
                if (pixelmon == null || party.find(pokemonUUID).getPixelmonIfExists() == null) {
                    return;
                }
                Pixelmon.network.sendToAllAround((IMessage)new EvolvePokemon(pokemonUUID, EvolutionStage.Choice), new NetworkRegistry.TargetPoint(pixelmon.field_71093_bK, pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v, 60.0));
                query.pixelmon = pixelmon;
                query.pixelmon.field_70714_bg.field_75782_a.clear();
                return;
            }
        }
    }
}

