/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.movement;

import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6Moves;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.Thermals;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public class PixelmonMovementFlying
extends PixelmonMovementBase {
    public PixelmonMovementFlying(Entity6Moves dragon) {
        super(dragon);
    }

    @Override
    public void handleMovement(List<EnumKeybinds> movements) {
        for (EnumKeybinds movement : movements) {
            if (movement == EnumKeybinds.Left) {
                this.pixelmon.field_70702_br = 0.5f;
            }
            if (movement == EnumKeybinds.Right) {
                this.pixelmon.field_70702_br = -0.5f;
            }
            if (movement == EnumKeybinds.Forward) {
                this.pixelmon.field_70125_A -= 0.5f * this.pixelmon.getBaseStats().mountedFlying.pitchRate;
                if (this.pixelmon.field_70125_A < this.pixelmon.getBaseStats().mountedFlying.lowerAngleLimit) {
                    this.pixelmon.field_70125_A = this.pixelmon.getBaseStats().mountedFlying.lowerAngleLimit;
                }
            }
            if (movement == EnumKeybinds.Back) {
                this.pixelmon.field_70125_A += 0.5f * this.pixelmon.getBaseStats().mountedFlying.pitchRate;
                if (this.pixelmon.field_70125_A > this.pixelmon.getBaseStats().mountedFlying.upperAngleLimit) {
                    this.pixelmon.field_70125_A = this.pixelmon.getBaseStats().mountedFlying.upperAngleLimit;
                }
            }
            if (movement == EnumKeybinds.Jump) {
                if (this.pixelmon.getIsHovering()) {
                    this.pixelmon.strafeUpDown = 1.0f;
                } else {
                    this.pixelmon.moveMultiplier += 0.005f;
                    if (this.pixelmon.moveMultiplier > Entity6Moves.maxMoveMultiplier) {
                        this.pixelmon.moveMultiplier = Entity6Moves.maxMoveMultiplier;
                    }
                }
            }
            if (movement != EnumKeybinds.Sprint) continue;
            if (this.pixelmon.getIsHovering()) {
                this.pixelmon.strafeUpDown -= 1.5f;
                continue;
            }
            this.pixelmon.moveMultiplier -= 0.005f;
            if (!(this.pixelmon.moveMultiplier < Entity6Moves.minMoveMultiplier)) continue;
            this.pixelmon.moveMultiplier = Entity6Moves.minMoveMultiplier;
        }
        boolean breakHover = false;
        for (EnumKeybinds movement : movements) {
            if (!movement.breaksHover() || !this.pixelmon.getIsHovering()) continue;
            breakHover = true;
        }
        if (breakHover) {
            this.pixelmon.toggleHover();
        }
    }

    @Override
    public void onLivingUpdate() {
        if (!this.pixelmon.field_70170_p.field_72995_K && this.pixelmon.takeOffTicks == 0 && this.pixelmon.field_70170_p.func_184143_b(this.pixelmon.func_174813_aQ().func_72321_a(0.2, 0.2, 0.2).func_72321_a(-0.2, -0.2, -0.2))) {
            this.pixelmon.setIsFlying(false);
            this.pixelmon.field_70125_A = 0.0f;
            this.pixelmon.rotationRoll = 0.0f;
            this.pixelmon.onLanding();
        }
        this.pixelmon.thermalPower = Thermals.getThermalPower(this.pixelmon.field_70170_p, this.pixelmon.func_180425_c());
        if (this.pixelmon.takeOffTicks > 0) {
            --this.pixelmon.takeOffTicks;
        }
        if (this.pixelmon.func_184179_bs() != null) {
            float dragonYaw;
            float playerYaw = this.pixelmon.getFlyingDirection();
            if (playerYaw > 360.0f) {
                playerYaw -= 360.0f;
                this.pixelmon.func_184179_bs().field_70177_z -= 360.0f;
            }
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
                this.pixelmon.func_184179_bs().field_70177_z += 360.0f;
            }
            if ((dragonYaw = this.pixelmon.field_70177_z) > 360.0f) {
                dragonYaw -= 360.0f;
                this.pixelmon.field_70177_z -= 360.0f;
            }
            if (dragonYaw < 0.0f) {
                dragonYaw += 360.0f;
                this.pixelmon.field_70177_z += 360.0f;
            }
            float degreesPast360 = 360.0f - dragonYaw + playerYaw;
            float degreesBack360 = dragonYaw + 360.0f - playerYaw;
            float diff = Math.abs(playerYaw - dragonYaw);
            float degreeShift = 13.0f * this.pixelmon.getBaseStats().mountedFlying.turnRate * 1.0f / (1.0f + this.pixelmon.field_191988_bg);
            if (dragonYaw != playerYaw) {
                this.pixelmon.field_70177_z = diff <= degreeShift || degreesPast360 <= degreeShift || degreesBack360 <= degreeShift ? playerYaw : (degreesPast360 < diff && degreesPast360 < degreesBack360 ? (this.pixelmon.field_70177_z += degreeShift) : (degreesBack360 < diff && degreesBack360 < degreesPast360 ? (this.pixelmon.field_70177_z -= degreeShift) : (dragonYaw < playerYaw ? (this.pixelmon.field_70177_z += degreeShift) : (this.pixelmon.field_70177_z -= degreeShift))));
            }
        }
        this.pixelmon.field_70701_bs = -0.02f;
        this.pixelmon.calcMoveSpeed();
        this.pixelmon.hoverRotationPitch = 20.0f;
        this.travelCustom(this.pixelmon.field_70702_br, this.pixelmon.field_191988_bg);
        this.pixelmon.field_70702_br *= 0.94f;
        this.pixelmon.strafeUpDown *= 0.94f;
    }

    @Override
    public void updatePassenger(Entity passenger, Vector3f offsets) {
        Vec3d lookVec = new Vec3d(this.pixelmon.field_70159_w, this.pixelmon.field_70181_x, this.pixelmon.field_70179_y);
        if (this.pixelmon.getIsHovering()) {
            lookVec = this.pixelmon.func_70040_Z();
            lookVec = lookVec.func_178787_e(new Vec3d(0.0, -2.0 * lookVec.field_72448_b, 0.0));
        }
        if (this.pixelmon.getStaysHorizontalInRender()) {
            lookVec = new Vec3d(this.pixelmon.field_70159_w, 0.0, this.pixelmon.field_70179_y);
        }
        lookVec = lookVec.func_72432_b();
        Vec3d upVec = new Vec3d(0.0, 1.0, 0.0);
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        Vec3d yVec = null;
        if (this.pixelmon.getStaysHorizontalInRender()) {
            yVec = lookVec.func_72431_c(new Vec3d(1.0, 0.0, 1.0));
        } else {
            Vec3d horizVec = lookVec.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
            yVec = lookVec.func_72431_c(horizVec);
        }
        if (yVec.field_72448_b < 0.0) {
            yVec = yVec.func_186678_a(-1.0);
        }
        yVec = yVec.func_72432_b();
        if (offsets.z != 0.0f) {
            double zPosScale = (offsets.z + this.pixelmon.field_70131_O) * this.pixelmon.getPixelmonScale() * this.pixelmon.getScaleFactor();
            vec = vec.func_72441_c(yVec.field_72450_a * zPosScale, yVec.field_72448_b * zPosScale, yVec.field_72449_c * zPosScale);
        }
        if (offsets.y != 0.0f) {
            double yPosScale = offsets.y * this.pixelmon.getPixelmonScale() * this.pixelmon.getScaleFactor();
            vec = vec.func_72441_c(lookVec.field_72450_a * yPosScale, lookVec.field_72448_b * yPosScale, lookVec.field_72449_c * yPosScale);
        }
        Matrix3d matRot = this.createRotationMatrix(lookVec);
        Vector3d vecRot = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        matRot.transform((Tuple3d)vecRot);
        passenger.func_70107_b(this.pixelmon.field_70165_t + vecRot.x, this.pixelmon.field_70163_u + vecRot.y, this.pixelmon.field_70161_v + vecRot.z);
    }
}

