/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class StatusSpec
extends SpecValue<String>
implements ISpecType {
    public StatusSpec(String value) {
        super("status", value);
    }

    @Override
    public List<String> getKeys() {
        return Collections.singletonList("status");
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        return new StatusSpec(arg);
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return this.parse(nbt.func_74779_i("status"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74778_a("status", value.value.toString());
    }

    public Class<? extends SpecValue<String>> getSpecClass() {
        return StatusSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return value.key + ":" + value.value.toString();
    }

    @Override
    public Class<String> getValueClass() {
        return String.class;
    }

    public static StatusPersist getStatus(String name) {
        switch (name.toLowerCase()) {
            case "sleep": {
                return new Sleep();
            }
            case "burn": {
                return new Burn();
            }
            case "paralyzed": 
            case "paralysis": {
                return new Paralysis();
            }
            case "frozen": 
            case "freeze": {
                return new Freeze();
            }
            case "poison": {
                return new Poison();
            }
            case "poisonbadly": 
            case "poison badly": {
                return new PoisonBadly();
            }
        }
        return NoStatus.noStatus;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        pokemon.setStatus(StatusSpec.getStatus((String)this.value));
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return StatusSpec.getStatus((String)((String)this.value)).type == pokemon.getStatus().type;
    }

    @Override
    public SpecValue<String> clone() {
        return new StatusSpec((String)this.value);
    }
}

