/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import com.pixelmonmod.pixelmon.util.ITranslatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.translation.I18n;

public enum EnumType implements ITranslatable,
IStringSerializable
{
    Normal(0, "Normal", 0xDDDDDD, 8.0f, 520.0f),
    Fire(1, "Fire", 0xFF8800, 8.0f, 264.0f),
    Water(2, "Water", 5727743, 1288.0f, 520.0f),
    Electric(3, "Electric", 16118348, 776.0f, 8.0f),
    Grass(4, "Grass", 54304, 776.0f, 264.0f),
    Ice(5, "Ice", 0xB0FFFF, 1288.0f, 264.0f),
    Fighting(6, "Fighting", 12189752, 1288.0f, 8.0f),
    Poison(7, "Poison", 13174256, 264.0f, 520.0f),
    Ground(8, "Ground", 10053184, 1031.0f, 264.0f),
    Flying(9, "Flying", 13424127, 264.0f, 264.0f),
    Psychic(10, "Psychic", 16733419, 520.0f, 520.0f),
    Bug(11, "Bug", 11067475, 8.0f, 8.0f),
    Rock(12, "Rock", 10712917, 775.0f, 519.0f),
    Ghost(13, "Ghost", 7089034, 520.0f, 264.0f),
    Dragon(14, "Dragon", 2830540, 520.0f, 8.0f),
    Dark(15, "Dark", 0x404040, 264.0f, 8.0f),
    Steel(16, "Steel", 0xBCBCC2, 1032.0f, 520.0f),
    Mystery(17, "???", 3184256, 1544.0f, 8.0f),
    Fairy(18, "Fairy", 16614535, 1032.0f, 8.0f);

    private int index;
    private String name;
    private int color;
    public float textureX;
    public float textureY;

    private EnumType(int i, String s, int c, float texX, float texY) {
        this.index = i;
        this.name = s;
        this.color = c;
        this.textureX = texX;
        this.textureY = texY;
    }

    public int getColor() {
        return this.color;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return "type." + this.name.toLowerCase();
    }

    @Override
    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public static EnumType parseType(int index) {
        try {
            return EnumType.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return Normal;
        }
    }

    public static EnumType parseType(String name) {
        try {
            return EnumType.valueOf(name);
        }
        catch (Exception e) {
            return Normal;
        }
    }

    public static EnumType parseOrNull(int index) {
        try {
            return EnumType.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static ArrayList<EnumType> getAllTypes() {
        ArrayList<EnumType> list = new ArrayList<EnumType>();
        EnumType[] t = EnumType.values();
        Collections.addAll(list, t);
        return list;
    }

    public static float getTotalEffectiveness(List<EnumType> enumTypes, EnumType attackType) {
        return EnumType.getTotalEffectiveness(enumTypes, attackType, false);
    }

    public static float getTotalEffectiveness(List<EnumType> enumTypes, EnumType attackType, boolean inverse) {
        float f = 1.0f;
        for (EnumType type : enumTypes) {
            if (type == null) continue;
            f *= EnumType.getEffectiveness(attackType, type, inverse);
        }
        return f;
    }

    public static float inverseEffectiveness(float effectiveness) {
        return effectiveness == 0.0f ? 2.0f : 1.0f / effectiveness;
    }

    public static float getEffectiveness(EnumType t, EnumType t1) {
        return EnumType.getEffectiveness(t, t1, false);
    }

    public static float getEffectiveness(EnumType t, EnumType t1, boolean inverse) {
        if (t == Mystery || t1 == Mystery) {
            return Effectiveness.Normal.value;
        }
        float e = 1.0f;
        if (t == Normal) {
            if (t1 == Rock || t1 == Steel) {
                e = Effectiveness.Not.value;
            } else if (t1 == Ghost) {
                e = Effectiveness.None.value;
            }
        } else if (t == Fire) {
            if (t1 == Grass || t1 == Ice || t1 == Bug || t1 == Steel) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Water || t1 == Rock || t1 == Dragon) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Water) {
            if (t1 == Fire || t1 == Ground || t1 == Rock) {
                e = Effectiveness.Super.value;
            } else if (t1 == Water || t1 == Grass || t1 == Dragon) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Electric) {
            if (t1 == Water || t1 == Flying) {
                e = Effectiveness.Super.value;
            } else if (t1 == Electric || t1 == Grass || t1 == Dragon) {
                e = Effectiveness.Not.value;
            } else if (t1 == Ground) {
                e = Effectiveness.None.value;
            }
        } else if (t == Grass) {
            if (t1 == Water || t1 == Ground || t1 == Rock) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Grass || t1 == Poison || t1 == Flying || t1 == Bug || t1 == Dragon || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Ice) {
            if (t1 == Grass || t1 == Ground || t1 == Flying || t1 == Dragon) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Water || t1 == Ice || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Fighting) {
            if (t1 == Normal || t1 == Ice || t1 == Rock || t1 == Dark || t1 == Steel) {
                e = Effectiveness.Super.value;
            } else if (t1 == Poison || t1 == Flying || t1 == Psychic | t1 == Bug || t1 == Fairy) {
                e = Effectiveness.Not.value;
            } else if (t1 == Ghost) {
                e = Effectiveness.None.value;
            }
        } else if (t == Poison) {
            if (t1 == Grass || t1 == Fairy) {
                e = Effectiveness.Super.value;
            } else if (t1 == Poison || t1 == Ground || t1 == Rock || t1 == Ghost) {
                e = Effectiveness.Not.value;
            } else if (t1 == Steel) {
                e = Effectiveness.None.value;
            }
        } else if (t == Ground) {
            if (t1 == Fire || t1 == Electric || t1 == Poison || t1 == Rock || t1 == Steel) {
                e = Effectiveness.Super.value;
            } else if (t1 == Grass || t1 == Bug) {
                e = Effectiveness.Not.value;
            } else if (t1 == Flying) {
                e = Effectiveness.None.value;
            }
        } else if (t == Flying) {
            if (t1 == Grass || t1 == Fighting || t1 == Bug) {
                e = Effectiveness.Super.value;
            } else if (t1 == Electric || t1 == Rock || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Psychic) {
            if (t1 == Fighting || t1 == Poison) {
                e = Effectiveness.Super.value;
            } else if (t1 == Psychic || t1 == Steel) {
                e = Effectiveness.Not.value;
            } else if (t1 == Dark) {
                e = Effectiveness.None.value;
            }
        } else if (t == Bug) {
            if (t1 == Grass || t1 == Psychic || t1 == Dark) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Fighting || t1 == Poison || t1 == Flying || t1 == Ghost || t1 == Steel || t1 == Fairy) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Rock) {
            if (t1 == Fire || t1 == Ice || t1 == Flying || t1 == Bug) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fighting || t1 == Ground || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Ghost) {
            if (t1 == Psychic || t1 == Ghost) {
                e = Effectiveness.Super.value;
            } else if (t1 == Dark) {
                e = Effectiveness.Not.value;
            } else if (t1 == Normal) {
                e = Effectiveness.None.value;
            }
        } else if (t == Dragon) {
            if (t1 == Dragon) {
                e = Effectiveness.Super.value;
            } else if (t1 == Steel) {
                e = Effectiveness.Not.value;
            } else if (t1 == Fairy) {
                e = Effectiveness.None.value;
            }
        } else if (t == Dark) {
            if (t1 == Psychic || t1 == Ghost) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fighting || t1 == Dark || t1 == Fairy) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Steel) {
            if (t1 == Ice || t1 == Rock || t1 == Fairy) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Water || t1 == Electric || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        } else if (t == Fairy) {
            if (t1 == Dark || t1 == Dragon || t1 == Fighting) {
                e = Effectiveness.Super.value;
            } else if (t1 == Fire || t1 == Poison || t1 == Steel) {
                e = Effectiveness.Not.value;
            }
        }
        if (inverse) {
            if (e == Effectiveness.Super.value) {
                return Effectiveness.Not.value;
            }
            if (e == Effectiveness.Max.value) {
                return Effectiveness.Barely.value;
            }
            if (e == Effectiveness.Not.value) {
                return Effectiveness.Super.value;
            }
            if (e == Effectiveness.Barely.value) {
                return Effectiveness.Max.value;
            }
            if (e == Effectiveness.None.value) {
                return Effectiveness.Super.value;
            }
            return Effectiveness.Normal.value;
        }
        return e;
    }

    public int getIndex() {
        return this.index;
    }

    public ArrayList<EnumType> makeTypeList() {
        ArrayList<EnumType> typeList = new ArrayList<EnumType>(1);
        typeList.add(this);
        return typeList;
    }

    public static boolean hasType(String name) {
        try {
            return EnumType.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<EnumType> ignoreType(List<EnumType> origTypes, EnumType ignoreType) {
        List<EnumType> newTypes = origTypes.stream().filter(type -> type != ignoreType).collect(Collectors.toList());
        if (newTypes.isEmpty()) {
            newTypes.add(Mystery);
        }
        return newTypes;
    }
}

