/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import javax.annotation.Nonnull;

public enum EnumGreninja implements IEnumForm,
ICosmeticForm
{
    BASE,
    BATTLE_BOND,
    ASH,
    ZOMBIE_BATTLE_BOND,
    ZOMBIE,
    ASH_ZOMBIE,
    ALTER_BATTLE_BOND,
    ALTER,
    ASH_ALTER;


    @Override
    public String getFormSuffix() {
        if (this == ZOMBIE_BATTLE_BOND) {
            return "-zombie";
        }
        if (this == ALTER_BATTLE_BOND) {
            return "-alter";
        }
        if (this.ordinal() > BATTLE_BOND.ordinal()) {
            return "-" + this.name().toLowerCase();
        }
        return "";
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isTemporary() {
        return this == ASH || this == ASH_ZOMBIE || this == ASH_ALTER;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        if (this == ASH || this == BATTLE_BOND) {
            return BATTLE_BOND;
        }
        if (this == ASH_ZOMBIE) {
            return ZOMBIE_BATTLE_BOND;
        }
        if (this == ASH_ALTER) {
            return ALTER_BATTLE_BOND;
        }
        return BASE;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.greninja.form." + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != BASE && this != BATTLE_BOND && this != ASH;
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        if (this == ZOMBIE) {
            return BASE;
        }
        if (this == ZOMBIE_BATTLE_BOND) {
            return BATTLE_BOND;
        }
        if (this == ASH_ZOMBIE) {
            return ASH;
        }
        if (this == ALTER) {
            return BASE;
        }
        if (this == ALTER_BATTLE_BOND) {
            return BATTLE_BOND;
        }
        if (this == ASH_ALTER) {
            return ASH;
        }
        return this;
    }

    @Override
    public boolean isDefaultForm() {
        return this == BASE;
    }

    public EnumGreninja getAshForm() {
        if (this == BATTLE_BOND) {
            return ASH;
        }
        if (this == ZOMBIE_BATTLE_BOND) {
            return ASH_ZOMBIE;
        }
        if (this == ALTER_BATTLE_BOND) {
            return ASH_ALTER;
        }
        return null;
    }
}

