/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumChoiceItems;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;

public class ChoiceItem
extends ItemHeld {
    private EnumChoiceItems choiceItemType;

    public ChoiceItem(EnumChoiceItems choiceItemType, String itemName) {
        super(EnumHeldItems.choiceItem, itemName);
        this.choiceItemType = choiceItemType;
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        if (!user.bc.simulateMode && user.isDynamax <= 0) {
            user.choiceLocked = attack;
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode && !pw.choiceSwapped) {
            pw.choiceLocked = null;
        }
        pw.choiceSwapped = false;
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode && !pw.choiceSwapped) {
            pw.choiceLocked = null;
        }
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.isDynamax <= 0) {
            int n = this.choiceItemType.effectType.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        Moveset moveset = pokemon.getMoveset();
        for (int i = 0; i < moveset.size(); ++i) {
            Attack currentMove = moveset.get(i);
            if (pokemon.choiceLocked == null || currentMove.equals(pokemon.choiceLocked)) continue;
            currentMove.setDisabled(true, pokemon);
        }
    }
}

