/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.BlockZygardeCell;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityZygardeCell;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.util.Scheduling;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ZygardeCellsListener {
    private static final boolean DEBUG = false;
    private static final int SEA_LEVEL = 62;
    private static final int HALF_HOUR_IN_TICKS = 36000;
    private static final Set<Block> SPAWNABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150364_r, Blocks.field_150363_s});
    private static final Set<UUID> hasCube = Sets.newHashSet();
    private static boolean clientHasCube;
    private static long clientLastCheck;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ZygardeCellsListener.checkForCube(event.player)) {
            hasCube.add(event.player.func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedInEvent event) {
        hasCube.remove(event.player.func_110124_au());
    }

    public static boolean hasCube(EntityPlayer player) {
        return hasCube.contains(player.func_110124_au());
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean clientHasCube() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (clientLastCheck < player.field_70170_p.func_82737_E() - 20L) {
            clientHasCube = ZygardeCellsListener.checkForCube((EntityPlayer)player);
            clientLastCheck = player.field_70170_p.func_82737_E();
        }
        return clientHasCube;
    }

    public static boolean checkForCube(@Nonnull EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        Predicate<ItemStack> check = itemStack -> itemStack.func_77973_b() == PixelmonItems.zygardeCube;
        return inv.field_70462_a.stream().anyMatch(check) || inv.field_184439_c.stream().anyMatch(check);
    }

    public static void trySpawnInChunk(EntityPlayerMP player, Chunk chunk) {
        int y;
        World world = chunk.func_177412_p();
        int x = RandomHelper.getRandomNumberBetween(1, 14);
        int z = RandomHelper.getRandomNumberBetween(1, 14);
        BlockPos pos = chunk.func_76632_l().func_180331_a(x, 62, z);
        Biome biome = chunk.func_177411_a(pos, world.func_72959_q());
        if (biome.field_76752_A != Blocks.field_150349_c.func_176223_P()) {
            return;
        }
        TileEntityZygardeCell te = BlockHelper.findClosestTileEntity(TileEntityZygardeCell.class, (Entity)player, 72.0, t -> true);
        if (te != null) {
            return;
        }
        for (y = 62; y <= 120; ++y) {
            pos = chunk.func_76632_l().func_180331_a(x, y, z);
            Block block = chunk.func_177435_g(pos).func_177230_c();
            if (block != Blocks.field_150350_a || !chunk.func_177444_d(pos)) continue;
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) break;
            y = 120;
            break;
        }
        if (y != 120) {
            SetMultimap map = MultimapBuilder.hashKeys().hashSetValues().build();
            int x1 = pos.func_177958_n() + 1;
            int y1 = pos.func_177956_o() + 1;
            int z1 = pos.func_177952_p() + 1;
            int x2 = pos.func_177958_n() - 1;
            int y2 = pos.func_177956_o() - 4;
            int z2 = pos.func_177952_p() - 1;
            for (int lx = x1; lx >= x2; --lx) {
                for (int ly = y1; ly >= y2; --ly) {
                    for (int lz = z1; lz >= z2; --lz) {
                        pos = new BlockPos(lx, ly, lz);
                        Block b = chunk.func_177435_g(pos).func_177230_c();
                        if (!SPAWNABLE_BLOCKS.contains(b)) continue;
                        map.put((Object)b, (Object)pos);
                    }
                }
            }
            if (!map.isEmpty()) {
                EnumFacing facing;
                IBlockState state;
                if (map.containsKey((Object)Blocks.field_150364_r) || map.containsKey((Object)Blocks.field_150363_s)) {
                    ArrayList logs = Lists.newArrayList((Iterable)map.get((Object)Blocks.field_150364_r));
                    logs.addAll(map.get((Object)Blocks.field_150363_s));
                    Collections.shuffle(logs);
                    for (BlockPos pos1 : logs) {
                        state = chunk.func_177435_g(pos1);
                        if (state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.X) {
                            facing = ZygardeCellsListener.hasAirPocket(chunk, pos1, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST);
                            if (facing == null) continue;
                            ZygardeCellsListener.spawnOn(chunk, pos1.func_177972_a(facing), facing.func_176734_d(), player);
                            return;
                        }
                        if (state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.Z) {
                            facing = ZygardeCellsListener.hasAirPocket(chunk, pos1, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH);
                            if (facing == null) continue;
                            ZygardeCellsListener.spawnOn(chunk, pos1.func_177972_a(facing), facing.func_176734_d(), player);
                            return;
                        }
                        facing = ZygardeCellsListener.hasAirPocket(chunk, pos1, EnumFacing.field_176754_o);
                        if (facing == null) continue;
                        ZygardeCellsListener.spawnOn(chunk, pos1.func_177972_a(facing), facing.func_176734_d(), player);
                        return;
                    }
                }
                if (map.containsKey((Object)Blocks.field_150362_t) || map.containsKey((Object)Blocks.field_150361_u)) {
                    ArrayList leaves = Lists.newArrayList((Iterable)map.get((Object)Blocks.field_150362_t));
                    leaves.addAll(map.get((Object)Blocks.field_150361_u));
                    Collections.shuffle(leaves);
                    for (BlockPos pos1 : leaves) {
                        state = chunk.func_177435_g(pos1);
                        if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue() || (facing = ZygardeCellsListener.hasAirPocket(chunk, pos1, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST)) == null) continue;
                        ZygardeCellsListener.spawnOn(chunk, pos1.func_177972_a(facing), facing.func_176734_d(), player);
                        return;
                    }
                }
                if (map.containsKey((Object)Blocks.field_150349_c)) {
                    ArrayList grass = Lists.newArrayList((Iterable)map.get((Object)Blocks.field_150349_c));
                    Collections.shuffle(grass);
                    for (BlockPos pos1 : grass) {
                        EnumFacing facing2 = ZygardeCellsListener.hasAirPocket(chunk, pos1, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST);
                        if (facing2 == null) continue;
                        ZygardeCellsListener.spawnOn(chunk, pos1.func_177972_a(facing2), facing2.func_176734_d(), player);
                        return;
                    }
                }
            }
        }
    }

    private static EnumFacing hasAirPocket(Chunk chunk, BlockPos pos, EnumFacing ... facings) {
        ArrayList facingList = Lists.newArrayList();
        for (EnumFacing facing : facings) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!chunk.func_76632_l().equals((Object)new ChunkPos(offset)) || chunk.func_177435_g(offset).func_177230_c() != Blocks.field_150350_a) continue;
            facingList.add(facing);
        }
        return (EnumFacing)RandomHelper.getRandomElementFromList(facingList);
    }

    private static void spawnOn(Chunk chunk, BlockPos pos, EnumFacing facing, EntityPlayerMP player) {
        EnumFacing rotation = facing.func_176740_k() == EnumFacing.Axis.Y ? RandomHelper.getRandomElementFromArray(EnumFacing.field_176754_o) : (RandomHelper.getRandomChance() ? EnumFacing.UP : EnumFacing.DOWN);
        Block block = RandomHelper.getRandomChance(5) ? PixelmonBlocks.zygardeCore : PixelmonBlocks.zygardeCell;
        IBlockState state = block.func_176223_P().func_177226_a(BlockZygardeCell.ORIENTATION_PROPERTY, (Comparable)facing).func_177226_a(BlockZygardeCell.ROTATION_PROPERTY, (Comparable)rotation);
        chunk.func_177412_p().func_175656_a(pos, state);
    }

    static {
        Scheduling.schedule(100, task -> {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            hasCube.clear();
            if (server != null && server.func_71278_l()) {
                for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                    if (!ZygardeCellsListener.checkForCube((EntityPlayer)player)) continue;
                    hasCube.add(player.func_110124_au());
                }
            }
        }, true);
        Scheduling.schedule(200, task -> {
            if (!PixelmonConfig.spawnZygardeCells) {
                return;
            }
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null && server.func_71278_l()) {
                if (hasCube.isEmpty()) {
                    return;
                }
                UUID random = RandomHelper.getRandomElementFromArray(hasCube.toArray(new UUID[0]));
                EntityPlayerMP player = server.func_184103_al().func_177451_a(random);
                if (player.func_175149_v()) {
                    return;
                }
                ArrayList chunks = Lists.newArrayList();
                int distance = server.func_184103_al().func_72395_o();
                int x1 = player.field_70176_ah + distance;
                int z1 = player.field_70164_aj + distance;
                int x2 = player.field_70176_ah - distance;
                int z2 = player.field_70164_aj - distance;
                for (int x = x1; x >= x2; --x) {
                    for (int z = z1; z >= z2; --z) {
                        Chunk chunk;
                        if (x >= player.field_70176_ah - 1 && x <= player.field_70176_ah + 1 && z >= player.field_70164_aj - 1 && z <= player.field_70164_aj + 1 || (chunk = player.func_71121_q().func_72863_F().func_186026_b(x, z)) == null || !chunk.func_177410_o() || chunk.func_177416_w() >= 36000L) continue;
                        chunks.add(chunk);
                    }
                }
                if (!chunks.isEmpty()) {
                    ZygardeCellsListener.trySpawnInChunk(player, (Chunk)RandomHelper.getRandomElementFromList(chunks));
                }
            }
        }, true);
        clientHasCube = false;
        clientLastCheck = 0L;
    }
}

