/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.actions.ExecutorMode;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;

public class Action {
    private ExecutorMode mode;
    private int[] executors;
    private IAction action;
    private Object[] data;

    public Action(String[] args, Quest quest, Stage stage) throws InvalidQuestArgsException {
        String executorString = args[0];
        this.mode = executorString.contains("+") ? ExecutorMode.AND : ExecutorMode.OR;
        executorString = executorString.replace("+", "");
        String[] executors = executorString.split(",");
        this.executors = new int[executors.length];
        int i = 0;
        for (String executor : executors) {
            this.executors[i++] = Integer.parseInt(executor);
        }
        this.action = QuestRegistry.getInstance().getAction(args[1]);
        this.data = this.action.parse(quest, stage, args);
    }

    public ExecutorMode getMode() {
        return this.mode;
    }

    public int[] getExecutors() {
        return this.executors;
    }

    public void execute(Quest questIn, Stage stageIn, QuestData dataIn, QuestProgress progressIn) throws InvalidQuestArgsException {
        this.action.execute(questIn, stageIn, dataIn, progressIn, this.data);
    }
}

