/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;

public class SetStageAction
implements IAction {
    @Override
    public String identifier() {
        return "SET_STAGE";
    }

    @Override
    public Object[] parse(Quest quest, Stage stage, String ... args) {
        if (args.length == 3) {
            return new Object[]{Short.parseShort(args[2])};
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 3; i < args.length; ++i) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(args[i]);
        }
        return new Object[]{Short.parseShort(args[2]), builder.toString()};
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Object ... args) throws InvalidQuestArgsException {
        QuestProgress otherProgress;
        if (args.length == 1) {
            progress.moveStage(data, stage, (Short)args[0], progress);
            progress.sendTo(data.getPlayer());
        } else if (args.length == 2 && (otherProgress = data.getProgressForQuest((String)args[1])) != null) {
            progress.moveStage(data, otherProgress.getCurrentStage(), (Short)args[0], otherProgress);
            otherProgress.setStage((Short)args[0]);
            otherProgress.sendTo(data.getPlayer());
        }
    }
}

