/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client;

import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.ui.QuestsGUI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class QuestDataClient {
    private static final QuestDataClient INSTANCE = new QuestDataClient();
    private final LinkedHashMap<String, QuestProgressClient> quests = new LinkedHashMap();
    private final LinkedHashMap<String, QuestProgressClient> completeQuests = new LinkedHashMap();
    private int displayQuest = -1;

    public static QuestDataClient getInstance() {
        return INSTANCE;
    }

    private QuestDataClient() {
    }

    public QuestProgressClient getDisplayQuest() {
        if (this.displayQuest >= this.quests.size()) {
            this.displayQuest = 0;
        }
        int i = 0;
        for (QuestProgressClient qpc : this.quests.values()) {
            if (this.displayQuest == i) {
                return qpc;
            }
            ++i;
        }
        return null;
    }

    public void setDisplayQuest(QuestProgressClient qpcIn) {
        if (qpcIn == null) {
            this.displayQuest = -1;
            return;
        }
        int i = 0;
        for (QuestProgressClient qpc : this.quests.values()) {
            if (qpc == qpcIn) {
                this.displayQuest = i;
                return;
            }
            ++i;
        }
    }

    public void cycleDisplayQuest() {
        boolean next = false;
        int i = 0;
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getQuests()) {
            if (qpc.getName() != null) {
                if (this.displayQuest == -1) {
                    this.displayQuest = i;
                    return;
                }
                if (i == this.displayQuest) {
                    next = true;
                    ++i;
                    continue;
                }
                if (next) {
                    this.displayQuest = i;
                    return;
                }
            }
            ++i;
        }
        this.displayQuest = -1;
    }

    public void clear() {
        this.quests.clear();
        this.completeQuests.clear();
    }

    public void update(String filename, QuestProgressClient quest) {
        GuiScreen screen;
        if (filename != null && !filename.isEmpty()) {
            if (quest.isComplete()) {
                this.quests.remove(filename);
                this.completeQuests.put(filename, quest);
            } else {
                this.quests.put(filename, quest);
            }
        }
        if ((screen = Minecraft.func_71410_x().field_71462_r) instanceof QuestsGUI) {
            QuestsGUI questsGUI = (QuestsGUI)screen;
            questsGUI.refreshQuests();
        }
    }

    public void remove(UUID uuid) {
        this.quests.remove(uuid);
    }

    public Collection<QuestProgressClient> getQuests() {
        return this.quests.values();
    }

    public Collection<QuestProgressClient> getCompleteQuests() {
        return this.completeQuests.values();
    }
}

