/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiKeybindIcon;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;

public class GuiKeybindIconQuest
extends GuiKeybindIcon {
    private final KeyBinding keybindA;
    private final KeyBinding keybindB;
    private boolean enabled = true;

    public GuiKeybindIconQuest(KeyBinding keybindA, KeyBinding keybindB) {
        super(null, null);
        this.keybindA = keybindA;
        this.keybindB = keybindB;
    }

    @Override
    public void draw(int x, int y, float zLevel) {
        if (this.enabled) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            boolean flag = f.func_82883_a();
            f.func_78264_a(true);
            f.func_78276_b(GameSettings.func_74298_c((int)this.keybindA.func_151463_i()), x + 20, y + 17, 0xFFFFFF);
            f.func_78276_b(GameSettings.func_74298_c((int)this.keybindB.func_151463_i()), x + 20, y - 5, 0xFFFFFF);
            boolean drawnArrow = false;
            QuestProgressClient qpc = QuestDataClient.getInstance().getDisplayQuest();
            if (qpc != null && qpc.getObjectives() != null) {
                String name = TextFormatting.BOLD + qpc.getName();
                int nameWidth = f.func_78256_a(name);
                f.func_78276_b(name, x - nameWidth - 3, y + 1, 0xFFFFFF);
                if (qpc.getObjectives() != null) {
                    for (ObjectiveDetail od : qpc.getObjectives()) {
                        if (od.isComplete()) continue;
                        String detail = qpc.format(od);
                        int detailWidth = f.func_78256_a(detail);
                        f.func_78276_b(detail, x - detailWidth - 3, y + 9, 0xFFFFFF);
                        break;
                    }
                }
                mc.field_71446_o.func_110577_a(qpc.isReadyForTurnIn() || qpc.isComplete() ? GuiResources.question_mark : GuiResources.exclamation_mark);
                if (qpc.isComplete() || qpc.getColor() == null) {
                    GlStateManager.func_179131_c((float)0.8509804f, (float)0.8509804f, (float)0.8509804f, (float)1.0f);
                } else {
                    QuestColor color = qpc.getColor();
                    GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
                }
                for (QuestMarker marker : qpc.getMarkers()) {
                    if (!this.drawArrow(marker, x - 1, y + 1, zLevel)) continue;
                    drawnArrow = true;
                    break;
                }
            } else {
                mc.field_71446_o.func_110577_a(GuiResources.exclamation_mark);
                GlStateManager.func_179131_c((float)0.8509804f, (float)0.8509804f, (float)0.8509804f, (float)1.0f);
            }
            if (!drawnArrow) {
                GuiHelper.drawImageQuad(x - 2, y, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
            }
            f.func_78264_a(flag);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private float getYawFromVec3(Vec3d vec, EntityPlayer player) {
        double dx = vec.field_72450_a;
        double dz = vec.field_72449_c;
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI - 90.0 - (double)player.field_70177_z) + 90.0f;
    }

    private boolean drawArrow(QuestMarker marker, double x, double y, float z) {
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d markerPos = this.getVecForMarker(marker);
        if (markerPos != null) {
            GlStateManager.func_179094_E();
            Vec3d v1 = new Vec3d(mc.field_71439_g.field_70165_t + 0.5, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v + 0.5);
            Vec3d v2 = new Vec3d(markerPos.field_72450_a, markerPos.field_72448_b, markerPos.field_72449_c);
            Vec3d v3 = v2.func_178788_d(v1).func_72432_b();
            v3 = new Vec3d(-v3.field_72450_a, v3.field_72448_b, -v3.field_72449_c);
            int arrWidth = 18;
            int arrHeight = 18;
            GlStateManager.func_179137_b((double)(x + (double)((float)arrWidth / 2.0f)), (double)(y + (double)((float)arrHeight / 2.0f)), (double)0.0);
            GlStateManager.func_179114_b((float)(this.getYawFromVec3(v3, (EntityPlayer)mc.field_71439_g) + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(GuiResources.arrow);
            GuiHelper.drawImageQuad((float)(-arrWidth) / 2.0f, (float)(-arrHeight) / 2.0f, arrWidth, arrHeight, 0.0, 0.0, 1.0, 1.0, z);
            GlStateManager.func_179121_F();
            return true;
        }
        return false;
    }

    private Vec3d getVecForMarker(QuestMarker marker) {
        Minecraft mc = Minecraft.func_71410_x();
        double x = marker.x;
        double y = marker.y;
        double z = marker.z;
        boolean found = false;
        if (marker.uuid != null) {
            for (Entity entity : mc.field_71441_e.field_72996_f) {
                if (entity == null || !entity.getPersistentID().equals(marker.uuid)) continue;
                x = (double)((float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)mc.func_184121_ak())) + 0.5;
                y = (double)((float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)mc.func_184121_ak()) + entity.func_70047_e()) + 0.8;
                z = (double)((float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)mc.func_184121_ak())) + 0.5;
                found = true;
                break;
            }
        } else {
            found = true;
        }
        if (!found) {
            return null;
        }
        return new Vec3d(x, y, z);
    }
}

