/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiListQuest;
import com.pixelmonmod.pixelmon.quests.comm.AbandonQuest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class QuestsGUI
extends GuiScreen {
    private GuiButton random;
    private GuiButton craft;
    private GuiListQuest questList;
    private GuiListQuest completeList;
    private final boolean DEBUG = Pixelmon.devEnvironment;
    private boolean showActive = true;
    private int activeSeperator = 25;
    private boolean init = false;
    private boolean abandoning = false;
    private int abandonColor = -5767168;
    private boolean rising = true;

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        this.questList = new GuiListQuest(this.field_146297_k.field_71466_p, x + 7, y + 23, 104, 9);
        this.completeList = new GuiListQuest(this.field_146297_k.field_71466_p, x + 7, y + 27, 104, 9);
        this.refreshQuests();
        this.questList.setFocused(true);
    }

    public void refreshQuests() {
        this.questList.lines.clear();
        this.completeList.lines.clear();
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getQuests()) {
            if (qpc.getName() == null) continue;
            this.questList.addLine(qpc);
        }
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getCompleteQuests()) {
            this.completeList.addLine(qpc);
        }
        this.questList.selectQuest(-1);
        this.completeList.selectQuest(-1);
    }

    public void func_146276_q_() {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int sliderSpeed = 5;
        if (mouseX >= (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1 && mouseX <= (int)((float)x + 3.0f * (float)dispWidth / 4.0f) && mouseY >= y + lowerBorder - div && mouseY <= y + dispHeight - div) {
            QuestProgressClient selectedQuest = null;
            if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
                selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
            }
            if (selectedQuest != null) {
                boolean openEye;
                boolean bl = openEye = QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
                if (openEye) {
                    QuestDataClient.getInstance().setDisplayQuest(selectedQuest);
                } else {
                    QuestDataClient.getInstance().setDisplayQuest(null);
                }
            }
        } else {
            QuestProgressClient clickedOnQuest;
            if ((float)mouseX >= v && mouseX <= x + dispWidth - 2 && mouseY >= y + lowerBorder - div && mouseY <= y + dispHeight - div) {
                QuestProgressClient selectedQuest;
                if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1 && (selectedQuest = this.questList.lines.get(this.questList.selectedQuest)).isAbandonable()) {
                    if (!this.abandoning) {
                        this.abandoning = true;
                    } else {
                        if (QuestDataClient.getInstance().getDisplayQuest() == selectedQuest) {
                            QuestDataClient.getInstance().setDisplayQuest(null);
                        }
                        Pixelmon.network.sendToServer((IMessage)new AbandonQuest(selectedQuest));
                    }
                }
                return;
            }
            if (this.activeSeperator == border && mouseX > x - gap && mouseX < x - gap + dispWidth / 2 && mouseY > y && mouseY < y + this.activeSeperator && !this.showActive) {
                this.showActive = true;
                this.questList.setFocused(true);
                this.completeList.setFocused(false);
            } else if (this.activeSeperator == lowerBorder && mouseX > x - gap && mouseX < x - gap + dispWidth / 2 && mouseY > y + this.activeSeperator + div && mouseY < y + dispHeight && this.showActive) {
                this.showActive = false;
                this.completeList.setFocused(true);
                this.questList.setFocused(false);
            } else if (this.questList.isFocused) {
                QuestProgressClient clickedOnQuest2 = this.questList.mouseClicked(mouseX, mouseY, 0, this.questList.yPos + 8);
                if (clickedOnQuest2 != null) {
                    int lineindex = this.questList.lines.indexOf(clickedOnQuest2);
                    this.completeList.selectQuest(-1);
                    this.questList.selectQuest(lineindex);
                }
            } else if (this.completeList.isFocused && (clickedOnQuest = this.completeList.mouseClicked(mouseX, mouseY, 0, this.completeList.yPos + 8)) != null) {
                int lineindex = this.completeList.lines.indexOf(clickedOnQuest);
                this.questList.selectQuest(-1);
                this.completeList.selectQuest(lineindex);
            }
        }
        this.abandoning = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        int qlh;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        super.func_73863_a(mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.backgroundTexture);
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        if (!this.init) {
            this.activeSeperator = dispHeight - border - div;
        }
        int sliderSpeed = 5;
        if (!this.showActive) {
            if (this.activeSeperator > border) {
                this.activeSeperator -= sliderSpeed;
                if (this.activeSeperator <= border) {
                    this.activeSeperator = border;
                }
            }
        } else if (this.activeSeperator < lowerBorder) {
            this.activeSeperator += sliderSpeed;
            if (this.activeSeperator >= lowerBorder) {
                this.activeSeperator = lowerBorder;
            }
        }
        if ((qlh = this.activeSeperator - border - 12) <= 2) {
            this.questList.isEnabled = false;
        } else {
            this.questList.isEnabled = true;
            this.questList.height = qlh;
            this.questList.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        }
        float titleBorder = 8.5f;
        int clh = lowerBorder - 12 - this.activeSeperator;
        this.completeList.yPos = y + (int)titleBorder + this.activeSeperator + div + 16;
        if (clh <= 2) {
            this.completeList.isEnabled = false;
        } else {
            this.completeList.isEnabled = true;
            this.completeList.height = clh;
            this.completeList.displayLines = (int)(9.0f * ((float)clh / (float)(lowerBorder - 12 - border)));
        }
        Gui.func_146110_a((int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)this.activeSeperator, (float)((float)dispWidth / 2.0f), (float)this.activeSeperator);
        Gui.func_146110_a((int)(x - gap), (int)(y + this.activeSeperator + div), (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)(dispHeight - div - this.activeSeperator), (float)((float)dispWidth / 2.0f), (float)(dispHeight - div - this.activeSeperator));
        Gui.func_146110_a((int)(x + dispWidth / 2 + gap + 1), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (float)((float)dispWidth / 2.0f), (float)dispHeight);
        String textA = TextFormatting.BOLD + I18n.func_135052_a((String)"quest.ui.quests", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(textA, (float)(x - gap + dispWidth / 4 - this.field_146289_q.func_78256_a(textA) / 2), (float)y + titleBorder, 0xFFFFFF, true);
        String textB = TextFormatting.BOLD + I18n.func_135052_a((String)"quest.ui.history", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(textB, (float)(x - gap + dispWidth / 4 - this.field_146289_q.func_78256_a(textB) / 2), (float)y + titleBorder + (float)this.activeSeperator + (float)div, 0xFFFFFF, true);
        if (this.questList.isEnabled) {
            this.questList.drawBackground();
            this.questList.drawText();
        }
        if (this.completeList.isEnabled) {
            this.completeList.drawBackground();
            this.completeList.drawText();
        }
        QuestProgressClient selectedQuest = null;
        if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
            selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
        } else if (this.completeList.selectedQuest != null && this.completeList.selectedQuest != -1) {
            selectedQuest = this.completeList.lines.get(this.completeList.selectedQuest);
        }
        if (selectedQuest != null) {
            String title = selectedQuest.getName();
            String desc = selectedQuest.getDesc();
            int width = (int)((float)dispWidth / 2.0f - 9.0f);
            int descHeight = this.field_146289_q.func_78267_b(desc, width);
            int strWidth = this.field_146289_q.func_78256_a(title);
            double wf = 95.0;
            double finalWidth = Math.min((double)strWidth, wf - 6.0);
            GuiHelper.drawSquashedString(this.field_146289_q, title, false, wf, (int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0 + 6.0), (int)((float)y + titleBorder), 0xFFFFFF, true);
            this.field_146289_q.func_78279_b(desc, (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f), (int)((float)y + titleBorder + 17.0f), width, 0xFFFFFF);
            for (ObjectiveDetail od : selectedQuest.getObjectives()) {
                int channel = 5;
                String detail = selectedQuest.format(od);
                int detailHeight = this.field_146289_q.func_78267_b(detail, width - channel);
                this.field_146289_q.func_78279_b(detail, (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + channel, (int)((float)y + titleBorder + 14.0f) + descHeight + this.field_146289_q.field_78288_b, width - channel, 0xFFFFFF);
                descHeight += detailHeight;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179112_b((int)770, (int)771);
            this.field_146297_k.field_71446_o.func_110577_a(selectedQuest.isReadyForTurnIn() || selectedQuest.isComplete() ? GuiResources.question_mark : GuiResources.exclamation_mark);
            if (selectedQuest.isComplete()) {
                GlStateManager.func_179131_c((float)0.8509804f, (float)0.8509804f, (float)0.8509804f, (float)1.0f);
            } else {
                QuestColor color = selectedQuest.getColor();
                GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
            }
            Gui.func_146110_a((int)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0) - 11), (int)((int)((float)y + titleBorder) - 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        int inactiveButtonColor = -9079435;
        boolean openEye = selectedQuest == null || QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
        QuestsGUI.func_73734_a((int)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1), (int)(y + lowerBorder - div), (int)((int)((float)x + 3.0f * (float)dispWidth / 4.0f)), (int)(y + dispHeight - div), (int)(selectedQuest == null || selectedQuest.isComplete() ? inactiveButtonColor : (openEye ? -12884481 : -10467329)));
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int resting = -5767168;
        int alerting = -1179648;
        int diff = 65536;
        if (this.abandoning) {
            if (this.rising) {
                this.abandonColor += diff;
                if (this.abandonColor >= alerting) {
                    this.rising = false;
                }
            } else {
                this.abandonColor -= diff;
                if (this.abandonColor <= resting) {
                    this.rising = true;
                }
            }
        } else if (this.abandonColor > resting) {
            this.abandonColor -= diff;
            if (this.abandonColor <= resting) {
                this.abandonColor = resting;
            }
        } else {
            this.abandonColor = resting;
        }
        QuestsGUI.func_73734_a((int)((int)v), (int)(y + lowerBorder - div), (int)(x + dispWidth - 2), (int)(y + dispHeight - div), (int)(selectedQuest == null || selectedQuest.isComplete() || !selectedQuest.isAbandonable() ? inactiveButtonColor : this.abandonColor));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (openEye) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.eyeTexture);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.eyeClosedTexture);
        }
        Gui.func_146110_a((int)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 11), (int)((int)((float)(y + lowerBorder) - (float)div * 1.55f)), (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.crossTexture);
        Gui.func_146110_a((int)((int)v + 11), (int)((int)((float)(y + lowerBorder) - (float)div * 1.55f)), (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        String leftButton = openEye ? I18n.func_135052_a((String)"quest.ui.track", (Object[])new Object[0]) : I18n.func_135052_a((String)"quest.ui.hide", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(leftButton, (float)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 27) - (float)this.field_146289_q.func_78256_a(leftButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF, false);
        String rightButton = this.abandoning ? I18n.func_135052_a((String)"quest.ui.abandoncheck", (Object[])new Object[0]) : I18n.func_135052_a((String)"quest.ui.abandon", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(rightButton, (float)((int)v + 27) - (float)this.field_146289_q.func_78256_a(rightButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF, false);
        this.checkMouseWheel();
        if (this.DEBUG) {
            this.field_146289_q.func_78276_b("X: " + mouseX + " Y: " + mouseY, mouseX + 10, mouseY + 10, Color.red.getRGB());
        }
        if (!this.init) {
            this.init = true;
        }
    }

    private void checkMouseWheel() {
        int mousewheelDirection = Mouse.getDWheel();
        if (mousewheelDirection == 120) {
            if (this.questList.isFocused) {
                this.questList.scrollDown();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollDown();
            }
        } else if (mousewheelDirection == -120) {
            if (this.questList.isFocused) {
                this.questList.scrollUp();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollUp();
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
    }
}

