/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm;

import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.util.helpers.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;

public class QuestMarker {
    public float x;
    public float y;
    public float z;
    public UUID uuid;
    public int dim;
    public QuestColor color;
    public Type type;

    public QuestMarker(float x, float y, float z, UUID uuid, int dim, QuestColor color, Type type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.uuid = uuid;
        this.dim = dim;
        this.color = color;
        this.type = type;
    }

    public QuestMarker(BlockPos pos, UUID uuid, int dim, QuestColor color, Type type) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), uuid, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, UUID uuid, int dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, uuid, dim, color, type);
    }

    public QuestMarker(float x, float y, float z, int dim, QuestColor color, Type type) {
        this(x, y, z, (UUID)null, dim, color, type);
    }

    public QuestMarker(UUID uuid, int dim, QuestColor color, Type type) {
        this(0.0f, 0.0f, 0.0f, uuid, dim, color, type);
    }

    public QuestMarker(BlockPos pos, int dim, QuestColor color, Type type) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (UUID)null, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, int dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, (UUID)null, dim, color, type);
    }

    public QuestMarker(ByteBuf buf) {
        this.read(buf);
    }

    public void read(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.uuid = UUIDHelper.readUUID(buf);
        } else {
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
        }
        this.dim = buf.readInt();
        this.color = new QuestColor(buf.readInt());
        this.type = Type.values()[buf.readByte()];
    }

    public void write(ByteBuf buf) {
        if (this.uuid != null) {
            buf.writeBoolean(true);
            UUIDHelper.writeUUID(this.uuid, buf);
        } else {
            buf.writeBoolean(false);
            buf.writeFloat(this.x);
            buf.writeFloat(this.y);
            buf.writeFloat(this.z);
        }
        buf.writeInt(this.dim);
        buf.writeInt(this.color.getRGB());
        buf.writeByte(this.type.ordinal());
    }

    public static enum Type {
        EXCLAMATION,
        QUESTION;

    }
}

