/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.IInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickListeners {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws InvalidQuestArgsException {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.side == Side.SERVER) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerPartyStorage pps = Pixelmon.storageManager.getParty(player);
            QuestData data = pps.getQuestData(false);
            for (QuestProgress progress : data.getProgress()) {
                IInserter inserterPokemon;
                if (!progress.getQuest().isRadiant()) continue;
                IInserter inserterEntity = progress.getValidInserter(Inserter.ENTITY);
                if (inserterEntity != null) {
                    inserterEntity.execute(progress.getQuest(), progress.getCurrentStage(), data, progress, new Object[0]);
                }
                if ((inserterPokemon = progress.getValidInserter(Inserter.POKEMON)) == null) continue;
                inserterPokemon.execute(progress.getQuest(), progress.getCurrentStage(), data, progress, new Object[0]);
            }
            data.receiveMultiple(new String[]{"WORLD_TIME", "SERVER_TIME", "STRUCTURE", "ENTITY_VICINITY", "TILEENTITY_VICINITY", "RANDOM", "FOLLOWTHROUGH"}, new Object[][]{{player.func_71121_q().func_72820_D() % 24000L}, new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0]});
        }
    }
}

