/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.battle;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.Arrays;

public class AttackObjective
implements IObjective {
    private String identifier;

    public AttackObjective(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Inserter inserter() {
        return Inserter.NONE;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        Comparison comparison = new Comparison();
        String userSpec = "";
        String targetSpec = "";
        for (String arg : argsIn) {
            String[] split;
            if (arg.contains("=")) {
                split = arg.split("=");
                switch (split[0].toLowerCase()) {
                    case "soundbased": {
                        if (split[1].equalsIgnoreCase("true") || split[1].equalsIgnoreCase("yes")) {
                            comparison.soundBased = 1;
                            break;
                        }
                        comparison.soundBased = -1;
                        break;
                    }
                    case "count": {
                        comparison.count = Short.parseShort(split[1]);
                        break;
                    }
                    case "category": {
                        comparison.category = AttackCategory.valueOf(split[1]);
                        break;
                    }
                    case "type": {
                        comparison.type = EnumType.valueOf(split[1]);
                        break;
                    }
                    case "move": {
                        comparison.attacks = split[1].split(",");
                        break;
                    }
                    case "result": {
                        comparison.result = AttackResult.valueOf(split[1]);
                        break;
                    }
                    case "damage": {
                        comparison.setDamage(Mode.EQUAL, Integer.parseInt(split[1]));
                        break;
                    }
                    case "fulldamage": {
                        comparison.setFullDamage(Mode.EQUAL, Integer.parseInt(split[1]));
                        break;
                    }
                    case "accuracy": {
                        comparison.setAccuracy(Mode.EQUAL, Integer.parseInt(split[1]));
                    }
                }
                continue;
            }
            if (arg.contains("<")) {
                split = arg.split("<");
                switch (split[0].toLowerCase()) {
                    case "damage": {
                        comparison.setDamage(Mode.LESS, Integer.parseInt(split[1]));
                        break;
                    }
                    case "fulldamage": {
                        comparison.setFullDamage(Mode.LESS, Integer.parseInt(split[1]));
                        break;
                    }
                    case "accuracy": {
                        comparison.setAccuracy(Mode.LESS, Integer.parseInt(split[1]));
                    }
                }
                continue;
            }
            if (arg.contains(">")) {
                split = arg.split(">");
                switch (split[0].toLowerCase()) {
                    case "damage": {
                        comparison.setDamage(Mode.MORE, Integer.parseInt(split[1]));
                        break;
                    }
                    case "fulldamage": {
                        comparison.setFullDamage(Mode.MORE, Integer.parseInt(split[1]));
                        break;
                    }
                    case "accuracy": {
                        comparison.setAccuracy(Mode.MORE, Integer.parseInt(split[1]));
                    }
                }
                continue;
            }
            if (!arg.contains(":")) continue;
            if (arg.startsWith("user:")) {
                userSpec = userSpec + arg.substring(5) + " ";
                continue;
            }
            if (!arg.startsWith("target:")) continue;
            targetSpec = targetSpec + arg.substring(7) + " ";
        }
        if (userSpec != "") {
            comparison.userSpec = PokemonSpec.from(userSpec);
        }
        if (targetSpec != "") {
            comparison.targetSpec = PokemonSpec.from(targetSpec);
        }
        return new Object[]{comparison};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        return ((Comparison)objectiveArgsIn[0]).compare(argsIn);
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        return new ArrayList<QuestMarker>();
    }

    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return ((Comparison)objectiveArgsIn[0]).count;
    }

    static class Comparison {
        public short count = 1;
        public int soundBased = 0;
        public AttackCategory category = null;
        public EnumType type = null;
        public String[] attacks = null;
        public AttackResult result = null;
        public PokemonSpec userSpec = null;
        public PokemonSpec targetSpec = null;
        private Mode damageMode = null;
        private int damageValue = 0;
        private Mode fullMode = null;
        private int fullValue = 0;
        private Mode accuracyMode = null;
        private int accuracyValue = 0;

        Comparison() {
        }

        public String toString() {
            String ret = "AttackObjectiveComparison{count:" + this.count;
            if (this.soundBased != 0) {
                ret = ret + ", sound-based=";
                ret = ret + (this.soundBased == -1 ? "false" : "true");
            }
            if (this.category != null) {
                ret = ret + ", category=" + (Object)((Object)this.category);
            }
            if (this.type != null) {
                ret = ret + ", type=" + this.type;
            }
            if (this.attacks != null) {
                ret = ret + ", move=" + Arrays.toString(this.attacks);
            }
            if (this.userSpec != null) {
                ret = ret + ", user=" + this.userSpec;
            }
            if (this.targetSpec != null) {
                ret = ret + ", target=" + this.targetSpec;
            }
            if (this.damageMode != null) {
                ret = ret + ", damage" + (Object)((Object)this.damageMode) + this.damageValue;
            }
            if (this.fullMode != null) {
                ret = ret + ", fulldamage" + (Object)((Object)this.fullMode) + this.fullValue;
            }
            if (this.accuracyMode != null) {
                ret = ret + ", accuracy" + (Object)((Object)this.accuracyMode) + this.accuracyValue;
            }
            ret = ret + "}";
            return ret;
        }

        public boolean compare(Object[] argsIn) {
            if (Pixelmon.devEnvironment) {
                System.out.println("Comparing: " + this + " to " + Arrays.toString(argsIn));
            }
            Pokemon user = (Pokemon)argsIn[0];
            Pokemon target = (Pokemon)argsIn[1];
            Attack attack = (Attack)argsIn[2];
            MoveResults results = (MoveResults)argsIn[3];
            if (this.soundBased == -1 && attack.isSoundBased() || this.soundBased == 1 && !attack.isSoundBased()) {
                return false;
            }
            if (this.category != null && attack.getAttackCategory() != this.category) {
                return false;
            }
            if (this.type != null && attack.getType() != this.type) {
                return false;
            }
            if (this.attacks != null && !attack.isAttack(this.attacks)) {
                return false;
            }
            if (this.userSpec != null && !this.userSpec.matches(user)) {
                return false;
            }
            if (this.targetSpec != null && !this.targetSpec.matches(target)) {
                return false;
            }
            if (this.damageMode != null) {
                switch (this.damageMode) {
                    case LESS: {
                        if (results.damage < this.damageValue) break;
                        return false;
                    }
                    case EQUAL: {
                        if (results.damage == this.damageValue) break;
                        return false;
                    }
                    case MORE: {
                        if (results.damage > this.damageValue) break;
                        return false;
                    }
                }
            }
            if (this.fullMode != null) {
                switch (this.fullMode) {
                    case LESS: {
                        if (results.fullDamage < this.fullValue) break;
                        return false;
                    }
                    case EQUAL: {
                        if (results.fullDamage == this.fullValue) break;
                        return false;
                    }
                    case MORE: {
                        if (results.fullDamage > this.fullValue) break;
                        return false;
                    }
                }
            }
            if (this.accuracyMode != null) {
                switch (this.accuracyMode) {
                    case LESS: {
                        if (results.accuracy < this.accuracyValue) break;
                        return false;
                    }
                    case EQUAL: {
                        if (results.accuracy == this.accuracyValue) break;
                        return false;
                    }
                    case MORE: {
                        if (results.accuracy > this.accuracyValue) break;
                        return false;
                    }
                }
            }
            System.out.println("pass");
            return true;
        }

        public void setDamage(Mode mode, int value) {
            this.damageMode = mode;
            this.damageValue = value;
        }

        public void setFullDamage(Mode mode, int value) {
            this.fullMode = mode;
            this.fullValue = value;
        }

        public void setAccuracy(Mode mode, int value) {
            this.accuracyMode = mode;
            this.accuracyValue = value;
        }
    }

    static enum Mode {
        LESS("<"),
        EQUAL("="),
        MORE(">");

        private final String symbol;

        private Mode(String s) {
            this.symbol = s;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

