/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.quest;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;

public class Quest {
    public static Class<? extends Quest> standardQuest = Quest.class;
    private boolean radiant = false;
    private int weight = 0;
    private boolean abandonable = true;
    private boolean repeatable;
    private QuestColor color;
    private short activeStage = 1;
    private ArrayList<Stage> stages;
    private HashMap<String, String> strings;
    private transient HashMap<Short, Stage> mappedStages = new HashMap();
    private transient String filename;

    public Quest() {
        this.stages = new ArrayList();
        this.color = new QuestColor(255, 255, 0);
        this.strings = new HashMap();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void parseAndMap() throws InvalidQuestArgsException {
        for (Stage stage : this.stages) {
            stage.parse(this);
            this.mappedStages.put(stage.getStage(), stage);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getIdentityName() {
        return this.filename.replace(" ", "_").replace(".json", "");
    }

    public boolean isRadiant() {
        return this.radiant;
    }

    public QuestColor getColor() {
        return this.color;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public short getActiveStage() {
        return this.activeStage;
    }

    public ArrayList<Stage> getStages() {
        return this.stages;
    }

    public Stage getStage(QuestProgress progress) {
        Stage stage = this.mappedStages.get(progress.getStage());
        if (stage == null) {
            Stage previousStage = null;
            for (Stage s : this.stages) {
                if (s.getStage() > progress.getStage()) {
                    if (previousStage == null) {
                        progress.setStage((short)0);
                    } else {
                        progress.setStage(previousStage.getStage());
                    }
                    stage = this.mappedStages.get(progress.getStage());
                    break;
                }
                previousStage = s;
            }
        }
        return stage;
    }

    public Stage getStage(short stage) {
        for (Stage s : this.stages) {
            if (s.getStage() != stage) continue;
            return s;
        }
        return null;
    }

    public Stage getNextStage(short stage) {
        short next = -1;
        for (Stage s : this.stages) {
            if (s.getStage() >= next && next != -1 || s.getStage() <= stage) continue;
            next = s.getStage();
        }
        if (next == -1) {
            return null;
        }
        return this.getStage(next);
    }

    public String getUnlocalizedString(String key) {
        return this.getUnlocalizedString(key, null);
    }

    public String getUnlocalizedString(String key, @Nullable QuestProgress progress) {
        String string = this.strings.get(key);
        if (string == null || string.isEmpty()) {
            return ("quest." + this.getIdentityName() + "." + key).toLowerCase();
        }
        return string;
    }

    public static class Builder {
        private final Quest quest = new Quest();

        public Builder setRadiant(boolean radiant) {
            this.quest.radiant = radiant;
            return this;
        }

        public Builder setColor(QuestColor color) {
            this.quest.color = color;
            return this;
        }

        public Builder setRepeatable(boolean repeatable) {
            this.quest.repeatable = repeatable;
            return this;
        }

        public Builder setAbandonable(boolean abandonable) {
            this.quest.abandonable = abandonable;
            return this;
        }

        public Builder setWeight(int weight) {
            this.quest.weight = weight;
            return this;
        }

        public Builder setActiveStage(short activeStage) {
            this.quest.activeStage = activeStage;
            return this;
        }

        public Builder addString(String key, String value) {
            this.quest.strings.put(key, value);
            return this;
        }

        public Stage.Builder addStage() {
            return new Stage.Builder(this);
        }

        void addStage(Stage stage) {
            this.quest.stages.add(stage);
        }

        public Quest build(String identifier) throws InvalidQuestArgsException {
            this.quest.filename = identifier;
            this.quest.parseAndMap();
            return this.quest;
        }
    }
}

