/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LegendarySpawner
extends TickingSpawner {
    public int minDistFromCentre = PixelmonConfig.minimumDistanceFromCentre;
    public int maxDistFromCentre = PixelmonConfig.maximumDistanceFromCentre;
    public int horizontalSliceRadius = PixelmonConfig.horizontalSliceRadius;
    public int verticalSliceRadius = PixelmonConfig.verticalSliceRadius;
    public List<SpawnAction<?>> possibleSpawns = null;
    public boolean firesChooseEvent = true;

    public LegendarySpawner(String name) {
        super(name);
    }

    public static void fillNearby(ArrayList<EntityPlayerMP> allPlayers, ArrayList<EntityPlayerMP> cluster, EntityPlayerMP focus) {
        for (int i = 0; i < allPlayers.size(); ++i) {
            if (allPlayers.get(i) == focus || cluster.contains(allPlayers.get(i)) || !(focus.func_70032_d((Entity)allPlayers.get(i)) < 50.0f)) continue;
            EntityPlayerMP newFocus = allPlayers.get(i);
            cluster.add(newFocus);
            allPlayers.remove(newFocus);
            LegendarySpawner.fillNearby(allPlayers, cluster, newFocus);
        }
    }

    public void forcefullySpawn(@Nullable EntityPlayerMP onlyFocus) {
        ArrayList<ArrayList<EntityPlayerMP>> clusters = new ArrayList<ArrayList<EntityPlayerMP>>();
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v());
        if (onlyFocus == null) {
            while (!players.isEmpty()) {
                ArrayList<EntityPlayerMP> cluster = new ArrayList<EntityPlayerMP>();
                EntityPlayerMP focus = (EntityPlayerMP)players.remove(0);
                cluster.add(focus);
                LegendarySpawner.fillNearby(players, cluster, focus);
                clusters.add(cluster);
            }
        }
        this.isBusy = true;
        PixelmonSpawning.coordinator.processor.addProcess(() -> {
            if (onlyFocus != null) {
                this.possibleSpawns = this.doLegendarySpawn(onlyFocus);
            } else {
                Collections.shuffle(clusters);
                while (clusters.size() > 0) {
                    for (int i = 0; i < clusters.size(); ++i) {
                        EntityPlayerMP player = (EntityPlayerMP)CollectionHelper.getRandomElement((List)clusters.get(i));
                        ((ArrayList)clusters.get(i)).remove(player);
                        if (((ArrayList)clusters.get(i)).isEmpty()) {
                            clusters.remove(i--);
                        }
                        if (this.firesChooseEvent) {
                            LegendarySpawnEvent.ChoosePlayer event = new LegendarySpawnEvent.ChoosePlayer(this, player, clusters);
                            if (Pixelmon.EVENT_BUS.post((Event)event) || event.player == null) continue;
                            player = event.player;
                        }
                        this.possibleSpawns = this.doLegendarySpawn(player);
                        if (this.possibleSpawns == null) continue;
                        this.isBusy = false;
                        return;
                    }
                }
            }
            this.isBusy = false;
        });
    }

    @Override
    public List<SpawnAction<? extends Entity>> getSpawns(int pass) {
        if (pass == 0) {
            this.possibleSpawns = null;
            int numPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k();
            int baseSpawnTicks = this.firesChooseEvent ? PixelmonConfig.legendarySpawnTicks : PixelmonConfig.bossSpawnTicks;
            int spawnTicks = (int)((float)baseSpawnTicks / (1.0f + (float)(numPlayers - 1) * PixelmonConfig.spawnTicksPlayerMultiplier));
            this.spawnFrequency = RandomHelper.getRandomNumberBetween(0.6f, 1.4f) * (1200.0f / (float)spawnTicks);
            if (this.firesChooseEvent && !RandomHelper.getRandomChance(PixelmonConfig.getLegendaryRate()) || !this.firesChooseEvent && !RandomHelper.getRandomChance(PixelmonConfig.bossSpawnChance)) {
                return null;
            }
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k() > 0) {
                this.forcefullySpawn(null);
            }
            return null;
        }
        if (this.possibleSpawns != null && !this.possibleSpawns.isEmpty()) {
            return this.possibleSpawns;
        }
        return null;
    }

    public List<SpawnAction<?>> doLegendarySpawn(EntityPlayerMP target) {
        BlockCollection collection = this.getTrackedBlockCollection((Entity)target, 0.0f, 0.0f, this.horizontalSliceRadius, this.verticalSliceRadius, this.minDistFromCentre, this.maxDistFromCentre);
        ArrayList<SpawnLocation> spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations(collection);
        Collections.shuffle(spawnLocations);
        List<SpawnAction<?>> possibleSpawns = this.selectionAlgorithm.calculateSpawnActions(this, this.spawnSets, spawnLocations);
        if (possibleSpawns == null || possibleSpawns.isEmpty()) {
            return null;
        }
        possibleSpawns.forEach(spawnAction -> spawnAction.applyLocationMutations());
        return possibleSpawns;
    }

    @Override
    public int getNumPasses() {
        return 2;
    }

    public static class LegendarySpawnerBuilder<T extends LegendarySpawner>
    extends TickingSpawner.TickingSpawnerBuilder<T> {
        protected Integer minDistFromCentre = null;
        protected Integer maxDistFromCentre = null;
        protected Integer horizontalSliceRadius = null;
        protected Integer verticalSliceRadius = null;
        protected boolean firesChooseEvent = true;

        public <E extends LegendarySpawnerBuilder<T>> E setDistanceFromCentre(int minimum, int maximum) {
            if (minimum < 0) {
                minimum = 0;
            }
            this.minDistFromCentre = minimum;
            if (maximum < 0) {
                maximum = 0;
            }
            this.maxDistFromCentre = maximum;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        public <E extends LegendarySpawnerBuilder<T>> E setSliceRadii(int horizontal, int vertical) {
            if (horizontal < 1) {
                horizontal = 1;
            }
            this.horizontalSliceRadius = horizontal;
            if (vertical < 1) {
                vertical = 1;
            }
            this.verticalSliceRadius = vertical;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        public <E extends LegendarySpawnerBuilder<T>> E setFiresChooseEvent(boolean firesChooseEvent) {
            this.firesChooseEvent = firesChooseEvent;
            return (E)((LegendarySpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            super.apply(spawner);
            ((LegendarySpawner)spawner).minDistFromCentre = this.minDistFromCentre != null ? this.minDistFromCentre : PixelmonConfig.minimumDistanceFromCentre;
            ((LegendarySpawner)spawner).maxDistFromCentre = this.maxDistFromCentre != null ? this.maxDistFromCentre : PixelmonConfig.maximumDistanceFromCentre;
            ((LegendarySpawner)spawner).verticalSliceRadius = this.verticalSliceRadius != null ? this.verticalSliceRadius : PixelmonConfig.verticalSliceRadius;
            ((LegendarySpawner)spawner).horizontalSliceRadius = this.horizontalSliceRadius != null ? this.horizontalSliceRadius : PixelmonConfig.horizontalSliceRadius;
            ((LegendarySpawner)spawner).firesChooseEvent = this.firesChooseEvent;
            ((TickingSpawner)spawner).onSpawnEnded();
            return spawner;
        }
    }
}

